# Scalar induced gravitational waves review

Guillem Domènech∗‡ ID

$\ddagger$ INFN Sezione di Padova, I-35131 Padova, Italy

November 8, 2021

# Abstract

We provide a review on the state-of-the-art of gravitational waves induced by primordial fluctuations, so-called induced gravitational waves. We present the intuitive physics behind induced gravitational waves and we revisit and unify the general analytical formulation. We then present general formulas in a compact form, ready to be applied. This review places emphasis on the open possibility that the primordial universe experienced a different expansion history than the often assumed radiation dominated cosmology. We hope that anyone interested in the topic will become aware of current advances in the cosmology of induced gravitational waves, as well as becoming familiar with the calculations behind.

Keywords: Induced Gravitational Waves; Primordial Black Holes; Early universe; Inflation.

# Table of contents

1 Introduction 3   
1.1 Induced GWs history 4   
1.2 Structure and scope of the review 6   
2 Estimates and intuitive picture 8   
2.1 The spectral density of GWs in cosmology 8   
2.2 GWs induced by primordial fluctuations 10   
2.3 Primordial black hole counterpart 15   
3 General formalism . 16   
3.1 Derivation from the action 17   
3.2 General solutions . 19   
3.3 Inclusion of primordial non-Gaussianity 21

#

# 4 Analytical transfer functions 24

4.1 First order solutions 24   
4.2 General subhorizon kernel 27   
4.3 Superhorizon kernel approximation 32   
5 Typical induced GW spectra 34   
5.1 The GW spectral density today 34   
5.2 Dirac delta peak 34   
5.3 Log-normal peak 37   
5.4 Broken power-law 38   
5.5 Oscillatory features 42   
5.6 Impact of non-Gaussianities 43   
6 The dust dominated universe 44   
6.1 General dust domination 45   
6.2 PBH dominated era . 48   
7 The gauge issue 54   
7.1 The origin of the issue 55   
7.2 Current “solutions” 57   
8 Other GW sources related to PBH formation 60   
9 Current and future observational prospects 61   
10 Summary of main formulas 63   
10.1 General equation of state 64   
10.2 Dust domination. 66   
11 Conclusions 67   
A Useful formulas and numerical values 68   
B Green’s function method 69   
C ADM formalism. . 69   
D Fourier conventions and polarization tensors 70   
D.1 Spherical parametrisation. 70   
E Formulas in a general gauge 71   
E.1 Background. 71   
E.2 First order 72   
E.3 Second order . 72   
F Bessel functions 73   
G Integrals with two and three Bessel functions 73   
G.1 Superhorizon approximation 73   
G.2 Subhorizon approximation 74   
H Associated Legendre functions 75   
H.1 Asymptotic limits 75   
Bibliography 77

# 1 Introduction

Cosmology with Gravitational Waves (GWs) is a new and unique doorway to the primordial universe. The further in time we can observe with electromagnetic waves is around neutrino decoupling, roughly one second after the Big Bang and some time before Big Bang Nucleosynthesis (BBN). Prior to that, we have scarce evidence of the evolution of the primordial universe. See Ref. [1] for a review on possible expansion histories of the early universe. Nevertheless, we learned a lot from studies of the Cosmic Microwave Background1 (CMB). For instance, we know that there are Gaussian primordial fluctuations with an almost scale invariant spectrum [2,3], which by causality must have been generated before the Big Bang. This fact provides strong evidence that there was a period of accelerated expansion in the primordial universe, so-called inflation [4–7]. During inflation, quantum vacuum fluctuations are stretched out to the largest scales and become primordial fluctuations [8–12], which we later see as CMB anisotropies and galaxies. Thus, through the observation of primordial fluctuations we have access to inflation. However, the CMB only probes the largest scales and, therefore, only a small fraction of inflation. Any information on much smaller scales,2 and the last stages of inflation, is basically erased by complicated astrophysical processes. In contrast, GWs barely interact with intervening matter. This means that with GWs we can explore the universe before neutrino decoupling and even before the Big Bang towards the last stages of inflation. GWs provide a unique opportunity to complete our picture of the very early universe. A quantitative picture of the potential of cosmology with GWs can be found in Fig. 1.

GWs generated by a cosmological process in the early universe will appear today randomly distributed in all directions and with a very large number of unresolved sources. For example, take one source per Hubble patch and count how many Hubble patches at a given redshift fit the current universe. The number actually grows as $( 1 + z ) ^ { 3 }$ and we are talking about GWs generated at $z > 1 0 ^ { 1 0 }$ . On top of that, the angular resolution of GW detectors is not enough to pinpoint cosmic GWs generated in tiny Hubble patches. The superposition of all incoming unresolved GWs leads to the Stochastic GW Background (SGWB). Encouragingly, the typical frequency of such cosmic GWs falls right into the frequency range of future GWs detectors. For example, GWs generated when the universe had a temperature of around 1 GeV and $1 0 ^ { 1 0 }$ GeV, respectively have a typical (peak) frequency roughly around $1 0 ^ { - 8 } \mathrm { H z }$ and $1 0 0 \mathrm { H z }$ . Pulsar Timing Arrays (PTA) [13–18], cover around $1 0 ^ { - 9 } \sim 1 0 ^ { - 7 } \mathrm { H z }$ , LIGO, VIRGO, KAGRA and ET [19], are sensitive roughly for $1 0 \sim 1 0 ^ { 3 } \mathrm { H z }$ . In between, we will have LISA [20,21], DECIGO [22–24], AION/MAGIS [25], Taiji [26] and Tainqin [27]. For an illustration see Fig. 1.

Typical sources of cosmological GWs in the very early universe include (for more details see [28]): phase transitions, which may lead to collisions of bubbles or a universe filled with cosmic strings, resonances during reheating, quantum (gravity) fluctuations during inflation (so-called primordial GWs) and GWs induced from large primordial fluctuations. Such large primordial fluctuations may also collapse to form primordial black holes (PBHs). Out of these cosmological sources, GWs induced by primordial fluctuations, and to some extend PBHs, are our direct window to the latest stages of inflation. The information we could gain about inflation by the so-called induced GWs potentially covers scales around $k \sim 1 0 ^ { 7 } - 1 0 ^ { 1 8 } \mathrm { M p c ^ { - 1 } }$ , otherwise inaccessible by any other probe. Even the absence of induced GWs will place new constraints on the primordial spectrum in unexplored regimes, potentially down to $\mathcal { P } _ { \mathcal { R } } \sim 1 0 ^ { - 4 } - 1 0 ^ { - 5 }$ [29]. On top of these very promising prospects, induced GWs are generated when primordial fluctuations re-enter the horizon sometime between the end of inflation and BBN. Since we have no evidence of the content and expansion history of the universe around that time, induced GWs not only provide access to the last stages of inflation but they also contain information on the content of the primordial universe. In this review, we will be open to the possibility that the universe much before BBN was not dominated by radiation. In the future, information on the primordial spectrum obtained by induced GWs will complement those from other probes such as spectral distortions [30, 31] in the multimessenger cosmology era [32].

![](images/f7a10dd04f24b63fb194c5671a12535bdddd57f4658bfdb65705da28f08ce1d6.jpg)  
Figure 1: On the left we show the power-law integrated sensitivity curves [33] in terms of the GW spectral density for some GW detectors. In the lower and upper horizontal axis, we respectively show the GW frequency and the associated temperature of the universe at the time of GW generation, assuming radiation domination. On the right, we show the typical quantities associated to the cosmological horizon at a particular time, given in terms of ten-folds from matter-radiation equality. We also show the ranges covered by CMB anisotropies and $\mu$ spectral distortions, BBN constraints and GWs. If PBH form, they can be probed by induced GWs (iGW), emission of $\gamma$ rays and microlensing.

# 1.1 Induced GWs history

The possibility of having GWs induced by density fluctuations was first noticed, as far as the author is aware, by K. Tomita in 1967 [34]. They were later rediscovered in the 90’s by Matarrese, Pantano and Saez [35, 36] when studying second order cosmological perturbations in a dust dominated universe. Quite interestingly, in 1997 Matarrese, Mollerach and Bruni [37] noticed that induced GWs in a dust dominated universe suffer from gauge ambiguities. They proceeded to argue that only the oscillating part of the induced tensor modes were identified as true gravitational waves. We will discuss more about the gauge ambiguities in Sec. 7. However, Refs. [35–37] concluded that induced GWs were too small to be practically observed.

It was not until 20 years later that Ananda, Clarkson and Wands [38] started to uncover the potential of induced GWs. In Ref. [38] they proposed to use induced GWs, generated in a radiation dominated universe, to constrain the spectral tilt of primordial fluctuations. A blue tilted primordial spectrum even with the CMB normalization might end up yielding large enough induced GWs. Some months later, Baumann, Steinhardt, Takahashi and Ichiki [39] looked into more detail at the transfer function of induced GWs taking into account the radiation-matter equality at around $z \sim 3 4 0 0$ and the anisotropic stress due to neutrinos (see also [40] on the latter). They found that assuming the CMB normalisation of an almost scale invariant spectrum, modes with $k \sim k _ { \mathrm { e q } } \sim 0 . 0 1 \mathrm { M p c ^ { - 1 } }$ were enhanced due to the matter dominated stage. Notably, the peak in the induced GW background can be larger than the primordial one if the tensor to scalar ratio is $r < 0 . 1$ . However, the frequency of the peak of such GWs is extremely low, around $f _ { \mathrm { e q } } \sim 1 0 ^ { - 1 7 } \mathrm { H z }$ . This is only observable perhaps by CMB B-mode polarization experiments or cosmic shear [41]. Nevertheless, this was an indication that an early epoch of dust domination might yield interesting results. In the same period, Martineau and Brandenberger [42] derived a lower bound to induced GWs for various inflationary models and alternatives, although they referred to it as lower bound from “backreaction” of scalar fluctuations. Another application of GWs induced by primordial fluctuations in the curvaton scenario, sourced between the end of inflation and the curvaton decay, was studied by Bartolo, Matarrese, Riotto and Väihkönnen [43]. An action formalism for a scalar field acting as a perfect fluid and its induced GWs was studied by Boubekeur, Creminelli, Noreña and Vernizzi [44].

An important realization was done by Saito and Yokoyama in 2008 [45, 46]: if the primordial spectrum of fluctuations is large enough on small scales, it does not only induce GWs but might also collapse to form PBHs. This means that the induced GW spectrum can be used in the future to place bounds on the PBH abundance. Even more, if PBHs were found, one should also find the induced GW counterpart. These ideas were further pursued by Bugaev and Klimai [47–49]. Extending the work of Saito and Yokoyama a bit further, Assadullahi and Wands proposed induced GWs as probes of the primordial spectrum [50]. They also considered the early dust dominated case [51] which confirmed the large enhancement of induced GWs. The same group, now including Arroja, Assadullahi, Koyama and Wands [52], studied the matching conditions on superhorizon scales for such GWs induced at second order. Later, in 2012 the induced GWs from particular models of inflation were studied by Alabidi, Kohri, Sasaki and Sendouda in radiation [53] and dust domination [54]. Around the same time, a curvaton scenario with a blue tilted primordial spectrum yielding large induced GWs was proposed by Kawasaki, Kitajima and Yokoyama [55]. More investigations on the upper bounds of induced GWs by overproduction of PBHs were done by Nakama and Suyama [56, 57]. Other works related to induced GWs include the decay of two curvatons by Suyama and Yokoyama [58], the impact of anisotropic stress due to free streaming particles by Saga, Ichiki and Sugiyama [59] and the B-modes due to induced GWs in the CMB by Fidler et al. [60].

In 2016 LIGO reported the detection of GWs from the merger of a binary black hole [61] and the amount of new works on induced GWs and their PBH counterpart exploded. The amount of works is so large that we will not attempt to go through all of them in chronological order but instead we will classify them into seven main directions below. We give a more detailed discussion in the corresponding sections.

– General semi-analytical formulation: Since induced GWs are a second order effect one needs to integrate in time and momenta over the linear evolution of primordial fluctuations. The analytical transfer functions for radiation domination are derived in Refs. [62, 63] and later generalized to constant equation of state parameter in Ref. [64].

– Induced GWs for different expansion histories and different contents of the universe: Induced GWs may have been generated in a non-radiation dominated universe. This leaves characteristic signatures in the induced GW spectrum. Studies in early matter era can be found in Refs. [65–67]. The extension to an early PBH dominated epoch is investigated in Refs. [68–71]. More general thermal histories are studied in Refs. [64, 72–76]. The impact of additional free streaming particles is studied in Ref. [77].

– Induced GW spectral features: There are cases where the induced GW spectrum may be investigated semi-analytically. These are for example, the low frequency tail [74, 78, 79], the UV tail [80, 81] and the log-normal peak in the primordial spectrum [82]. Furthermore, the primordial spectrum may also present oscillatory features which are captured into the induced GW spectrum [83–87]. On top of that, large primordial non-Gaussianities may have a nontrivial impact on the induced GW spectrum [81, 88–93]. Other effects include: anisotropic non-gaussianities, which may be a source of superhorizon tensor modes [94], resonances that may occur during inflation, which enhance the induced GW spectrum [95–98], and non-Bunch Davies initial conditions in inflation [99], although the latter does not yield an observable signature.

– Explanations of current observations: Induced GWs have been extensively used as counterpart of the PBH scenario as a totality or a fraction of dark matter. For example, the induced GWs from various inflationary models can be found in Refs. [100–118] and [62, 116, 119, 120] in the context of Higgs inflation. In particular, the large induced GW counterpart to PBH as the totality of dark matter is studied in Refs. [88, 110, 121–125]. Other possibilities include an explanation to the LIGO observations [121, 126–128] and the NANOGrav results [129–135].

Current and future GW constraints: It is important to place constraints on the current absence of induced GWs and also asses future capabilities to constraint/find different models. A study using current PTA and LIGO data on SGWBs can be found in Refs. [136–139] and an analysis of future GW prospects in Refs. [32, 75, 140–146].

– SGWB anisotropies: In the far future we may not only observe the GW spectrum but also its anisotropies. The anisotropies due to induced GWs associated to PBH formation in the case of a monochromatic mass function are investigated in Refs. [122, 123, 147, 148].

– The gauge issue of induced GWs: Tensor modes are subject to gauge ambiguities at second order due to mode mixing. Since the work of Hwang, Jeong and Noh [149] in 2017 there has been an extensive discussion on the gauge issue of induced GWs [150–162]. The source of the problem and the applicability of predictions is by now well understood, although the gauge issue persists in the strictest sense.

# 1.2 Structure and scope of the review

Induced GWs are the most promising probe of the primordial universe. In this review, we will revisit and unify the current analytical formulation and main predictions for induced GWs. Note that the scope of this review is basically limited to the author’s works on induced GWs $[ 6 4 , 7 0 , 7 ]$ , 74, 81, 132, 150, 161], although we discuss and properly cite the relevant literature. As interesting as it is, we will not enter in the details of PBH formation nor on the GW data analysis. Nevertheless, we briefly discuss these relevant topics and give appropriate credit, when needed.

For convenience, we proceed to briefly explain the organization of the review. In this way, the reader interested in certain aspects may jump directly to the relevant section. In sec. 2 we present an intuitive picture of the induced GW generation. We estimate their typical frequency, the spectral shape and we briefly comment on their PBH counterpart for different expansion histories in the primordial universe. The details of the calculations and derivation of analytical approximations are reviewed in Secs. 3 and 4. The analytical approximations for the induced GW spectrum for typical primordial curvature spectra are presented in 5. The special case of the dust dominated universe is discussed in some detail in Sec. 6. We also include the case where PBH dominate the universe in Sec. 6.2. The gauge issue of induced GWs is explained in Sec. 7. We list other GW counterparts associated to PBHs in Sec. 8 and discuss the future observational prospects in Sec. 9. We also provide a summary of the main formulas in Sec. 10. These formulas are ready for calculating the induced GW spectrum for general primordial spectra. Thus, the reader interested solely in the final formulas of the induced GW may jump directly to Sec. 5 and/or Sec. 10.. We end with a discussion on future directions in the conclusions Sec. 11. We present many details of the numerical factors, formulas and calculations used in the main text in the Appendices.

We work in natural units where $\hbar = c = 1$ . We keep the reduced Planck mass $M _ { \mathrm { p l } } = ( 8 \pi G ) ^ { - 1 / 2 }$ in the equations, except in Secs. 2.2 and 4 where for simplicity in the calculations we set it to $M _ { \mathrm { p l } } = 1$ . At the beginning of each section we list the literature in which the section is based, except for Secs. 8 and 9 which are relatively short. We provide a list of useful related reviews below.

A list of other useful reviews. The context of induced GWs is very broad. It covers cosmological perturbation theory up to second order, stochastic GW backgrounds, primordial black holes and primordial non-Gaussianity. Unfortunately, all the details cannot be covered in this review. Instead, we list below existing reviews on topics directly related to induced GWs, which have been useful in writing this manuscript.

• Cosmological perturbation theory. The classical reviews on cosmological perturbation theory at linear order are the one by Kodama and Sasaki [12] and by Mukhanov, Feldman and Brandenberger [163]. A typical reference for second order cosmological perturbation theory is the review by Malik and Wands [164]. Since then there have been many other reviews on cosmological perturbation theory. Some that we found particularly up to date and useful are Refs. [165–168]. For a take on multi-field inflation we suggest Ref. [169]. For primordial features in the primordial spectrum we refer the reader to Ref. [170].

• Stochastic GW backgrounds. Induced GWs are not the only source of GW backgrounds. Reviews on the different cosmic and astrophysical sources can be found in the review by Caprini and Figueroa [28] and by Christensen [171]. A useful collection of cosmic GW spectra can be found in Kuroyanagi, Chiba and Takahashi [172], although it is technically not a review. A review focused on GWs from inflation is given by Guzzetti, Bartolo, Liguori and Matarrese [173].

• Primordial black holes. The literature on primordial black holes is very vast and currently under refinement. A review that has been used in particular is the one by Sasaki, Suyama, Tanaka and Yokoyama [174]. Other interesting reviews are Refs. [175–178]. A complementary review on induced GWs with more focus on the PBH counterpart is given by Yuan and Huang [179].   
• Primordial non-Gaussianity. Although quantum fluctuations during inflation are drawn from a Gaussian distribution, they can develop small departures from such Gaussian distribution due to gravitational or general interactions. The reader interested in primordial nonGaussianities may check the reviews in the context of inflation and CMB observations, e.g., [180–183].   
• Alternative expansion histories. A recent review encompassing many of the new physics of a primordial universe which is not filled with radiation is given in Ref. [1].

# 2 Estimates and intuitive picture

In this section we present the intuitive physical picture behind induced GWs. We do not intend to do a rigorous derivation but to lay out the basic assumptions behind the calculations. Before we go into the details of the induced GWs themselves, we first review in Sec. 2.1 what is considered to be the “observable” quantity for cosmic GWs. This will also be useful when dealing with the gauge issue in Sec. 7. We later in 2.2 derive intuitively, based on heuristic calculations and order of magnitude estimations, the main features of the induced GW spectrum in general cosmological backgrounds. Lastly in Sec. 2.3, we give the relation between the typical frequencies of the induced GWs with the corresponding PBH masses also in general cosmological backgrounds.

 Main references: Section 2.1 is mainly based on Misner, Thorne and Wheeler’s [184] and Maggiore’s [185] books, while the original work is essentially due to Isaacson [186, 187]. We follow the notation of, e.g., Ref. [78, 161]. Sec. 2.2 essentially follows from [74] although it builds up from previous works in the literature, e.g., [39, 63, 64, 78]. Sec. 2.3 is mainly extracted from [64, 132, 174]. All relevant equations can be found in App. E.

# 2.1 The spectral density of GWs in cosmology

A GW detector, such as an interferometer, measures the GW strain at a given frequency and time. In the case of the SGWB, one is measuring the time and/or ensemble average of the superposition of all incoming GWs. For convenience, cosmologists often use the energy density fraction of GWs as the “observable”. However, it is not an easy task to theoretically associate an energy density to GWs in general situations. This is because in general relativity there is no local notion of energy of the gravitational field. By the equivalence principle, one may always go to a locally flat frame and erase any sign of gravity. Of course, we know that GWs carry momentum and energy (after all, they have been detected). Thus, indeed one can define the energy of GWs in some limits of interest. For instance, when the frequency of the GW is much higher than that of a slowly varying background [185].

Relevant to the later discussion, let us briefly review the case of GWs propagating in a Ricci flat spacetime, i.e., a spacetime with no matter sources. We can then split the total metric as $g _ { \mu \nu } = \bar { g } _ { \mu \nu } + h _ { \mu \nu }$ where $g _ { \mu \nu }$ is the background metric and $h _ { \mu \nu } \ll 1$ are the GWs, treated as a high frequency perturbation. Then, by the non-linear nature of gravity, these GW backreact onto the background metric. Mathematically speaking, if we expand the Einstein tensor up to second order we will find terms quadratic in $h _ { \mu \nu }$ which can be thought of as a “matter” source. This means that, if we somehow “integrate out” the high frequency perturbation, we can write3

$$
\bar { G } _ { \mu \nu } [ \bar { g } _ { \mu \nu } ] = M _ { \mathrm { p l } } ^ { - 2 } t _ { \mu \nu } ^ { \mathrm { G W } } [ h _ { \mu \nu } ] ,
$$

where $G _ { \mu \nu }$ is the Einstein tensor and $t _ { \mu \nu } ^ { \mathrm { G W } }$ is the (pseudo)-energy momentum tensor of GWs. A way to “integrate out” the high frequency modes is by taking an average. For instance, we may focus on a small box and take the volume (and/or time) average. The box shall not be too small, so that several GW wavelengths fit in. In this case, we have that the (pseudo)-energy momentum tensor of GWs reads [186, 187]

$$
t _ { \mu \nu } ^ { \mathrm { G W } } = \frac { M _ { p l } ^ { 2 } } { 4 } \bigg \langle \partial _ { \mu } h ^ { \alpha \beta } \partial _ { \nu } h _ { \alpha \beta } - \frac { 1 } { 2 } \bar { g } _ { \mu \nu } \partial _ { \sigma } h ^ { \alpha \beta } \partial ^ { \sigma } h _ { \alpha \beta } \bigg \rangle ,
$$

where all contractions of indices are done with the background metric.

In cosmology we face the extra difficulty of having a matter source to the Einstein equations which drives the expansion of the universe. Because of the expansion, we also have a cosmological horizon roughly given by $1 / H$ where $H$ is the Hubble parameter and quantifies the expansion rate. For these reasons, the definition of GWs in a cosmological background is more subtle than in Ricci flat spacetimes. Nevertheless, with some tweaks we shall write in analogy

$$
G _ { \mu \nu } = M _ { \mathrm { p l } } ^ { - 2 } \left( T _ { \mu \nu } + t _ { \mu \nu } ^ { \mathrm { G W } } \right) ,
$$

where $T _ { \mu \nu }$ is the matter energy-momentum tensor. This time, however, we must be more careful on the averaging procedure. Furthermore, we must introduce a slightly different, but important, notation. First, in the helicity decomposition of the metric, the transverse-traceless component of the spatial metric is referred to as tensor mode. A tensor mode with a comoving wavenumber $k$ stays constant if its physical size is larger than the cosmological horizon, i.e., $k / a \ll H$ . In the opposite limit, a tensor mode behaves as a GW if its physical size is much smaller than the cosmological horizon, that is $k / a \gg H$ . Thus, Eq. (2.3) only makes sense for the high frequency tensor modes deep inside the horizon. This also means that the small boxes we used to take the average have to be much smaller than the horizon size but still larger than several GW wavelengths. In addition to that, in cosmology we often deal with a SGWB and, by ergodicity, we may take an ensemble average over all small boxes. Under these assumptions we may use Eq. (2.2) to compute the energy density of GWs in cosmology. Be aware though that these assumptions are strictly speaking not enough as we shall argue in Sec. 7.

Proceeding with the cosmological SGWB, we consider GWs propagating in a Friedmann-LemaîtreRobertson-Walker (FLRW) metric, namely4

$$
d s ^ { 2 } = - d t ^ { 2 } + a ^ { 2 } ( t ) ( \delta _ { i j } + h _ { i j } ) d x ^ { i } d x ^ { j } \ : ,
$$

where $a ( t )$ is the scale factor. The evolution of the scale factor is dictated by the Friedmann equations, which we provide in App. E. Using Eq. (2.2) under the ensemble average procedure, we find that the energy density of GWs (the 00 component of $t _ { \mu \nu } ^ { \mathrm { G W } }$ ) in Fourier space (see App. D for notations) reads

$$
\rho _ { \mathrm { G W } } = M _ { \mathrm { p l } } ^ { 2 } \int d \ln k { \frac { k ^ { 3 } } { 1 6 \pi ^ { 2 } } } \left\{ \sum _ { \lambda } \langle \dot { h } _ { k , \lambda } \dot { h } _ { - k , \lambda } \rangle ^ { ! } + { \frac { k ^ { 2 } } { a ^ { 2 } } } \langle h _ { k , \lambda } h _ { - k , \lambda } \rangle ^ { ! } \right\} ,
$$

where $\dot { \mathbf { \eta } } \equiv d / d t$ , $\lambda$ is the GW polarization and we already used that the coincident ensemble average of two tensor modes in a homogeneous and isotropic universe is proportional to a Dirac delta,5 namely

$$
\langle h _ { { \pmb k } , \lambda } h _ { { \pmb k } ^ { \prime } , \lambda } \rangle = \langle h _ { { \pmb k } , \lambda } h _ { - { \pmb k } , \lambda } \rangle ^ { \downarrow } ( 2 \pi ) ^ { 3 } \delta ^ { ( 3 ) } ( { \pmb k } + { \pmb k } ^ { \prime } ) .
$$

The notation "!" in Eqs. (2.5) and (2.6) is to indicate that the Dirac delta has been factored out, so that $\langle h _ { \pmb { k } , \lambda } h _ { - \pmb { k } , \lambda } \rangle ^ { \ ! }$ is directly related to the power spectrum, which by isotropy is a function of $k = | k |$ only. Eq. (2.5) is the total energy density of the GWs filling the universe. It is often more convenient to use the spectral density fraction, i.e., the GW power per logarithm of a given wavenumber $k$ (or frequency) over the critical density, which is defined as

$$
\Omega _ { \mathrm { G W } } ( k ) \equiv { \frac { 1 } { 3 M _ { \mathrm { p l } } ^ { 2 } H ^ { 2 } } } { \frac { d \rho _ { \mathrm { G W } } } { d \ln k } } = { \frac { k ^ { 2 } } { 1 2 a ^ { 2 } H ^ { 2 } } } \sum _ { \lambda } { \mathcal P } _ { h , \lambda } ( k ) ,
$$

where $H \ = \ \dot { a } / a$ . This is often what is used to compare theoretical predictions with current constraints and future observational prospects. Note that in Eq. (2.7) we used the definition of the dimensionless power spectrum, concretely

$$
\langle h _ { { \pmb k } , \lambda } h _ { - { \pmb k } , \lambda } \rangle ^ { ! } = \frac { 2 \pi ^ { 2 } } { k ^ { 3 } } \mathcal { P } _ { h , \lambda } ( k ) .
$$

We also used the approximation that for a freely propagating wave we have that

$$
\dot { h } _ { { \pmb k } , \lambda } \approx \frac { k } { a } h _ { { \pmb k } , \lambda } .
$$

With these ingredients we can use Eq. (2.7) to estimate the amplitude and spectral shape of induced GWs.

# 2.2 GWs induced by primordial fluctuations

Let us derive some estimates by considering a rough, yet instructive, toy model for induced GWs. Take a tensor mode $h _ { i j }$ in a FLRW background (2.4) sourced by scalar field fluctuations $\delta \varphi$ . Its equations of motion, in terms of conformal time $d \tau = d t / a$ , read

$$
h _ { i j } ^ { \prime \prime } + 2 \mathcal { H } h _ { i j } ^ { \prime } - \partial _ { k } \partial ^ { k } h _ { i j } = \mathcal { P } ^ { a b } { } _ { i j } \left\{ T _ { a b } \right\} \approx \mathcal { P } ^ { a b } { } _ { i j } \left\{ \partial _ { a } \delta \varphi \partial _ { b } \delta \varphi \right\} ,
$$

where $\ l ^ { \prime } \equiv d / d \tau$ , $\mathcal { H } = H / a = a ^ { \prime } / a$ , $T _ { i j }$ is the spatial components of the energy-momentum tensor of a scalar field (see Eq. (3.12)) and $\mathcal { P } ^ { a b } { } _ { i j }$ is the transverse-traceless projector defined in App. E.

Without understanding much about the evolution of these fluctuations, we can already see that

$$
\mathcal { P } _ { h } \equiv \sum _ { \lambda } \mathcal { P } _ { h , \lambda } \propto \mathcal { P } _ { \delta \varphi } ^ { 2 } .
$$

If the scalar field fluctuations were sourced during inflation, we can relate them to the curvature perturbation $\mathcal { R }$ so that $\mathcal { P } _ { \delta \varphi } \sim \mathcal { P } _ { \mathcal { R } }$ . Furthermore, the spectral density of GWs in a radiation dominated universe remains constant, as GWs behave as radiation themselves. Thus, we can boldly estimate that the amplitude of induced GW spectral density measured today is given by

$$
\Omega _ { \mathrm { G W } } ^ { \mathrm { i n d u c e d } } h ^ { 2 } \sim \frac { 1 } { 1 2 } \Omega _ { r , 0 } h ^ { 2 } \times \mathcal { P } _ { \mathcal { R } } ^ { 2 } ,
$$

where $\Omega _ { r , 0 } \equiv \rho _ { r , 0 } / ( 3 H _ { 0 } ^ { 2 } M _ { \mathrm { p l } } ^ { 2 } )$ is the density fraction of radiation, $H _ { 0 }$ is the Hubble rate today and $h \equiv H _ { 0 } / ( 1 0 0 k m / M p c / s )$ . We have introduced $\Omega _ { r , 0 }$ to take into account the dilution of the GWs (as radiation) as the universe expands and goes through the cold dark matter and dark energy dominated stages. We give more details on this factor in Sec. 5. $h$ considers the uncertainty in the exact value of $H _ { 0 }$ . From the latest Planck 2018 results [2] we have that $\Omega _ { r , 0 } h ^ { 2 } \approx 4 \times 1 0 ^ { - 5 }$ . With all the above simplifications, we arrive at

$$
\Omega _ { \mathrm { G W } } ^ { \mathrm { i n d u c e d } } h ^ { 2 } \sim 1 0 ^ { - 6 } { \mathcal P } _ { \mathcal R } ^ { 2 } .
$$

The estimate (2.13) can be now contrasted with future observational prospects. The sensitivity of future GW detectors after collecting data over several years might reach $\Omega _ { \mathrm { G W } } ^ { \mathrm { i n d u c e d } } h ^ { 2 } \sim 1 0 ^ { - 1 6 }$ , if we use the power-law sensitivity curves of Thrane and Romano [33]. This optimistic value is for the best DECIGO sensitivity [23, 188]. Then, in the absence of an induced GW detection we can use Eq. (2.13) to place an optimistic upper bound to the primordial spectrum on the corresponding scales (roughly at $1 0 ^ { 1 6 } – 1 0 ^ { 1 2 } ~ \mathrm { M p c ^ { - 1 } }$ ) of about $\mathcal { P } _ { \mathcal { R } } < 1 0 ^ { - 5 }$ . This is already 3 orders of magnitude better than current constraints from the absence of PBHs (around $\mathcal { P } _ { \mathcal { R } } < 1 0 ^ { - 2 }$ [174]), although it is still 4 orders of magnitude above the CMB extrapolation which would be around $\mathcal { P } _ { \mathcal { R } } \sim 1 0 ^ { - 9 }$ [3]. The most interesting point though is that PBHs which formed by the collapse of large primordial fluctuations, which requires $\mathcal { P } _ { \mathcal { R } } \gtrsim 1 0 ^ { - 2 }$ , must have an observable large induced GW counterpart. Thus, the absence of induced GWs completely rules out the PBH scenario from large primordial fluctuations [189,190]. Note that PBH could have formed by other mechanisms though. For example, PBH could form in first order phase transitions [191, 192], tunnelling during inflation [193], the collapse of Q-balls [194, 195] and might also be the result of long range interactions stronger than gravity [196–198].

In the above estimations we have completely neglected the evolution of the scalar fluctuations since the end of inflation onwards, which is by no means irrelevant. As shown in Refs. [51,54,65,66], a period of dust domination might substantially enhance the amplitude of induced GWs. The amplification is such that GWs induced by tiny primordial fluctuations might observable [54, 66]. This case exemplifies the importance of the expansion history of the primordial universe. At this point, we would like to emphasise that contrary to studies of the CMB we have scarce evidence of the content of the primordial universe. Therefore, when deriving theoretical predictions, and eventually contrasting them with the data, it would be a good idea to be open and acknowledge our ignorance by allowing a free equation of state parameter $w \equiv \rho / p$ and a free propagation speed of fluctuations $c _ { s }$ , which describe the unknown content of the primordial universe. A nice review on the implications of various expansion histories can be found in Ref. [1]. For these reasons, let us estimate the general impact of the equation of state $w$ and sound speed $c _ { s }$ onto the induced GW spectrum. To do that, we continue with the toy model of the scalar field. This time, however, we will consider the evolution of $\delta \varphi$ . Fluctuations of a $K$ -essence massless scalar field roughly follow the Klein-Gordon equation

$$
\delta \varphi _ { k } ^ { \prime \prime } + 2 \mathcal { H } \delta \varphi _ { k } ^ { \prime } + c _ { s } ^ { 2 } k ^ { 2 } \delta \varphi _ { k } = 0 ,
$$

where for simplicity we considered a constant $w$ and $c _ { s }$ . The former implies constant expansion rate, i.e.,

$$
\epsilon \equiv - \frac { \dot { H } } { H ^ { 2 } } = \frac { 3 } { 2 } ( 1 + w ) = \mathrm { c o n s t a n t } .
$$

Such constant expansion rate implies a scale factor which goes as a power-law of conformal time, explicitly from the Eqs. in App. $\mathrm { E }$ we have

$$
a \propto \tau ^ { 1 + b } \quad \mathrm { w h e r e } \quad b = \frac { 1 - 3 w } { 1 + 3 w } .
$$

We introduced the parameter $b$ for later convenience. $b = 0$ corresponds to a universe filled with radiation ( $w = 1 / 3$ ). Then, $b < 0$ and $b > 0$ respectively correspond to a stiffer and softer fluid. Note that if we allow $w \gg 1$ the range of $b$ goes as $- 1 < b < \infty$ for $\infty > w > - 1 / 3$ .

For the sake of simplicity, we solve the Klein-Gordon equation (2.14) in the super-(sound)horizon, $c _ { s } k \ll \mathcal { H }$ , and sub-(sound)horizon, $c _ { s } k \gg \mathcal { H }$ , limits. This leads us to

$$
\delta \varphi _ { k } \approx \delta \varphi _ { i } \left\{ \begin{array} { l l } { { \mathrm { c o n s t a n t } } } & { { c _ { s } k \tau \ll 1 } } \\ { { a ^ { - 1 } e ^ { i c _ { s } k \tau } } } & { { c _ { s } k \tau \gg 1 } } \end{array} \right. ,
$$

where $\delta \varphi _ { i }$ is an initial value. The above solutions are all we need to solve for the induced GWs. For analytical viability, let us take that there are fluctuations of the scalar field only in a single scale $k _ { p }$ . Namely the scalar fluctuations are Dirac-delta like in Fourier space, i.e.,

$$
\delta \varphi _ { i } \sim \delta \varphi _ { p } \times \delta ( \ln ( k / k _ { p } ) ) ,
$$

where $\delta \varphi _ { p }$ is the primordial amplitude, e.g., set by inflation. All the above simplifications lead to a simple differential equation for the tensor modes given by

$$
h _ { k } ^ { \prime \prime } + 2 \mathcal { H } h _ { k } ^ { \prime } + k ^ { 2 } h _ { k } \approx k _ { p } ^ { 2 } \delta \varphi _ { p } ^ { 2 } .
$$

We readily see that, if we focus on $\delta \varphi _ { p } = \mathrm { c o n s t a n t }$ and we evaluate $h _ { k }$ at horizon crossing, that is when the mode $k$ is of the size of the comoving horizon, i.e., $k = a H$ , then the amplitude of induced GWs is proportional to $h _ { k } \sim \delta \varphi _ { p } ^ { 2 }$ for $k \sim k _ { p }$ , as used in our previous estimate (2.12). Now, to derive the spectral features we can focus on two interesting limits: $( i )$ the infra-red (IR) tail for modes with $k \ll k _ { p }$ and $( i i )$ the near peak behaviour for modes with $k \sim k _ { p }$ .

# 2.2.1 The IR tail

If we focus on modes with $k \ll k _ { p }$ there will be no competition between the $k ^ { 2 }$ and $k _ { p } ^ { 2 }$ terms nor any resonance. Thus, we can peacefully solve the tensor modes in the superhorizon ( $k \tau \ll 1$ ) and subhorizon ( $k \tau \gg 1$ ) regimes. First, in the superhorizon regime we find that

$$
\begin{array} { r } { h ( k \tau \ll 1 ) \approx \left\{ \begin{array} { l l } { ( k _ { p } \tau ) ^ { 2 } } & { c _ { s } k _ { p } \tau \ll 1 } \\ { \mathrm { c o n s t a n t } + ( k _ { p } \tau ) ^ { - 2 b } } & { c _ { s } k _ { p } \tau \gg 1 } \end{array} \right. . } \end{array}
$$

What Eq. (2.20) tells us is that tensor modes initially grow as $\tau ^ { 2 }$ due to a constant source. Then, after the scalar source enters the sub(sound)-horizon regime, i.e., at $c _ { s } k _ { p } \tau _ { p } = 1$ , the tensors developed a constant amplitude. Now, if $b > 0$ ( $w < 1 / 3$ ) the scalar source decays much faster than the cosmological background, that is $\delta \varphi _ { k } ^ { 2 } / \mathcal { H } ^ { 2 } \propto ( k \tau ) ^ { - b } \to 0$ , and the tensor growth stops. However, for $b < 0$ ( $w > 1 / 3$ ) the scalar source decays slower than the background expansion which yields a second superhorizon growth of the tensor modes [74]. To follow tensor mode evolution, the second line of Eq. (2.20) has to be matched at horizon crossing for the tensor mode ( $k \tau = 1$ ) with the subhorizon solution. By doing so, we arrive at

$$
h ( k \tau \gg 1 ) \approx ( k \tau ) ^ { - 1 - b } e ^ { i k \tau } \left( \mathrm { c o n s t a n t } + ( k _ { p } / k ) ^ { - 2 b } \right) .
$$

The final ingredient is that somehow the universe transitions to a radiation dominated universe to recover the standard cosmology. For simplicity, we take an instantaneous reheating at $\tau = \tau _ { \mathrm { r h } }$ with the corresponding reheating scale $k _ { \mathrm { r h } } = \mathcal { H } _ { \mathrm { r h } }$ . From that moment on the spectral density of induced GWs stays constant and we can derive our predictions. Inserting Eq. (2.21) evaluated at $\tau = \tau _ { \mathrm { r h } }$ into Eq. (2.5) we find that the IR slope of the induced GW spectrum is in general given by

$$
\frac { d \ln \Omega _ { \mathrm { G W } } ^ { \mathrm { i n d u c e d } } } { d \ln k } ( k _ { \mathrm { r h } } \ll k \ll k _ { p } ) \approx 3 - 2 | b | .
$$

We later find that for $\beta \in \mathbb { Z }$ there is a logarithmic correction [74]. Also, if the scalar spectrum of fluctuations is really a Dirac delta, the spectrum slope is given by $2 - 2 | b |$ due to the unphysical divergence of $\delta \varphi _ { p }$ at $\begin{array} { r } { k \ = \ k _ { p } } \end{array}$ . Note that for tensor modes which entered during the radiation domination era we have to match the first line of (2.20) to the subhorizon solution. This yields a spectral index given by

$$
\frac { d \ln \Omega _ { \mathrm { G W } } ^ { \mathrm { i n d u c e d } } } { d \ln k } ( k \ll k _ { \mathrm { r h } } ) \approx 3 ,
$$

in agreement with the general results of Ref. [78]. These naive derivations will be later recovered from the analytical formulas in Sec. 4. It is interesting to see that for $b > 3 / 2$ ( $w < - 1 / 1 5$ ) the induced GW spectrum peaks at $k \sim k _ { \mathrm { r h } }$ which is clearly different than the peak in the primordial spectrum at $k \sim k _ { p }$ .

The intuitive physical picture behind (2.22) is the following. In a universe with constant $b$ , modes of a massless field (e.g., the tensor modes $h _ { i j }$ or the scalar field $\delta \varphi$ ) which enter the horizon early get more diluted than modes which enter later. For example, consider that right after horizon crossing, i.e., when $\boldsymbol { k } = \mathcal { H } _ { k }$ , we have that the energy density of the massless field starts to dilute as $\rho \propto$ (ak/a)4. Since we have that ak ∝ τ 1+bk ∝ k−1−b then ρ ∝ a4k ∝ k−4b and ρ/H2 ∝ a−2b/(1+b) ∝ k−2b. Thus, if the IR tail of induced GWs in radiation domination goes as $k ^ { 3 }$ , we expect $\Omega _ { \mathrm { G W s } } \propto k ^ { 3 - 2 b }$ due to dilution [78]. However, as we have shown, this is incomplete for induced GWs from a peaked spectrum. For $b < 0$ , the density fraction of the scalar field $\rho _ { \delta \varphi }$ grows as $a ^ { - 2 b / ( 1 + b ) }$ . This means that induced tensor modes which are generated later have a larger source and a larger amplitude than those generated earlier. In other words, for $b \ < \ 0$ small $k$ have a larger amplitude than large $k$ by a factor $a _ { k } ^ { - 4 } \propto k ^ { 4 b }$ . Then, for $b \ < \ 0$ the density fraction of induced GWs goes as $\Omega _ { \mathrm { G W s } } \propto k ^ { 3 - 2 b + 4 b } \propto k ^ { 3 + 2 b }$ [74]. This gives the general formula $\Omega _ { \mathrm { G W s } } \propto k ^ { 3 - 2 | b | }$ that we derived in (2.22). Whether this absolute value of $b$ is unique to induced GWs is something yet to explore.

Before moving on to the near peak limit, let us comment on the implications of Eq. (2.22). While the far most IR tail of the induced GW spectrum indeed must go as $k ^ { 3 }$ , we may have an intermediate regime where $\Omega _ { \mathrm { G W s } } \propto k ^ { 3 - 2 | b | }$ . This has interesting consequences when comparing with GWs from other sources. Let us model a general GW spectrum by a broken power-law around a characteristic scale $k _ { c }$ , as done in Ref. [172]. Then, for example, the IR spectrum of induced GWs for $b = 2$ ( $w = - 1 / 9$ ) resembles to that of GWs generated by a strong first order phase transition which have $\Omega _ { \mathrm { G W s } } \propto k ^ { 2 . 8 }$ for $k < k _ { c }$ and $\Omega _ { \mathrm { G W s } } \propto k ^ { - 1 }$ for $k > k _ { c }$ . This gives another very good reason to be open about a primordial universe with a different equation of state than radiation.

# 2.2.2 The near peak regime

Looking closely at Eq. (2.19), we might suspect that there could be a resonance if the wavenumber $k$ of a tensor mode approaches that of twice the scalar mode $2 k _ { p }$ . This resonance may be understood in two ways. First, we know that a harmonic oscillator with an external force has a resonance when the period of the force matches that of the harmonic oscillator. If that occurs, the amplitude of the oscillations diverges in time. In short, the external force is kicking the oscillator at the right times. The second way to see it is that two scalar modes with physical momentum $c _ { s } k _ { p }$ have a preferred window to produce a tensor mode with physical momentum equal to twice the scalar momenta, i.e., $k = 2 c _ { s } k _ { p }$ , if allowed by momentum conservation. To see this mathematically, let us redefine the tensor modes in Eq. (2.19) to remove the Hubble friction by

$$
h _ { k } = v _ { k } / a .
$$

With this new variable $v _ { k }$ Eq. (2.19) now reads

$$
v _ { k } ^ { \prime \prime } + \left( k ^ { 2 } - \frac { b ( 1 + b ) } { \tau ^ { 2 } } \right) v _ { k } = \frac { k _ { p } ^ { 2 } } { a } \delta \varphi _ { p } ^ { 2 } e ^ { 2 i c _ { s } k _ { p } \tau } ,
$$

where we only focused on the oscillatory behaviour of the scalar field for $c _ { s } k _ { p } \tau \gg 1$ . The particular solution to $v _ { k }$ can be found by the Green’s function method (see App. B for the details). Neglecting the term proportional to $1 / \tau ^ { 2 }$ in Eq. (2.25), the homogeneous solutions to $v _ { k }$ are $e ^ { \pm i k \tau }$ . With such homogeneous solutions, the particular solution by the Green’s method reads

$$
v _ { k } \approx \int _ { \tau _ { i } } ^ { \tau } d \tilde { \tau } \sin \left( k ( \tau - \tilde { \tau } ) \right) \tilde { \tau } ^ { - 1 - b } e ^ { 2 i c _ { s } k _ { p } \tilde { \tau } } .
$$

We clearly see from the integrand in Eq. (2.26) that there is a resonance when the frequency of the sine equals that of the exponential. Then the oscillations interfere and leave the integral of a power-law. Since we are only interested in how the amplitude diverges, let us only focus on the divergent part of (2.26) which is given by

$$
v _ { k } \propto \int d \tilde { \tau } \tilde { \tau } ^ { - 1 - b } e ^ { - i \tilde { \tau } ( k - 2 c _ { s } k _ { p } ) } \propto \Gamma [ - b ] ( k - 2 c _ { s } k _ { p } ) ^ { b } .
$$

We see that when $b \leq 0$ the resonance is effective and the amplitude diverges. Note that for $b = 0$ the divergence is logarithmic. When $b > 0$ the resonance is not effective enough to cause a divergence as the amplitude of the integrand decays faster than $\tau ^ { - 1 }$ . However, since we so far used a Taylor expansion around $k \sim 2 c _ { s } k _ { p }$ we expect that for $1 > b > 0$ Eq. (2.27) still yields the leading contribution after the constant term. Thus, for $1 > b > 0$ we also expect a peak at around $k \sim 2 c _ { s } k _ { p }$ , albeit not divergent. For $b > 1$ the situation is less clear and a detailed analysis is necessary. Nevertheless for $b < 1$ , we can roughly write that the tensor modes in the near peak regime have an amplitude given by

$$
h _ { k } ( k \sim 2 c _ { s } k _ { p } , b < 1 ) \propto \mathrm { c o n s t a n t } - ( k - 2 c _ { s } k _ { p } ) ^ { b } .
$$

This also implies that the induced GW spectrum has a peak near $k \sim 2 c _ { s } k _ { p }$ with a growth rate proportional to

$$
\Omega _ { \mathrm { G W } } ^ { \mathrm { i n d u c e d } } ( k \sim 2 c _ { s } k _ { p } ) \propto \left\{ \begin{array} { l l } { { | k - 2 c _ { s } k _ { p } | ^ { - 2 | b | } } } & { { b < 0 } } \\ { { \mathrm { c o n s t a n t } - | k - 2 c _ { s } k _ { p } | ^ { b } } } & { { 1 > b > 0 } } \end{array} \right. .
$$

These estimates will be later checked by the general analytical solutions in Sec. 4. Thus, the resonant peak in the induced GW spectrum has information on the sound horizon $c _ { s } k _ { p }$ by the position of the peak and on the expansion history $b$ by the growth rate around the peak. This type of resonant structure is characteristic of induced GWs. Thus, the observation of such resonant peak could give strong evidence for induced GWs. Then, the sound speed of fluctuations $c _ { s }$ and the peak $k _ { p }$ could be disentangled by the simultaneous observation of the PBH counterpart, which we proceed to discuss. Note that in (2.29) the radiation domination case $b = 0$ is “special” because it is exactly when the amplitude of the source term is proportional to the background density.

# 2.3 Primordial black hole counterpart

In this section we briefly introduce the PBH counterpart to the induced GWs. It is by no means a review on PBH formation and it does not intend to be so. A detailed review on PBHs can be found in Ref. [174]. Other interesting reviews are listed at the beginning of this review. PBHs from large primordial fluctuations will form in those Hubble patches where the density contrast $\delta \rho / \rho$ is above a certain threshold $_ 6$ $\delta _ { c }$ [190, 203–208], which depends on the EoS parameter $w$ at horizon re-entry [209–216]. Since fluctuations generated during inflation closely follow a Gaussian distribution centred around zero, only the tail of the distribution has a large enough amplitude to collapse to PBH. This means that PBH formation is an extremely rare event. The fraction of Hubble patches where PBH forms is exponentially suppressed and sensitive to the root mean squared of the distribution, which is related to the power spectrum. This is why we generally need $\mathcal { P } _ { \mathcal { R } } \sim 1 0 ^ { - 2 }$ to form a substantial fraction of PBHs. Precise estimations of the fraction of PBH is an active and ongoing research field, e.g., see Refs. [202, 214–221] and references therein. For our purposes, it is enough to know that only large induced GWs have a large associated fraction of PBH and, inversely, the absence of large induced GWs rules out PBHs from large primordial fluctuations.

For simplicity, we continue with the assumptions of the previous section and take a primordial spectrum with a Dirac delta peak at $k _ { p }$ . This essentially leads to an almost monochromatic $^ 7$ PBH mass function. When the peak in the scalar spectrum enters the horizon, those fluctuations which are above $\delta _ { c }$ collapse into a PBH. By the end of the collapse, only a fraction $\gamma$ of the total mass enclosed inside the horizon at horizon crossing ( $H _ { \circledast } a _ { \circledast } = k _ { p }$ ) will end up as a PBH. We use the symbol $\circledast$ to refer to evaluation at PBH formation time. In mathematical terms, we have that PBHs mainly form with a mass equal to the mass enclosed inside the Hubble sphere, that is

$$
M _ { \mathrm { P B H , \circledast } } = \gamma \frac { 4 \pi } { 3 } \frac { \rho _ { \circledast } } { H _ { \circledast } ^ { 3 } } = \frac { 4 \pi \gamma M _ { \mathrm { p l } } ^ { 2 } } { H _ { \circledast } } .
$$

To grasp the magnitude of the actual PBH mass, let us write it in terms of a solar mass $M _ { \odot }$ by referring all quantities in (2.30) in terms of the size of the horizon at matter-radiation equality which is very well measured by Planck [2]. The numerical factors and formulas used to derive this and the following estimates can be found App. A. After some numerical manipulations we arrive at

$$
\begin{array} { r } { M _ { \mathrm { P B H } , \oplus } \approx 3 . 9 7 \times 1 0 ^ { - 1 2 } M _ { \odot } \left( \frac { k _ { p } } { k _ { \mathrm { r h } } } \right) ^ { - 2 - b } \left( \frac { k _ { \mathrm { r h } } } { 1 0 ^ { 1 2 } \mathrm { M p c } ^ { - 1 } } \right) ^ { - 2 } \qquad } \\ { \times \left( \frac { \gamma } { 0 . 2 } \right) \left( \frac { g _ { \ast } ( T _ { \mathrm { r h } } ) } { 1 0 6 . 7 5 } \right) ^ { 1 / 2 } \left( \frac { g _ { \ast s } ( T _ { \mathrm { r h } } ) } { 1 0 6 . 7 5 } \right) ^ { - 2 / 3 } , } \end{array}
$$

where we kept our ignorance on the primordial universe by leaving a free $b$ (or $w$ ) (2.16). We took $\gamma \sim 0 . 2$ in a radiation dominated universe [206] but it may differ for different expansion histories [209–212]. $g _ { * } ( T _ { \mathrm { r h } } )$ and $g _ { * s } ( T _ { \mathrm { r h } } )$ are the effective degrees of freedom in the energy density and entropy evaluated at reheating. It should be noted that we also assumed an instantaneous reheating. In that case, the horizon scale at reheating $k _ { \mathrm { r h } }$ can be related to the reheating temperature by

$$
k _ { \mathrm { r h } } = 1 . 2 \times 1 0 ^ { 1 2 } \mathrm { M p c } ^ { - 1 } \left( \frac { T _ { \mathrm { r h } } } { 5 \times 1 0 ^ { 4 } \mathrm { G e V } } \right) \left( \frac { g _ { \ast } ( T _ { \mathrm { r h } } ) } { 1 0 6 . 7 5 } \right) ^ { 1 / 2 } \left( \frac { g _ { \ast s } ( T _ { \mathrm { r h } } ) } { 1 0 6 . 7 5 } \right) ^ { - 1 / 3 } .
$$

As we have seen in Sec. 2.2, the peak in the primordial curvature power spectrum induces GWs. These GWs have a typical frequency $f _ { p }$ associated to the wavenumber $k _ { p }$ . Since the typical mass and the typical frequency are related by the same typical scale $k _ { p }$ , we can write one in terms of the other. In this way, the typical frequency evaluated today reads

$$
f _ { p } = \frac { k _ { p } } { 2 \pi a _ { 0 } } \approx 1 . 5 4 \times 1 0 ^ { - 3 } \mathrm { H z } \left( \frac { M _ { \mathrm { P B H , \circledast } } } { 3 . 9 7 \times 1 0 ^ { - 1 2 } M _ { \odot } } \right) ^ { \frac { - 1 } { 2 + b } } \left( \frac { f _ { \mathrm { r h } } } { 1 . 5 4 \times 1 0 ^ { - 3 } \mathrm { H z } } \right) ^ { \frac { b } { 2 + b } } .
$$

For a radiation dominated universe ( $b ~ = ~ 0$ ) we have a one-to-one correspondence between the frequency and the mass. If we fix the reheating scale, the relation (2.33) roughly tells us that PBH with a given mass have an induced GW counterpart with a peak frequency at around $f _ { p }$ . The exact relation between $f _ { p }$ and $M _ { \mathrm { P B H , \circledast } }$ depends on the value of $b$ . For instance, if $b < 0$ ( $w > 1 / 3$ ) the expansion rate was faster and for a fixed $k _ { p }$ corresponds to smaller PBH mass at formation. The opposite holds for $b > 0$ $w < 1 / 3$ ). It should also be noted that for $b > 3 / 2$ ( $w < - 1 / 1 5$ ) there is another peak in the induced GWs at $k \sim k _ { \mathrm { r h } }$ . This may break the correspondence between the PBH mass and the peak of the induced GWs if not all the GW spectrum is seen.

# 3 General formalism

In this section we present the general formulation of induced GWs. This includes the derivation of the equations of motion in Sec. 3.1 and the general form of the solutions in Sec. 3.2. Then in Sec. 3.3 we include the leading terms due to local-type non-Gaussianity. In Sec. 3.1, we derive the equations of motion using the action formalism and so we do not follow the conventional derivation, e.g., of Refs. [35, 38]. The final result is obviously the same, but the derivation is rather quick and clear. Throughout this section and on, we shall neglect the effect of vector perturbations as they typically decay. Anyone interested in the approximations and applications may jump directly to Sec. 4.

$\pmb { \theta }$ Main references: In Sec. 3.1 we closely follow Ref. [150] although we work at the level of the Lagrangian. For alternative derivations starting from the Einstein equations see for example Refs. [35, 38, 39]. Then, Sec. 3.2 is extracted from [64] which is built upon and uses the notation of Ref. [63] except for the numerical factor 2 involving $h _ { i j }$ . Lastly, Sec. 3.3 on the primordial non-Gaussianity is mainly based on Ref. [81] updated and corrected by Ref. [92].

# 3.1 Derivation from the action

We need to arrive at the equations of motion for the transverse-traceless component of the spatial metric at second order in cosmological perturbation theory. Although it is a second order calculation, we shall derive it quickly from the action formalism; if we work in a particular gauge and we only focus on the interaction of tensor with scalars. It is particularly convenient to work in a gauge similar to the Newtonian gauge8 with the exponential notation typical of Misner, Throne $\&$ Wheeler [184]. With this choice and assuming a perturbed FLRW universe, the metric reads

$$
d s ^ { 2 } = g _ { \mu \nu } d x ^ { \mu } d x ^ { \nu } = - \mathrm { e } ^ { 2 \Psi } d t ^ { 2 } + a ^ { 2 } ( t ) \mathrm { e } ^ { 2 \Phi } Y _ { i j } d x ^ { i } d x ^ { j } ,
$$

where $g _ { \mu \nu }$ is the metric of our space-time, $i = \{ 1 , 2 , 3 \}$ are the spatial components, $a ( t )$ is the scale factor and we have further used the conformal decomposition of the spatial metric such that

$$
\frac { \partial } { \partial t } \operatorname* { d e t } Y = Y ^ { i j } \frac { \partial } { \partial t } Y _ { i j } = 0 .
$$

Note that for a flat FLRW background in Cartesian coordinates we have $Y _ { i j } = \delta _ { i j }$ . The conformal decomposition of the spatial metric is very convenient and simplifies calculations. It is also used, e.g., in Numerical Relativity [222]. In short, the conformal decomposition completely splits the trace (volume changing) from the trace-free (volume preserving) degrees of freedom. In the Newtonian gauge this decomposition directly splits the scalar and tensor modes of the spatial metric. This means that $Y _ { i j }$ only contains the transverse-traceless degrees of freedom. As we shall see, it also leaves a clean splitting between $Y _ { i j }$ and $\Phi$ at the level of the action.

To consider a sensible cosmological set up, we include a canonical scalar field $\varphi$ in the perturbed FLRW metric. We can later generalize it to a perfect fluid quite straightforwardly. The action, without any decomposition, is given by

$$
S = \int d ^ { 4 } x \sqrt { - g } \left\{ \frac { 1 } { 2 } R - \frac { 1 } { 2 } g ^ { \mu \nu } \partial _ { \mu } \varphi \partial _ { \nu } \varphi - V ( \varphi ) \right\} ,
$$

where $g$ is the determinant of $g _ { \mu \nu }$ , $R$ is the 4D Ricci scalar, $\partial _ { \mu } \equiv \partial / \partial x ^ { \mu }$ and $V ( \varphi )$ is the potential of $\varphi$ . In the (3+1) conformal decomposition (3.1), after some algebra and integration by parts, the

action becomes

$$
\begin{array} { l } { { S = \displaystyle \int d ^ { 3 } x d t \bigg \{ a \mathrm { e } ^ { \Psi + \Phi } ( \frac { 1 } { 2 } R ^ { ( 3 ) } [ Y _ { i j } ] - 2 Y ^ { i j } D _ { i } D _ { j } \Phi - Y ^ { i j } D _ { i } \Phi D _ { j } \Phi - \frac { 1 } { 2 } Y ^ { i j } D _ { i } \varphi D _ { j } \varphi  } } \\ { {  \qquad + a ^ { 3 } \mathrm { e } ^ { 3 \Phi - \Psi } ( \frac { 1 } { 8 } Y ^ { i j } Y ^ { k l } \dot { Y } _ { i k } \dot { Y } _ { j l } - 3 ( H + \dot { \Phi } ) ^ { 2 } + \frac { 1 } { 2 } \dot { \varphi } ^ { 2 } ) - a ^ { 3 } \mathrm { e } ^ { 3 \Phi + \Psi } V ( \varphi ) \bigg \} , } } \end{array}
$$

where $R ^ { ( 3 ) } [ Y _ { i j } ]$ and $D _ { i }$ are respectively the 3D Ricci scalar and the covariant derivative associated to $Y _ { i j }$ . Since we work in Cartesian coordinates, we already used that $\operatorname* { d e t } Y = 1$ . In going from (3.3) to (3.4) we took a big leap in the (3+1) and conformal decomposition of the 4D Ricci scalar. Some steps can be found in App. C. For more details, the interested reader is referred to E. Poisson’s book [223] for the (3+1) or ADM decomposition [224], and to the appendix of R. Wald’s book [225] for the conformal transformation rules.

Now, we could take the variation of (3.4) with respect to $Y _ { i j }$ , having in mind that the result should still be transverse and traceless, and obtain the transverse-traceless spatial component of Einstein Equations. However, this would not be very illuminating. Before taking the variation, let us use cosmological perturbation theory and expand the action. A smart way to decompose the spatial metric and to keep the requirement (3.2) is to take the exponential matrix, i.e.,

$$
Y _ { i j } = ( e ^ { h } ) _ { i j } = \delta _ { i j } + h _ { i j } + \frac 1 2 \delta ^ { k l } h _ { i k } h _ { j l } + O ( h ^ { 3 } ) ,
$$

where $h _ { i j } \ll 1$ are the transverse-traceless (tensor) modes and satisfy $\delta ^ { i j } h _ { i j } = \partial ^ { i } h _ { i j } = 0$ . This is used, e.g., in Maldacena’s work on non-gaussianities [226]. For the details of the expansion in general gauges see [150]. From now on, spatial indices are contracted with the background spatial metric $\delta _ { i j }$ , for example $h ^ { i j } h _ { i j } \equiv \delta ^ { i j } \delta ^ { k l } h _ { i k } h _ { j l }$ . The inverse metric is then $Y ^ { i j } = \delta ^ { i k } \delta ^ { j l } ( e ^ { - h } ) _ { k l }$ . With this expansion, the 3D Ricci scalar up to second order is given by

$$
R ^ { ( 3 ) } [ e ^ { h } ] = - \frac { 1 } { 4 } \partial _ { i } h _ { k l } \partial ^ { i } h ^ { k l } + O ( h ^ { 3 } ) .
$$

We stopped at second order since we are only interested in scalar-scalar-tensor interactions. We split the other variables as

$$
\Psi = \Psi ( t , { \bf x } ) \quad , \quad \Phi = \Phi ( t , { \bf x } ) \quad , \quad \varphi = \bar { \varphi } ( t ) + \delta \varphi ( t , { \bf x } ) ,
$$

where $\bar { \varphi } ( t )$ is the background solution and $\Phi$ , $\Psi$ and $\delta \varphi$ are the perturbations. Using the perturbative expansions (3.5) and (3.7) and only selecting the terms with two scalars and one tensor, we arrive at

$$
= \int d ^ { 3 } x d t \bigg \{ \frac { a ^ { 3 } } { 8 } \dot { h } ^ { i j } \dot { h } _ { i j } - \frac { a } { 8 } \partial _ { i } h _ { k l } \partial ^ { i } h ^ { k l } - 2 a h ^ { i j } \partial _ { i } ( \Phi + \Psi ) \partial _ { j } \Phi + a h ^ { i j } \partial _ { i } \Phi \partial _ { j } \Phi + \frac { a } { 2 } h ^ { i j } \partial _ { i } \delta \varphi \partial _ { j } \delta \varphi \bigg \}
$$

where the first two terms correspond to the second order Lagrangian of the tensor modes. By taking the variation with respect to $h _ { i j }$ we obtain the equations of motion of induced GWs, namely

$$
\ddot { h } _ { i j } + 3 H \dot { h } _ { i j } - a ^ { - 2 } \Delta h _ { i j } = a ^ { - 2 } \mathcal { P } \vphantom { \frac { a } { b } } { } _ { i j } \left\{ - 8 \partial _ { a } ( \Phi + \Psi ) \partial _ { b } \Phi + 4 \partial _ { a } \Phi \partial _ { b } \Phi + 2 \partial _ { a } \delta \varphi \partial _ { b } \delta \varphi \right\} ,
$$

where $H = { \dot { a } } / a$ is the Hubble parameter and $\mathcal { P } ^ { a b } { } _ { i j }$ is the transverse-traceless projector, so that the equation is consistent with the transverse-traceless degrees of freedom. For the moment, it is enough to know that it satisfies the requirements of a transverse-traceless object for both pairs of indices. Also note that in the current case of study, we have no source of anisotropic stress. Thus, for the sake of simplicity and consistency, we momentarily cheat and use the traceless part of the spatial component of the linear Einstein equations in App. E, which in the absence of anisotropic stress yields

$$
\Psi + \Phi = 0 .
$$

Note that this is not strictly true in the early universe where neutrinos have a large mean free path and give a tiny contribution to the anisotropic stress [39, 40].

Before going to the general solutions of the induced GWs, let us translate the current calculation to the perfect fluid picture. A perfect fluid with energy density $\rho$ and pressure $P$ is described by the following energy-momentum tensor:

$$
T _ { \mu \nu } = \left( \rho + P \right) u _ { \mu } u _ { \nu } + P g _ { \mu \nu } ,
$$

where $u ^ { \mu }$ is the fluid 4-velocity. The perfect fluid is specified once the equation of state $w =$ $P / \rho$ is given. In the perturbative expansion, one takes $\rho = \bar { \rho } + \delta \rho$ and $u _ { i } = \partial _ { i } v$ where $v$ is the velocity perturbation and we neglected vector modes. The energy momentum tensor (3.11) has to be compared with the one for the scalar field, which reads

$$
T _ { \mu \nu } ^ { \varphi } = \partial _ { \mu } \varphi \partial _ { \nu } \varphi - g _ { \mu \nu } \left( \frac { 1 } { 2 } \partial _ { \alpha } \varphi \partial ^ { \alpha } \varphi + V ( \varphi ) \right) .
$$

The perfect fluid description of the scalar field follows from the identification

$$
u _ { \mu } = \frac { \partial _ { \mu } \varphi } { \sqrt { - \partial _ { \alpha } \varphi \partial ^ { \alpha } \varphi } } .
$$

If we simply focus on the spatial component $u _ { i }$ we find that

$$
\delta \varphi  v { \sqrt { \rho + P } } .
$$

Thus, in terms of the perfect fluid description we have that

$$
\ddot { h } _ { i j } + 3 H \dot { h } _ { i j } - a ^ { - 2 } \Delta h _ { i j } = a ^ { - 2 } { \mathcal P } ^ { a b } { } _ { i j } \left\{ 4 \partial _ { a } \Phi \partial _ { b } \Phi + 2 ( \rho + P ) \partial _ { a } v \partial _ { b } v \right\} .
$$

This result coincides with the equations derived in Ref. [38, 39]. Note that Eq. (3.15) will slightly change in the case of a multi-perfect fluid system. We expect contributions from the relative velocities of the fluids. For a radiation-matter dominated universe, the source term to induced GWs can be found, e.g., in Ref. [70].

# 3.2 General solutions

To solve for the induced GWs, we must solve beforehand the first order equations of motion. Continuing with the scalar field fluctuations $\delta \varphi$ , we find that they are related by the momentum constraint to $\Phi$ by [183]

$$
\delta \varphi = - \sqrt { \frac { 2 } { \epsilon } } \left( \Phi + \frac { \Phi ^ { \prime } } { \mathcal { H } } \right) .
$$

Thus, we must only solve for the only scalar degree of freedom $\Phi$ , which we will do briefly. For the moment, we take a general approach and split $\Phi$ into an initial value $\Phi _ { \mathbf { k } }$ and a transfer function $T _ { \Phi }$ as

$$
\Phi ( \mathbf { k } , \tau ) = T _ { \Phi } ( k , \tau ) \Phi _ { \mathbf { k } } .
$$

If we are considering primordial fluctuations, the initial spectrum for $\Phi _ { \mathbf { k } }$ is set on superhorizon scales ( $k \tau \ll 1$ ) by quantum fluctuations during inflation. However, in general, any source of fluctuations to the curvature perturbation $\Phi$ will lead to induced GWs. We will discuss this possibility later in Sec. 6. With Eqs. (3.16) and (3.17) we can formally solve the equations of motion for induced GWs [38, 39], which in Fourier space read

$$
h _ { \mathbf { k } , \lambda } ^ { \prime \prime } + 2 \mathcal { H } h _ { \mathbf { k } , \lambda } ^ { \prime } + k ^ { 2 } h _ { \mathbf { k } , \lambda } = \mathcal { S } _ { \mathbf { k } , \lambda } ,
$$

with

$$
S _ { { \bf k } , \lambda } = 4 \int { \frac { d ^ { 3 } q } { ( 2 \pi ) ^ { 3 } } } e _ { \lambda } ^ { i j } ( k ) q _ { i } q _ { j } \Phi _ { { \bf q } } \Phi _ { | { \bf k } - { \bf q } | } f ( \tau , q , | { \bf k } - { \bf q } | ) ,
$$

and

$$
\begin{array} { l } { { f ( \tau , q , | { \bf { k } } - { \bf { q } } | ) = T _ { \Phi } ( q \tau ) T _ { \Phi } ( | { \bf { k } } - { \bf { q } } | \tau ) } } \\ { { \displaystyle ~ + \frac { 1 + b } { 2 + b } \left( T _ { \Phi } ( q \tau ) + \frac { T _ { \Phi } ^ { \prime } ( q \tau ) } { \mathcal { H } } \right) \left( T _ { \Phi } ( | { \bf { k } } - { \bf { q } } | \tau ) + \frac { T _ { \Phi } ^ { \prime } ( | { \bf { k } } - { \bf { q } } | \tau ) } { \mathcal { H } } \right) , } } \end{array}
$$

where we wrote $\epsilon$ in terms of $b$ using Eqs. (2.15) and (2.16). To derive Eq. (3.18) from Eq. (3.15), we used the Fourier transform for $h _ { i j }$ in terms of the polarization tensors $e _ { i j } ( k )$ which are defined in App. D. Then, we used that the projection of $e _ { i j }$ with the Fourier transform of the transversetraceless projector $\mathcal { \tilde { P } } ^ { a b } { } _ { i j }$ is trivial, i.e., $e ^ { i j } \mathcal { \tilde { P } } ^ { a b } { } _ { i j } = e ^ { a b }$ . Now, with the Green’s method we can find a formal solution to (3.18) given by

$$
h _ { \mathbf { k } , \lambda } ( \tau ) = \int _ { \tau _ { i } } ^ { \tau } d \tilde { \tau } G _ { h } ( \tau , \tilde { \tau } ) S _ { \mathbf { k } , \lambda } ( \tilde { \tau } ) ,
$$

where $G _ { h } ( \tau , \tilde { \tau } )$ is the Green’s function of the homogeneous solutions to (3.18) given in App. B. The formal solution (3.21) is defined such that at the initial time $\tau _ { i }$ we have $h _ { \mathbf { k } , \lambda } ( \tau _ { i } ) = h _ { \mathbf { k } , \lambda } ^ { \prime } ( \tau _ { i } ) = 0$ . Any GW with primordial origin, i.e., generated during inflation, may be simply added to the solution (3.21).

Since we are interested in the main observable of the SGWB, that is the GW power, let us compute the 2-point correlation function of the induced GWs which is given by

$$
\langle h _ { \lambda } ( k , \tau ) h _ { \lambda } ( k ^ { \prime } , \tau ) \rangle = \int _ { 0 } ^ { \tau } d \tau _ { 1 } \int _ { 0 } ^ { \tau } d \tau _ { 2 } G ( \tau , \tau _ { 1 } ) G ( \tau , \tau _ { 2 } ) \langle S _ { \lambda } ( k , \tau _ { 1 } ) S _ { \lambda } ( k ^ { \prime } , \tau _ { 2 } ) \rangle .
$$

Here we have neglected any primordial signal but we could add one without further issue. In fact, this was considered in Ref. [88] where they may have non-trivial cross-correlated spectrum by tensor-scalar-scalar couplings during inflation. We will not pursue this possibility further in this review. Continuing with Eq. (3.22), we can compute the 2-point function of the source term by

$$
\begin{array} { l } { { \displaystyle \langle S _ { \lambda } ( k , \tau _ { 1 } ) S _ { \lambda } ( k ^ { \prime } , \tau _ { 2 } ) \rangle = 4 ^ { 2 } \int \frac { d ^ { 3 } q } { ( 2 \pi ) ^ { 3 } } \int \frac { d ^ { 3 } q ^ { \prime } } { ( 2 \pi ) ^ { 3 } } e _ { \lambda } ^ { i j } ( k ) q _ { i } q _ { j } e _ { \lambda } ^ { i j } ( k ^ { \prime } ) q _ { i } ^ { \prime } q _ { j } ^ { \prime } } } \\ { { \displaystyle \qquad \times \ f ( \tau _ { 1 } , q , | { \bf k } - { \bf q } | ) f ( \tau _ { 2 } , q ^ { \prime } , | { \bf k } ^ { \prime } - { \bf q } ^ { \prime } | ) \langle \Phi _ { q } \Phi _ { | { \bf k } - { \bf q } | } \Phi _ { q ^ { \prime } } \Phi _ { | { \bf k } ^ { \prime } - { \bf q } ^ { \prime } | } \rangle . } } \end{array}
$$

We see that the induced GW spectrum depends on the 4-point function of the scalar fluctuations. Such 4-point function may be decomposed in general into a disconnected, i.e., the product of 2-point functions, and a connected piece [89]. If we consider that the stochastic fluctuations are drawn from a Gaussian distribution, the connected 4-point function vanishes and we are led to9

$$
\begin{array} { r l r } {  { \langle \Phi _ { q } \Phi _ { | \mathbf { k } - \mathbf { q } | } \Phi _ { q ^ { \prime } } \Phi _ { | \mathbf { k ^ { \prime } - q ^ { \prime } } | } \rangle = \frac { 2 \pi ^ { 2 } } { q ^ { 3 } } \mathcal { P } _ { \Phi } ( q ) \frac { 2 \pi ^ { 2 } } { | \mathbf { k } - \mathbf { q } | ^ { 3 } } \mathcal { P } _ { \Phi } ( | \mathbf { k } - \mathbf { q } | ) } } \\ & { } & { \times ( 2 \pi ) ^ { 6 } \delta ^ { ( 3 ) } ( \mathbf { q } + \mathbf { q } ^ { \prime } ) \delta ^ { ( 3 ) } ( \mathbf { k } + \mathbf { k } ^ { \prime } - \mathbf { q } - \mathbf { q } ^ { \prime } ) + ( \mathbf { q }  \mathbf { k } - \mathbf { q } ) . } \end{array}
$$

We discuss the case of mildly non-Gaussian fluctuations in Sec. 3.3. With further manipulations of Eqs. (3.22) and (2.8), integrating one internal momentum using a Dirac delta and writing the remaining integral in spherical (momentum) coordinates, we arrive at

$$
\overline { { { \mathcal { P } _ { h } } } } = 8 \int _ { 0 } ^ { \infty } { d v } \int _ { | 1 - v | } ^ { 1 + v } d u \left( \frac { 4 v ^ { 2 } - ( 1 - u ^ { 2 } + v ^ { 2 } ) ^ { 2 } } { 4 u v } \right) ^ { 2 } \overline { { { I ^ { 2 } ( \tau , k , v , u ) } } } \mathcal { P } _ { \Phi } ( k u ) \mathcal { P } _ { \Phi } ( k v ) ,
$$

where we followed the notation of Kohri and Terada [63]. In Eq. (3.25) we already summed over polarizations (see App. D for the details) and we have introduced for convenience

$$
v \equiv \frac { q } { k } \quad , \quad u \equiv \frac { | { \bf k } - { \bf q } | } { k } .
$$

We also took the oscillation average, i.e., we integrated over half period and divided by $\pi$ , to take into account that observations of the SGWB actually measure an average over many wavelengths. Furthermore, we have inserted all the time dependence into a “kernel” or “transfer function” defined by

$$
I ( \tau , k , u , v ) \equiv \int _ { \tau _ { i } } ^ { \tau } d \tilde { \tau } G ( \tau , \tilde { \tau } ) f ( \tilde { \tau } , k , u , v ) .
$$

The (averaged) power spectrum (3.25) is the main quantity needed for the calculations of induced GWs. Knowing (3.25) we can compute the spectral density of GWs by Eq. (2.7). Note that the induced tensor power spectrum (3.25) is valid for any curvature perturbation regardless of its origin as long as it is Gaussian. In the next section, we discuss in more detail the case when the fluctuations $\Phi$ are generated during inflation.

# 3.3 Inclusion of primordial non-Gaussianity

Primordial fluctuations generated out of quantum fluctuations during inflation are very close to being Gaussian, although not exactly. Small departures of a Gaussian distribution are expected due to gravitational interactions [183, 226]. These perturbative departures from the Gaussian distribution are often referred to as Non-Gaussianity (NG).10 Depending on the formation mechanism, e.g., due to large interactions among fields, we may obtain some significant level of NG. The possibility of observing NG of primordial fluctuations is very exciting, as it might provide information on the particle content during inflation. For this reason, the study of NG is sometimes referred to as cosmological collider physics [227].

For practical convenience, the predictions of primordial fluctuations generated during inflation are often given in terms of the curvature perturbation $\mathcal { R }$ . This is because $\mathcal { R }$ is a non-linearly conserved quantity on superhorizon scales [228]. This makes it easy to set well-defined initial conditions on superhorizon scales for whatever scalar variable one might want to consider, independently of what happened previously (e.g., how inflation ended). For instance, since we are working in the Newtonian gauge, we have to relate $\mathcal { R }$ with $\Phi$ . It can be shown that on superhorizon scales the linear relation is given by [229]

$$
\mathcal { R } = \frac { 5 + 3 w } { 3 ( 1 + w ) } \Phi = \frac { 2 b + 3 } { b + 2 } \Phi .
$$

In the case at hand, we are interested on NGs generated during inflation, i.e., primordial NG. These primordial NGs are often parametrized by the amplitude and shape of 3-point function or the bispectrum [180, 181]. For simplicity, we usually consider only the local type NG which can be expressed as a local perturbative expansion around the Gaussian curvature perturbation $\mathcal { R } ^ { g }$ by

$$
\mathcal { R } ( x ) = \mathcal { R } ^ { g } ( x ) + \frac { 3 } { 5 } f _ { N L } \left( \mathcal { R } ^ { g } ( x ) \right) ^ { 2 } ,
$$

where the factor $3 / 5$ is by convention.11 Note, however, that this is just a particular shape of the NG. Currently though, there is no study on the impact of other shapes of NG on the induced GW spectrum. Now, if we go to Fourier space the squared term in (3.29) becomes a convolution. Then, we can write that for the $\Phi _ { q }$ modes the perturbative expansion is given by

$$
\Phi _ { q } = \Phi _ { q } ^ { g } + F _ { N L } \int \frac { d ^ { 3 } l } { ( 2 \pi ) ^ { 3 } } \Phi _ { l } ^ { g } \Phi _ { | { \bf q } - { \bf l } | } ^ { g } ,
$$

where to avoid unnecessary numerical factors we have introduced

$$
F _ { N L } \equiv \frac { 3 } { 5 } \frac { 2 b + 3 } { b + 2 } f _ { N L } .
$$

We can then expand perturbatively the 4-point function in (3.23) as

$$
\begin{array} { l } { { \displaystyle \langle \Phi _ { q } \Phi _ { | { \bf k } - { \bf q } | } \Phi _ { q ^ { \prime } } \Phi _ { | { \bf k ^ { \prime } - { \bf q } ^ { \prime } } | } \rangle = \langle \Phi _ { q } ^ { g } \Phi _ { | { \bf k } - { \bf q } | } ^ { g } \Phi _ { q ^ { \prime } } ^ { g } \Phi _ { | { \bf k ^ { \prime } - { \bf q } ^ { \prime } } | } ^ { g } \rangle } \ ~ }  \\ { { \displaystyle + F _ { N L } ^ { 2 } \int \frac { d ^ { 3 } l } { ( 2 \pi ) ^ { 3 } } \int \frac { d ^ { 3 } l ^ { \prime } } { ( 2 \pi ) ^ { 3 } } \langle \Phi _ { q } ^ { g } \Phi _ { l } ^ { g } \Phi _ { | { \bf k } - { \bf q } - 1 | } ^ { g } \Phi _ { q ^ { \prime } } ^ { g } \Phi _ { l ^ { \prime } } ^ { g } \Phi _ { | { \bf k ^ { \prime } - { \bf q } ^ { \prime } } - 1 ^ { \prime } | } ^ { g } \rangle } } \\ { { \displaystyle + ( | { \bf k } - { \bf q } |  q ) + ( | { \bf k ^ { \prime } } - { \bf q } ^ { \prime } |  q ^ { \prime } ) + ( q  q ^ { \prime } ; | { \bf k } - { \bf q } |  | { \bf k ^ { \prime } - { \bf q } ^ { \prime } } | ) } \ ~ } \\ { { \displaystyle + F _ { N L } ^ { 2 } \int \frac { d ^ { 3 } l } { ( 2 \pi ) ^ { 3 } } \int \frac { d ^ { 3 } l ^ { \prime } } { ( 2 \pi ) ^ { 3 } } \langle \Phi _ { l } ^ { g } \Phi _ { | { \bf q } - 1 | } ^ { g } \Phi _ { l ^ { \prime } } ^ { g } \Phi _ { | { \bf k } - { \bf q } - 1 ^ { \prime } | } ^ { g } \Phi _ { q ^ { \prime } } ^ { g } \Phi _ { | { \bf k ^ { \prime } - { \bf q } ^ { \prime } } | } ^ { g } \rangle } \ ~ } \\ { { \displaystyle + ( q  q ^ { \prime } ; | { \bf k } - { \bf q } |  | { \bf k ^ { \prime } - { \bf q } ^ { \prime } } | ) + O ( F _ { N L } ^ { 4 } ) . } } \end{array}
$$

The first term on the right hand side of (3.32) is already computed in Eq. (3.24). If we focus on the second line in the NG contribution of (3.32), we see that there are 6 possible non-vanishing Wick contractions in the first 6 point function of $\Phi ^ { g }$ which, together with the 4 remaining possibilities of the third line, makes 24 terms for the first NG contribution. In the fourth line of (3.32) there are 8 possible non-vanishing contractions, which make 16 possibilities counting the fifth line. The total is then 40 non-vanishing contractions.12 The NG contribution can be further classified into three different terms following the notation of Ref. [92]: the “H”, the “C”, the “Z”. Using Eq. (3.32) in (3.22) and (2.8), these NG contributions to the induced tensor spectrum can be respectively written as

$$
\begin{array} { r } { \overline { { \mathcal { P } _ { h } ^ { \mathrm { H } } } } = 2 ^ { 5 } F _ { N L } ^ { 2 } k ^ { 3 } \displaystyle \sum _ { \lambda } \int \frac { d ^ { 3 } q } { 2 \pi } \left( e _ { \lambda } ^ { i j } ( k ) q _ { i } q _ { j } \right) ^ { 2 } \overline { { I ^ { 2 } ( \tau , q , | \mathbf { k } - \mathbf { q } | ) } } \qquad } \\ { \times \frac { \mathcal { P } _ { \Phi } ( q ) } { q ^ { 3 } } \displaystyle \int \frac { d ^ { 3 } l } { 2 \pi } \frac { \mathcal { P } _ { \Phi } ( l ) } { l ^ { 3 } } \frac { \mathcal { P } _ { \Phi } ( | \mathbf { k } - \mathbf { q } - \mathbf { l } | ) } { | \mathbf { k } - \mathbf { q } - \mathbf { l } | ^ { 3 } } , } \end{array}
$$

$$
\begin{array} { r } { \overline { { \mathcal { P } _ { h } ^ { \mathrm { C } } } } = 2 ^ { 6 } F _ { N L } ^ { 2 } k ^ { 3 } \displaystyle \sum _ { \lambda } \int \frac { d ^ { 3 } q } { 2 \pi } \int \frac { d ^ { 3 } l } { 2 \pi } e _ { \lambda } ^ { i j } ( k ) q _ { i } q _ { j } e _ { \lambda } ^ { i j } ( k ) l _ { i } l _ { j } \overline { { I ( \boldsymbol { \tau } , \boldsymbol { q } , | \mathbf { k } - \mathbf { q } | ) I ( \boldsymbol { \tau } , l , | \mathbf { k } - \mathbf { l } | ) } } } \\ { \times \displaystyle \frac { \mathcal { P } _ { \Phi } ( | \mathbf { k } - \mathbf { l } | ) } { | \mathbf { k } - \mathbf { l } | ^ { 3 } } \frac { \mathcal { P } _ { \Phi } ( l ) } { l ^ { 3 } } \frac { \mathcal { P } _ { \Phi } ( | \mathbf { q } - \mathbf { l } | ) } { | \mathbf { q } - \mathbf { l } | ^ { 3 } } , } \end{array}
$$

and

$$
\begin{array} { r } { \overline { { \mathcal { P } _ { h } ^ { Z } } } = 2 ^ { 6 } F _ { N L } ^ { 2 } k ^ { 3 } \displaystyle \sum _ { \lambda } \int \frac { d ^ { 3 } q } { 2 \pi } \int \frac { d ^ { 3 } l } { 2 \pi } e _ { \lambda } ^ { i j } ( k ) q _ { i } q _ { j } e _ { \lambda } ^ { i j } ( k ) l _ { i } l _ { j } \overline { { I ( \boldsymbol { \tau } , \boldsymbol { q } , \vert \mathbf { k } - \mathbf { q } \vert ) I ( \boldsymbol { \tau } , l , \vert \mathbf { k } - \mathbf { l } \vert ) } } } \\ { \times \frac { \mathcal { P } _ { \Phi } ( \boldsymbol { q } ) } { q ^ { 3 } } \frac { \mathcal { P } _ { \Phi } ( l ) } { l ^ { 3 } } \frac { \mathcal { P } _ { \Phi } ( \vert \mathbf { k } - \mathbf { q } - \mathbf { l } \vert ) } { \vert \mathbf { k } - \mathbf { q } - \mathbf { l } \vert ^ { 3 } } . } \end{array}
$$

These derived formulas agree with those of Ref. [92]. We will assume that we are in the perturbative regime, so that the NG contributions (3.33)-(3.34) should be thought of as a correction to the Gaussian contribution (3.25). The first contribution (3.33) is also referred to as “hybrid” [90]. Also note that the second line in (3.33) can be reabsorbed into a redefinition of the primordial power spectrum to include non-Gaussianities. For instance, we could write

$$
\mathcal { P } _ { \mathcal { R } } ^ { N L } ( q ) = \mathcal { P } _ { \mathcal { R } } ( q ) + F _ { N L } ^ { 2 } q ^ { 3 } \int \frac { d ^ { 3 } l } { 2 \pi } \frac { \mathcal { P } _ { \mathcal { R } } ( l ) } { l ^ { 3 } } \frac { \mathcal { P } _ { \mathcal { R } } ( | \mathbf { q } - \mathbf { l } | ) } { | \mathbf { q } - \mathbf { l } | ^ { 3 } } ,
$$

which follows from the computation of $\langle \Phi ( k ) \Phi ( k ^ { \prime } ) \rangle$ using Eq. (3.30). This is the term considered by Cai, Pi and Sasaki [89] and acts as a local redefinition of the primordial spectrum. With the form of Eq. (3.36) it is much easier to compute the induced GW spectrum up to $O ( F _ { N L } ^ { 4 } )$ since it just accounts for a replacement of $\mathcal { P } _ { \mathcal { R } }$ in (3.25) for $\mathcal { P } _ { \mathcal { R } } ^ { N L }$ .The second contribution (3.34) was first considered by Unal [90] and the third (3.35) by Ref. [81]. Unal also considered the terms of $O ( F _ { N L } ^ { 4 } )$ [90]. Most recently, Adshead, Lozanov and Weiner [92] presented a detailed and complete analysis of all the contributions up to $O ( F _ { N L } ^ { 4 } )$ . The interested reader is referred to Ref. [92] for the detailed formulas. We discuss the main features of the NG corrections in Sec. 5. It should be noted that the effect of primordial NG might compete with the terms due to non-linearities, e.g., from studied third order contributions to the source term of induced GWs. The reader is referred to Refs. [143, 179] for the details on the third order expansion. Lastly, it should also be noted that for simplicity we assumed a scale invariant $f _ { N L }$ in (3.29). But, in general situations one expects that $f _ { N L }$ is scale dependent. For a recent study on the impact of the scale dependence see Ref. [93].

# 4 Analytical transfer functions

In general situations the kernel (3.27) and the power spectrum (3.25) have to be computed numerically. The problem is that the time integral in (3.27) is extremely demanding for $k \tau \gg 1$ , as the integrand is the product of three oscillating functions with frequencies that depend on the tensor and scalar mode wavenumbers. In fact, $k \tau \gg 1$ is the range of scales we are interested in. If we extend the integral until today, say at $\tau = \tau _ { 0 } \propto H _ { 0 } ^ { - 1 }$ , and we look at scales much smaller than the horizon, we trivially have $k \tau _ { 0 } \gg 1$ . But there is more we can learn. For instance, scales accessible to future GW detectors range from $k \sim 1 0 ^ { 7 }$ to $1 0 ^ { 1 8 } \mathrm { M p c ^ { - 1 } }$ . These very small scales entered the horizon much before BBN, which roughly correspond to the time when modes with $k \sim 1 0 ^ { 3 } \mathrm { M p c ^ { - 1 } }$ entered the horizon.13 Luckily, this implies that we can evaluate the kernel (3.27) some time prior to BBN when induced GWs are really inside the horizon and in a radiation dominated universe. Then, from that moment on, we may simply treat these induced GWs as a radiation fluid with $w = 1 / 3$ . Note that we will also consider the case that the modes of interest enter the horizon in an epoch where $w \neq 1 / 3$ . In that case, we must follow induced GWs until the universe transitions to the standard radiation dominated era. We give more details later.

Surprisingly, there are relevant regimes where the integrals in (3.27) can be done analytically. This is the case of a constant equation of state parameter $w$ and constant propagation speed of fluctuations $c _ { s }$ . For example, this includes a perfect fluid whether it is made of a scalar field $^ { 1 4 }$ or an adiabatic perfect fluid, which are commonly used in cosmology. Even when there are transitions between one perfect fluid domination to another, there will be periods in which $w$ and $c _ { s }$ are almost constant. Thus, the constant $w$ and $c _ { s }$ limit is a good approximation in a cosmological set up if the modes of interest enter the horizon outside the transition periods. With these assumptions, we present the solutions to first order cosmological perturbations in the Newtonian gauge in Sec. 4.1 and derive a very simple form of the source term (3.20) for the induced GWs. In the general situation where $w \neq 1 / 3$ , the integral (3.27) can be analytically done for modes which either enter the horizon before or after the transition. In this way, in Secs. 4.2 and 4.3 we respectively derive the kernel for modes which are subhorizon and superhorizon before the transition. When then follow our solutions to the radiation dominated epoch.

$\pmb { \theta }$ Main references: The whole section is a generalisation of Refs. [64, 74] to account for not only general constant $w$ but general constant $c _ { s }$ . The notation used here improves and unifies those of [64, 74]. The main base of Refs. [64, 74] was started in [39, 63] in the radiation dominated universe.

# 4.1 First order solutions

At the moment, the formal solution (3.21) for the induced tensor modes does not tell us much. To extract some meaningful information, we have to solve the equations of motion for first order perturbations, which are given in detail in App. E. After some simplifications, the equation for the

Newtonian potential for general $w$ and $c _ { s }$ and in the absence of isocurvature $^ { 1 5 }$ fluctuations reads $^ { 1 6 }$

$$
\Phi ^ { \prime \prime } + \left( 2 \epsilon - \eta \right) \mathcal { H } \Phi ^ { \prime } - \left( \eta + 2 s \left( 1 + \epsilon - \eta - 2 s + \frac { \dot { s } } { H s } \right) \right) \mathcal { H } ^ { 2 } \Phi + c _ { s } ^ { 2 } k ^ { 2 } \Phi = 0 ,
$$

where we have also introduced $\epsilon$ as in Eq. (2.15) as well as

$$
\eta \equiv \frac { \dot { \epsilon } } { H \epsilon } \quad \mathrm { a n d } \quad s \equiv \frac { \dot { c } _ { s } } { H c _ { s } } .
$$

The notation $\epsilon$ , $\eta$ and $s$ is typical of inflationary models and simplifies the form of the equations. One may of course write Eq. (4.1) in a more conventional notation, e.g., that in Mukhanov’s book [229] which for constant $c _ { s }$ reads

$$
\Phi ^ { \prime \prime } + 3 \mathcal { H } \left( 1 + c _ { w } ^ { 2 } \right) \Phi ^ { \prime } + \left( 2 \mathcal { H } ^ { \prime } + \left( 1 + 3 c _ { w } ^ { 2 } \right) \mathcal { H } ^ { 2 } \right) \Phi + c _ { s } ^ { 2 } k ^ { 2 } \Phi = 0 ,
$$

where $c _ { w } ^ { 2 } = \dot { P } / \dot { \rho }$ and $c _ { s } ^ { 2 } = \delta P / \delta \rho$ . In the case of an adiabatic perfect fluid one has $c _ { s } ^ { 2 } = c _ { w } ^ { 2 } = w$ . In the case of a canonical scalar field we have $c _ { w } ^ { 2 } = w$ and $c _ { s } ^ { 2 } = 1$ . As we already mentioned, for analytical viability we are mostly interested in the case of constant $w$ and $c _ { s }$ . This requirement in turn implies $\eta = s = 0$ , so that the Newtonian potential in Eq. (4.1) behaves as a massless field. The solution to (4.1) for general $c _ { s }$ and $w$ is given in terms of Bessel functions of the first and second kind, explicitly

$$
\Phi ( k \tau ) = ( c _ { s } k \tau ) ^ { - b - 3 / 2 } \left( C _ { 1 } J _ { b + 3 / 2 } ( c _ { s } k \tau ) + C _ { 2 } Y _ { b + 3 / 2 } ( c _ { s } k \tau ) \right) ,
$$

where $b$ in terms of $w$ is defined in Eq. (2.16). Now, we must give some kind of initial conditions to $\Phi$ . If the primordial spectrum was generated by quantum fluctuations during inflation, the initial conditions are well-defined and constant on super(sound)horizon scales, that is when $c _ { s } k \tau \ll 1$ . By picking up the asymptotically constant term in (4.4), we find that $C _ { 2 } = 0$ and

$$
\Phi ( k \tau ) = \Phi _ { \bf k } 2 ^ { b + 3 / 2 } \Gamma [ b + 5 / 2 ] ( c _ { s } k \tau ) ^ { - b - 3 / 2 } J _ { b + 3 / 2 } ( c _ { s } k \tau ) ,
$$

where $\Phi _ { \mathbf { k } }$ is the primordial (stochastic) value set by inflation. Note that the general solution (4.4) is not valid for $c _ { s } = 0$ where the gradient term in (4.1) is absent. Nevertheless, the solution for constant $w$ is just $\Phi = \Phi _ { \mathbf { k } }$ on all scales. The case of ${ c _ { s } } = 0$ is quite particular as the fact that $\Phi$ does not decay implies a constant source to induced GWs. This makes the detailed dynamics of the transition to radiation domination very important for the final GW spectrum [65,66], when the source term experiences drastic changes. We dedicate Sec. 6 to this particular case.

With an exact analytical formula for the first order perturbations, we can attempt to compute the resulting induced GWs. For that, we first need to know the two independent homogeneous solutions to the tensor mode equations (3.18), say $h _ { 1 }$ and $h _ { 2 }$ . For constant $w$ they are given as well in terms of Bessel functions with one order less than in $\Phi$ , concretely

$$
h _ { 1 } ( k \tau ) = ( k \tau ) ^ { - b - 1 / 2 } J _ { b + 1 / 2 } ( k \tau ) \quad \mathrm { a n d } \quad h _ { 2 } ( k \tau ) = ( k \tau ) ^ { - b - 1 / 2 } Y _ { b + 1 / 2 } ( k \tau ) .
$$

In Eq. (4.6), $h _ { 1 }$ and $h _ { 2 }$ respectively are the growing and decaying modes. Note that there is no $c _ { s }$ since in general relativity tensor modes propagate at the speed of light. This yields a Green’s function (see App. B) given by

$$
G ( \tau , \tilde { \tau } ) = \frac { \pi } { 2 k } \frac { ( k \tilde { \tau } ) ^ { b + 3 / 2 } } { ( k \tau ) ^ { b + 1 / 2 } } \left( J _ { b + 1 / 2 } ( k \tilde { \tau } ) Y _ { b + 1 / 2 } ( k \tau ) - J _ { b + 1 / 2 } ( k \tau ) Y _ { b + 1 / 2 } ( k \tilde { \tau } ) \right) .
$$

This finishes the list of necessary ingredients for our induced GWs calculations. In passing, since there always appears the combination $k \tau$ or $k \tilde { \tau }$ we introduce the useful notation

$$
x \equiv k \tau ,
$$

which we will use from now on. Also, a tilde on $x$ implies a tilde on $\tau$ , i.e., $\tilde { x } = k \tilde { \tau }$ .

Thus far it seems that we may have to deal with several integrals containing at least three Bessel functions, which is challenging to do analytically in general. However, the source term to the induced GWs ends up acquiring a simple enough form after several simplifications. For instance, using the Bessel functions properties (see App. F), we find that Eq. (3.20) reduces to

$$
\begin{array} { c l } { \displaystyle f ( x , u , v ) = \frac { 2 ^ { 2 b + 3 } \Gamma ^ { 2 } [ b + 5 / 2 ] } { ( 2 b + 3 ) ( b + 2 ) } ( c _ { s } x ) ^ { - 2 b - 1 } ( u v ) ^ { - b - 1 / 2 } } \\ { \displaystyle \times \left( J _ { b + 1 / 2 } ( c _ { s } v x ) J _ { b + 1 / 2 } ( c _ { s } u x ) + \frac { b + 2 } { b + 1 } J _ { b + 5 / 2 } ( c _ { s } v x ) J _ { b + 5 / 2 } ( c _ { s } u x ) \right) , } \end{array}
$$

where we used $x$ from (4.8) and $u$ and $v$ from (3.26). To arrive at (4.9) one needs to write the Bessel function $\boldsymbol { J } _ { b + 3 / 2 }$ that appears in $\Phi$ in a combination of $J _ { b + 1 / 2 }$ and $J _ { b + 5 / 2 }$ which can be found in App. F. So far, it is not entirely clear whether there is any physical reason behind the simplification (4.9) which turns out to render the source term as a sum of the squared of Bessel functions of the same order. This simple form of the source term is crucial to obtain analytical formulas for general $b$ and $c _ { s }$ that we derive below.

Replacing (4.9) and (4.8) into Eq. (3.27) we find that the kernel can be written as

$$
I ( x , u , v ) = \pi 4 ^ { b } \Gamma ^ { 2 } [ b + 3 / 2 ] \frac { 2 b + 3 } { b + 2 } ( c _ { s } ^ { 2 } u v x ) ^ { - b - 1 / 2 } \left( J _ { b + 1 / 2 } ( x ) \mathcal { T } _ { Y } - Y _ { b + 1 / 2 } ( x ) \mathcal { T } _ { J } \right) ,
$$

where we defined for compactness

$$
\begin{array} { l } { \displaystyle \mathcal { Z } _ { J / Y } \equiv \int _ { 0 } ^ { x } d \tilde { x } \tilde { x } ^ { 1 / 2 - b } \left\{ { J } _ { b + 1 / 2 } ( \tilde { x } ) \atop { Y _ { b + 1 / 2 } ( \tilde { x } ) } \right\} } \\ { \displaystyle \qquad \times \left( J _ { b + 1 / 2 } ( c _ { s } v \tilde { x } ) J _ { b + 1 / 2 } ( c _ { s } u \tilde { x } ) + \frac { b + 2 } { b + 1 } J _ { b + 5 / 2 } ( c _ { s } v \tilde { x } ) J _ { b + 5 / 2 } ( c _ { s } u \tilde { x } ) \right) . } \end{array}
$$

Unfortunately, we are not aware of a general analytical formula for the time integrals (4.11) unless $b \in \mathbb { Z }$ , in which case the Bessel functions reduce to spherical Bessel functions and can be written in terms of transcendental functions. This is for example the case of radiation domination $b = 0$ ( $w = 1 / 3$ ), where the general kernel can be found in Ref. [63]. Nevertheless, we can integrate (4.11) in two relevant limits, $x \gg 1$ (subhorizon) and $x \ll 1$ (superhorizon).

Let us explain the assumptions needed for the approximations before jumping into the actual calculations. We are considering that right after inflation there is a period when the universe has a free $b$ (or $w$ ) and free $c _ { s }$ . However, to recover the standard hot big bang cosmology, such epoch must end, and the universe must enter a radiation domination stage. Thus, whatever solution we find in this section for the induced GWs must be followed until we reach the radiation dominated stage. For simplicity, we will assume an instantaneous transition. Then, we will refer to the time of transition as “reheating” time $\tau _ { \mathrm { r h } }$ and the comoving size of the horizon at that time as “reheating” scale $k _ { \mathrm { r h } }$ . The value of $k _ { \mathrm { r h } }$ in terms of the “reheating” temperature $T _ { \mathrm { r h } }$ can be found in Eq. (2.32). The assumption of an instantaneous transition might be important for those tensor modes with wavenumber $k \sim k _ { \mathrm { r h } }$ . Namely, those modes which entered the horizon around the transition. If the transition is gradual, then our approximations will not be very good for modes which entered during the last stages of the transition. In any case, as we shall see, the instantaneous approximation gives a very good idea of the shape of the induced GW spectrum even for $k \sim k _ { \mathrm { r h } }$ . On top of that, we will assume that the scale corresponding to the peak of the primordial spectrum enters the horizon well before reheating so that during and after reheating there is no significant source of induced GWs. In the case of a top-hat primordial spectrum, this means that the scale corresponding to the IR cut-off enters the horizon much before reheating. Under these two assumptions, i.e., sudden transition and “localized” primordial spectrum, we can proceed to derive our analytical formulas. Note that this does not apply to the case when ${ c _ { s } } = 0$ which we discuss in Sec. 6.

# 4.2 General subhorizon kernel

Let us start with the simplest situation. This corresponds to the case when all modes of interest entered the horizon much before reheating, that is $k \gg k _ { \mathrm { r h } }$ . Then, we can safely send the upper integration limit in (4.11) to infinity, i.e., $x = k \tau \gg 1$ . This is because when we eventually match our solution at reheating to a free GW propagating in a radiation dominated universe, the upper limit would be $x _ { \mathrm { r h } } = k \tau _ { \mathrm { r h } } \sim k / k _ { \mathrm { r h } } \gg 1$ . The integrals (4.11) for $x \to \infty$ are derived by Gervois and Navelet [233] and given in App. G. Here we just give the form of (4.10) after integration, which reads

$$
\begin{array} { l } { { I ( x \gg 1 , u , v ) = x ^ { - b - 1 } 4 ^ { b } \Gamma ^ { 2 } [ b + 3 / 2 ] \frac { 2 b + 3 } { b + 2 } \frac { | 1 - y ^ { 2 } | ^ { b / 2 } } { c _ { s } ^ { 2 } u v } } } \\ { { \qquad \times \{ \begin{array} { l l } { { \displaystyle \cos ( x - \frac { b \pi } { 2 } ) ( \mathrm { P } _ { b } ^ { - b } ( y ) + \frac { b + 2 } { b + 1 } \mathrm { P } _ { b + 2 } ^ { - b } ( y ) ) \Theta [ c _ { s } ( u + v ) - 1 ] } } \\ { { \qquad \quad + \frac { 2 } { \pi } \sin ( x - \frac { b \pi } { 2 } ) ( \mathrm { Q } _ { b } ^ { - b } ( y ) + \frac { b + 2 } { b + 1 } \mathrm { Q } _ { b + 2 } ^ { - b } ( y ) ) \Theta [ c _ { s } ( u + v ) - 1 ] } } \\ { { \qquad \quad - \frac { 2 } { \pi } \sin ( x - \frac { b \pi } { 2 } ) ( \mathrm { Q } _ { b } ^ { - b } ( - y ) + 2 \frac { b + 2 } { b + 1 } \mathrm { Q } _ { b + 2 } ^ { - b } ( - y ) ) \Theta [ 1 - c _ { s } ( u + v ) ] \} , } } \end{array}  } } \end{array}
$$

where $\Theta [ x ]$ is the Heaviside function, $\mathsf { P } _ { b } ^ { - b } ( y )$ and $\mathsf Q _ { b } ^ { - b } ( y )$ are the Ferrer’s function of the first and second kind, valid for $| y | < 1$ , and $\mathcal { Q } _ { b } ^ { - b } ( y )$ is the associated Legendre function of the second kind, valid for $| y | > 1$ . Their explicit expressions in terms of Hypergeometric functions can be found in App. H. We also defined for simplicity

$$
y = 1 - \frac { 1 - c _ { s } ^ { 2 } ( u - v ) ^ { 2 } } { 2 c _ { s } ^ { 2 } u v } = - 1 - \frac { 1 - c _ { s } ^ { 2 } ( u + v ) ^ { 2 } } { 2 c _ { s } ^ { 2 } u v } ,
$$

and we Taylor expanded the Bessel functions for large argument. Note that $y$ is related to the area of the triangle made by the three momenta, $c _ { s } | \mathbf { k } - \mathbf { q } |$ , $c _ { s } | \mathbf { q } |$ and $k$ . The presence of the Heaviside function in (4.12) signals the possible resonance we anticipated in Sec. 2.2 when the wavenumber of a tensor modes equals the sum of two typical scalar modes $2 c _ { s } k _ { p } \sim k$ . In more practical terms, when $c _ { s } ( u + v ) \sim 1$ the three Bessel functions in the definite integral (4.11) for $x \to \infty$ conspire (by rendering their product as coherent oscillations) and yield a divergent integral. Also note that Eq. (4.12) has the same time dependence as a subhorizon tensor mode propagating in a constant $b$ and $c _ { s }$ universe, e.g., see Eq. (4.6). In other words, it decays as $a ^ { - 2 }$ and oscillates with a frequency proportional to $x$ . This was expected as the source term for induced GWs decays once inside the horizon and, therefore, induced GWs behave as a freely propagating GW. This does not apply in the case of a dust dominated universe though.

In the current form Eq. (4.12) is general enough so that it can also be used in the C (3.34) and Z (3.35) NG terms. However, in this review we are more interested with the Gaussian contribution (3.25). Thus, we are more concerned about the averaged square kernel. After some simple algebra, that is squaring (4.12) and calculating the oscillation average, we arrive at

$$
\begin{array} { l } { \displaystyle \overline { { I ^ { 2 } ( x , u , v ) } } = x ^ { - 2 ( b + 1 ) } 4 ^ { 2 b } \Gamma ^ { 4 } [ b + 3 / 2 ] \left( \frac { 2 b + 3 } { b + 2 } \right) ^ { 2 } \frac { | 1 - y ^ { 2 } | ^ { b } } { 2 c _ { s } ^ { 4 } u ^ { 2 } v ^ { 2 } } } \\ { \displaystyle \qquad \times \left\{ \left( \mathsf { P } _ { b } ^ { - b } ( y ) + \frac { b + 2 } { b + 1 } \mathsf { P } _ { b + 2 } ^ { - b } ( y ) \right) ^ { 2 } \Theta [ c _ { s } ( u + v ) - 1 ] \right. } \\ { \displaystyle \qquad + \left. \frac { 4 } { \pi ^ { 2 } } \left( \mathsf { Q } _ { b } ^ { - b } ( y ) + \frac { b + 2 } { b + 1 } \mathsf { Q } _ { b + 2 } ^ { - b } ( y ) \right) ^ { 2 } \Theta [ c _ { s } ( u + v ) - 1 ] \right. } \\ { \displaystyle \qquad + \left. \frac { 4 } { \pi ^ { 2 } } \left( \mathsf { Q } _ { b } ^ { - b } ( - y ) + 2 \frac { b + 2 } { b + 1 } \mathsf { Q } _ { b + 2 } ^ { - b } ( - y ) \right) ^ { 2 } \Theta [ 1 - c _ { s } ( u + v ) ] \right\} . } \end{array}
$$

With the averaged kernel (4.14) we are ready to compute the induced GWs in quite general situations. We are only left with the integral over momenta which can be easily computed numerically. Analytical formulas for the final GW spectrum are discussed in Sec. 5. Let us note that although (4.14) might look technically complicated to implement, it is by far more useful than attempting a numerical integration of three Bessel functions. Furthermore, the superhorizon approximation is very good for modes with $k \gg k _ { \mathrm { r h } }$ regardless of the shape of the primordial spectrum. This is because induced GWs with $k \gg k _ { \mathrm { r h } }$ are essentially already free GWs. Thus, soon after horizon re-entry and thereon they will behave as relativistic particles in an expanding universe. This also means that we can evaluate (4.14) and (2.7) at the instantaneous reheating time, i.e., $\tau = \tau _ { \mathrm { r h } }$ , to estimate the observable spectral density of induced GWs. We will do this shortly. If the transition is gradual, the kernel (4.14) is a good approximation for modes which enter during a period with almost constant $b$ .

In the next subsections, we will have a closer inspection to the kernel (4.14). After matching to radiation domination, we will look at the behaviour of the kernel near the resonant point and in the IR tail.

# 4.2.1 Matching to radiation domination

Let us discuss the matching to radiation domination in more technical terms. After matching the background quantities at $\tau = \tau _ { \mathrm { r h } }$ , that is the scale factor $a$ and the Hubble parameter $\mathcal { H }$ we find that $a$ and $\mathcal { H }$ in the radiation dominated period follows the typical solution (found in (2.16) with

$w = 1 / 3$ ) with a shifted conformal time, which reads

$$
\bar { \tau } \equiv \tau - \frac { b } { 1 + b } \tau _ { \mathrm { r h } } ,
$$

where $b$ is related to the equation of state of the previous epoch by (2.16). Now, for the matching of tensor modes it is important to realize that the continuity of $h _ { i j }$ and its first derivative imply the continuity of the kernel (3.27) and its first derivative. Thus, from now on we simply deal with the matching of the kernel (3.27). Since we are dealing with subhorizon scales we have that the kernel before the transition is

$$
I ( x \gg 1 , u , v ) \approx x ^ { - b - 1 } \left( A _ { 1 , b } \sin \left( x - \frac { b \pi } { 2 } \right) + A _ { 2 , b } \cos \left( x - \frac { b \pi } { 2 } \right) \right) ,
$$

where the coefficients, not important at the moment, can be extracted from Eq. (4.12). The kernel after the transition is also for subhorizon modes, which must have the form of a freely propagating GW in a radiation dominated universe, namely

$$
I _ { R D } ( x \gg 1 , u , v ) \approx A _ { 1 , R D } \frac { \sin \bar { x } } { \bar { x } } + A _ { 2 , R D } \frac { \cos \bar { x } } { \bar { x } } .
$$

It is easy to convince oneself that after matching (4.16) and (4.17) at $\tau = \tau _ { \mathrm { r h } }$ one finds that

$$
A _ { 1 , R D } ^ { 2 } + A _ { 2 , R D } ^ { 2 } = \left( { \frac { k \tau _ { \mathrm { r h } } } { 1 + b } } \right) ^ { 2 } \left( A _ { 1 , b } ^ { 2 } + A _ { 2 , b } ^ { 2 } \right) .
$$

This implies that although we should be calculating

$$
\Omega _ { \mathrm { G W } } ( k \gg k _ { \mathrm { r h } } , \tau \gg \tau _ { \mathrm { r h } } ) = \frac { k ^ { 2 } } { 1 2 a ^ { 2 } H ^ { 2 } } \overline { { \mathcal { P } _ { h } ^ { R D } } } ,
$$

with

$$
\overline { { \mathcal { P } _ { h } ^ { R D } } } = 8 \int _ { 0 } ^ { \infty } d v \int _ { | 1 - v | } ^ { 1 + v } d u \left( \frac { 4 v ^ { 2 } - ( 1 - u ^ { 2 } + v ^ { 2 } ) ^ { 2 } } { 4 u v } \right) ^ { 2 } \overline { { I _ { R D } ^ { 2 } ( x \gg 1 , v , u ) } } \mathcal { P } _ { \Phi } ( k u ) \mathcal { P } _ { \Phi } ( k v ) ,
$$

it is equivalent to evaluate

$$
\Omega _ { \mathrm { G W } } ( k \gg k _ { \mathrm { r h } } , \tau \gg \tau _ { \mathrm { r h } } ) = \frac { k ^ { 2 } } { 1 2 a ^ { 2 } H ^ { 2 } } \overline { { \mathcal { P } _ { h } } } \Big | _ { \tau = \tau _ { \mathrm { r h } } } ,
$$

with

$$
\overline { { \mathcal { P } _ { h } } } = 8 \int _ { 0 } ^ { \infty } \mathop { d v } \int _ { | 1 - v | } ^ { 1 + v } \mathop { d u } \left( \frac { 4 v ^ { 2 } - ( 1 - u ^ { 2 } + v ^ { 2 } ) ^ { 2 } } { 4 u v } \right) ^ { 2 } \overline { { I ^ { 2 } ( x \gg 1 , v , u ) } } \mathcal { P } _ { \Phi } ( k u ) \mathcal { P } _ { \Phi } ( k v ) ,
$$

where the kernel is that given in (4.14).

It is important to note that our subhorizon approximation is valid for modes with $k \tau _ { \mathrm { r h } } \gg 1$ . Later, we may try to join the subhorizon approximation with the superhorizon approximation valid for $k \tau _ { \mathrm { r h } } \ll 1$ by extrapolating up to $k \tau _ { \mathrm { r h } } \sim 1$ . Let us call such scale $k _ { m }$ . However, there is an important subtlety in joining the two approximations. If we look at the scale that last crossed the horizon at reheating, namely

$$
k _ { \mathrm { r h } } = \mathcal { H } _ { \mathrm { r h } } = \frac { 1 + b } { \tau _ { \mathrm { r h } } } ,
$$

![](images/4421f9e3ffa1602258206862e54cca462fb817faa787a5e3227a900b6f14e092.jpg)  
Figure 2: On the left, relation between the three vectors involved in the integrals of induced GWs for the Gaussian part. On the right, illustration of the triangle inequality. We see that when $1 < c _ { s } ( u + v )$ and $c _ { s } < 1$ we are below the triangle inequality and the resonance is allowed by momentum conservation.

we see that if we compare with $k _ { m }$ we have that

$$
\frac { k _ { m } } { k _ { \mathrm { r h } } } = \frac { 1 } { 1 + b } .
$$

For $b > 0$ we have that $k _ { m } < k _ { \mathrm { r h } }$ . This means that our subhorizon approximation is even valid for $k \sim k _ { \mathrm { r h } }$ and, therefore, we expect a good matching with the superhorizon approximation at $k \sim k _ { \mathrm { r h } }$ (since for $k < k _ { \mathrm { r h } }$ the modes are superhorizon before the transition). However, for $b < 0$ we find $k _ { m } > k _ { \mathrm { r h } }$ . This time the subhorizon approximation breaks down for $k > k _ { \mathrm { r h } }$ and so we expect the matching with the superhorizon approximation to be at $k \sim k _ { m }$ . This is what we eventually find in Sec. 4. In addition to the above, we have that the subhorizon approximation has corrections of $O ( x ^ { 1 + b } )$ [74]. So for $b < 0$ the corrections quickly become important for $x \sim 1$ . A detailed studied for $b < 0$ , perhaps with numerical methods, is needed to clarify the exact shape of the GW spectrum. Nevertheless, our results should be a good order of magnitude estimate.

Let us remind the reader that when implementing (4.14) inside the tensor spectrum (3.25), we must bear in mind that if we are considering primordial curvature fluctuations from inflation, we have to rescale the spectrum of $\Phi$ accordingly, namely

$$
\mathcal { P } _ { \Phi } = \left( \frac { b + 2 } { 2 b + 3 } \right) ^ { 2 } \mathcal { P } _ { \mathcal { R } } .
$$

# 4.2.2 Resonances

Here we focus on the general behaviour near the resonant point for the averaged kernel (4.14) that we discussed in Sec. 2.2. We start by noting that we have three vectors, the one from the tensor mode $\mathbf { k }$ and the two scalar modes, $\mathbf { q }$ and ${ \bf k } - { \bf q }$ , which of course satisfy momentum conservation. Recall that from Eq. (3.26) $q$ corresponds to $v$ and $| \mathbf { k } - \mathbf { q } |$ to $u$ . This means that our three variables satisfy a triangle inequality, that is

$$
| k - q | < | { \bf k - q } | < k + q \mathrm { o r } | | { \bf k - q } | - q | < k < | { \bf k - q } | + q ,
$$

which translates into

$$
\left| 1 - v \right| < u < 1 + v \quad \mathrm { o r } \quad \left| u - v \right| < 1 < u + v .
$$

The area $A$ of the triangle made by $k$ , $q$ and $| \mathbf k - \mathbf q |$ is related to the angle between $\mathbf { k }$ and $\mathbf { q }$ by

$$
\sin \theta _ { k } = \frac { 2 A } { k q } .
$$

This means that the projection with the polarization tensor (see App. D) is proportional to the area, namely

$$
e _ { \lambda } ^ { i j } q _ { i } q _ { j } \propto \sin ^ { 2 } \theta _ { k } \propto A ^ { 2 } .
$$

This implies that the saturation of the triangle inequality at $u + v = 1$ corresponds to zero area and, therefore, does not contribute to the integral (3.25). Now, from the arguments in Sec. 2.2 we expect a resonance when

$$
c _ { s } ( u + v ) = 1 .
$$

Thus, if we have $c _ { s } ^ { 2 } = 1$ the resonant point coincides with the saturation of the triangle inequality and, thus, has vanishing contribution. In this way we see that, by momentum conservation, there is no resonance for $c _ { s } ^ { 2 } = 1$ in the induced GW spectrum. Nevertheless, for $c _ { s } ^ { 2 } < 1$ we do have a resonance inside the integration region (see Fig. 2).

We can confirm these expectations by expanding the kernel (4.14) around $c _ { s } ( u + v ) \sim 1$ which corresponds to $y \sim - 1$ , where the associated Legendre functions might have a divergence. The asymptotic behaviours around $y \sim - 1$ are given in App. H. Focusing first on the case $b < 0$ , we find that the kernel diverges as

$$
\overline { { I _ { \mathrm { r e s } } ^ { 2 } ( x , u , v , b < 0 ) } } \approx x ^ { - 2 ( b + 1 ) } 4 ^ { 2 b } \Gamma ^ { 4 } [ b + 5 / 2 ] \frac { 8 } { c _ { s } ^ { 4 } u ^ { 2 } v ^ { 2 } } \frac { \csc ^ { 2 } ( b \pi ) } { \Gamma ^ { 2 } [ 3 + b ] } | 1 - | y | | ^ { 2 b } .
$$

This recovers Eq. (2.29) which showed that a very peaked primordial spectrum, so that $u \sim v \sim$ $k _ { p } / k$ , leads to

$$
\Omega _ { \mathrm { G W s } } ^ { \mathrm { r e s } } ( b < 0 ) \propto | 1 - | y | | ^ { 2 b } \propto | k - 2 c _ { s } k _ { p } | ^ { 2 b } .
$$

The case $b = 0$ is explicitly given in Eq. (10.6). In the case when $b > 0$ , we arrive at

$$
\overline { { { I _ { \mathrm { r e s } } ^ { 2 } ( x , u , v , b > 0 ) } } } \approx x ^ { - 2 ( b + 1 ) } 4 ^ { 3 b } \Gamma ^ { 4 } [ b + 5 / 2 ] \frac { 3 2 } { \pi ^ { 2 } c _ { s } ^ { 4 } u ^ { 2 } v ^ { 2 } } \left( \frac { ( 1 + b + b ^ { 2 } ) } { ( b + 1 ) ( b + 2 ) } \frac { \Gamma [ b ] } { \Gamma [ 2 b + 3 ] } \right) ^ { 2 } ,
$$

which is independent of $y$ . Thus, as expected there is no resonance for $b > 0$ . Nevertheless, as shown in [64] for $1 > b > 0$ there is still a peak at $k = 2 c _ { s } k _ { p }$ in the induced GWs spectrum for a peaked primordial spectrum. We can roughly understand the peak by noting that since $\mathcal { Q } _ { b } ^ { - b } ( y ) \sim ( 1 - y ) ^ { - b }$ , the next leading order must be $\mathcal Q _ { b } ^ { - b } ( y ) \sim ( 1 - y ) ^ { - b } +$ constant since $b < 1$ . Then, inserting this into the kernel (4.14) we find that

$$
\Omega _ { \mathrm { G W s } } ^ { \mathrm { r e s } } ( 1 < b < 0 ) \propto \mathrm { c o n s t a n t } - | 1 - | y | | ^ { b } \propto \mathrm { c o n s t a n t } - | k - 2 c _ { s } k _ { p } | ^ { b } .
$$

For $b > 1$ and $c _ { s } \neq 1$ there is no detailed study of the kernel (4.14). Nevertheless, by looking at the explicit expression for $b = 2$ (10.10) we see that there is nothing special at $c _ { s } ( u + v ) = 1$ . Before ending this section, note that the kernel is symmetric around the resonant point $c _ { s } ( u + v ) = 1$ . It displays the same behaviour when approaching from both directions, $c _ { s } ( u + v ) \to 1 ^ { \pm }$ .

# 4.2.3 Infrared regime

Here we show the behaviour of the kernel when $u \sim v \gg 1$ which is the relevant regime for the IR tail of the GW spectrum as $v \sim k _ { p } / k$ and $k \ll k _ { p }$ . This limit means that, if there is any peak in the spectrum of scalar fluctuations, we are looking at scales much larger than the scale of the peak. Thus, such limit of the kernel (4.14) is relevant for wavenumbers $k _ { \mathrm { r h } } \ll k \ll k _ { p }$ , where we included $k _ { \mathrm { r h } }$ since it is the limit of the subhorizon approximation. The cases $b < 0$ and $b > 0$ exhibit different behaviours as anticipated in Sec. 2.2. In the limit $y  1$ , the average kernel (4.14) is respectively given by

$$
\overline { { I _ { \mathrm { I R } } ^ { 2 } ( x \gg 1 , u , v , b < 0 ) } } \approx x ^ { - 2 ( b + 1 ) } 4 ^ { 2 b } \Gamma ^ { 4 } [ b + 5 / 2 ] \frac { 8 } { c _ { s } ^ { 4 } u ^ { 2 } v ^ { 2 } } \frac { \csc ^ { 2 } ( b \pi ) } { \Gamma ^ { 2 } [ 3 + b ] } | 1 - y | ^ { 2 b } ,
$$

for $b < 0$ and

$$
\overline { { I _ { \mathrm { I R } } ^ { 2 } ( x \gg 1 , u , v , b > 0 ) } } \approx x ^ { - 2 ( b + 1 ) } 4 ^ { 3 b } \Gamma ^ { 4 } [ b + 5 / 2 ] \frac { 3 2 } { \pi ^ { 2 } c _ { s } ^ { 4 } u ^ { 2 } v ^ { 2 } } \left( \frac { ( 1 + b + b ^ { 2 } ) } { ( b + 1 ) ( b + 2 ) } \frac { \Gamma [ b ] } { \Gamma [ 2 b + 3 ] } \right) ^ { 2 } ,
$$

for $b > 0$ . They are actually very similar to (4.31) and (4.33), except for the fact that we are now looking at $u \sim v \gg 1$ , so that $1 - y \sim v ^ { - 2 }$ . Evaluating (4.35) and (4.36) at the time of reheating and taking into account the factor $k ^ { 2 }$ in (3.25), we see that whatever the IR scaling in the radiation dominated universe (which for localized sources is $k ^ { 3 }$ [78]) we have to correct the exponent by a factor $- 2 | b |$ , i.e., to $k ^ { 3 - 2 | b | }$ for a localized sourced. This is the same result as in Sec. 2.2. The absolute value is due to an extended superhorizon growth of tensor modes for $b < 0$ , as explained in Sec. 2.2.

# 4.3 Superhorizon kernel approximation

In the previous subsections we have studied in detail the subhorizon kernel. However, there are modes which are still superhorizon at the time of reheating. Thus, for such modes we cannot take the upper limit in (4.11) to $x \to \infty$ as $x \ll 1$ at reheating. In addition to the approximation $x \ll 1$ , we will use the assumption that the peak in the scalar spectrum $\mathcal { P } _ { \Phi }$ is on scales $k _ { p } \gg k _ { \mathrm { r h } }$ . This means that we are only concerned with the region of integration of (4.11) around the peak in $\mathcal { P } _ { \Phi }$ , where we have that $v \sim k _ { p } / k \gg 1$ and therefore $u \sim v \gg 1$ . Using this fact we can expand the first Bessel function for small argument in (4.11) and integrate in the limit of $u \sim v$ . By doing so we arrive at Eq. (2.20) but for the kernel, namely

$$
I ( x \ll 1 , u , v ) \approx B _ { 1 , b } + B _ { 2 , b } x ^ { - 2 b } ,
$$

where the exact coefficients are given by

$$
B _ { 1 , b } = - \frac { ( 3 + 2 b ) ^ { 2 } ( 1 + b + b ^ { 2 } ) } { 4 b ( 1 + b ) ^ { 2 } ( 2 + b ) } ( c _ { s } v ) ^ { - 2 } \quad , \quad B _ { 2 , b } = \frac { 4 ^ { 1 + b } \Gamma ^ { 2 } [ b + 5 / 2 ] } { b ( 1 + b ) ( 2 + b ) \pi } ( c _ { s } v ) ^ { - 2 ( 1 + b ) } .
$$

The details on the integrations can be found in App. G. Thus, we have found the kernel for modes which are superhorizon before reheating. However, these induced tensor modes are not yet GWs so we must follow them after they enter the horizon in the radiation domination era.

# 4.3.1 Matching to radiation domination

The kernel (4.37) is valid for superhorizon modes during an arbitrary $b =$ constant period. After this period ends with a sudden reheating, we shall assume that the source term is shut off and tensor modes evolve as freely propagating massless tensor mode. As explained in Sec. 4.3 the continuity

of $h _ { i j }$ implies continuity of the kernel. This means that the kernel goes from (4.37) to the kernel of a superhorizon tensor mode in radiation domination, which reads

$$
I _ { R D } ( \bar { x } \ll 1 , u , v ) \approx B _ { 1 , R D } + B _ { 2 , R D } ( k \bar { \tau } ) ^ { - 1 } \quad \mathrm { w i t h } \quad \bar { \tau } \equiv \tau - \frac { b } { 1 + b } \tau _ { \mathrm { r h } } ,
$$

where we introduced $\tau$ from the continuity of the background FLRW metric, i.e., we imposed continuity of $a$ and $\mathcal { H }$ at $\mathit { \Delta } _ { \mathcal { I } } = \mathit { \Delta } _ { \mathcal { I } } { } _ { \mathrm { r h } }$ . Matching (4.39) and its first derivatives with (4.37), we find that

$$
B _ { 1 , R D } = B _ { 1 , b } + \frac { 1 - b } { 1 + b } B _ { 2 , b } ( k \tau _ { \mathrm { r h } } ) ^ { - 2 b } \quad , \quad B _ { 2 , R D } = \frac { 2 b } { ( 1 + b ) ^ { 2 } } B _ { 2 , b } ( k \tau _ { \mathrm { r h } } ) ^ { 1 - 2 b } .
$$

Thus, we have effectively continued the superhorizon kernel from the $b = \mathrm { c o n s t a n t }$ era to the radiation era. We can now follow the kernel down to subhorizon scales, which must behave as a tensor mode in a radiation dominated universe as there is no source, that is Eq. (4.6) with $b = 0$ . Then, taking the averaged square kernel yields

$$
\overline { { I _ { R D } ^ { 2 } ( k \ll k _ { \mathrm { r h } } , \tau \gg \tau _ { \mathrm { r h } } ) } } \approx \frac { 1 } { 2 \bar { x } ^ { 2 } } \left( B _ { 1 , R D } ^ { 2 } + B _ { 2 , R D } ^ { 2 } \right) .
$$

After picking up the most relevant contributions, that is the leading terms for $v \gg 1$ , we arrive at

$$
\begin{array} { r l } & { \overline { { I _ { R D } ^ { 2 } ( k \ll k _ { \mathrm { r h } } , \tau \gg \tau _ { \mathrm { r h } } ) } } \approx \frac { 1 } { 2 \overline { { x } } ^ { 2 } } \left( \frac { ( 3 + 2 b ) ^ { 2 } } { 4 b ( 1 + b ) ^ { 2 } ( 2 + b ) } \right) ^ { 2 } } \\ & { \times \left( ( 1 + b + b ^ { 2 } ) ( c _ { s } v ) ^ { - 2 } - 4 ^ { 1 + b } \Gamma ^ { 2 } [ b + 3 / 2 ] \frac { ( 1 - b ) } { \pi } ( c _ { s } v ) ^ { - 2 ( 1 + b ) } \left( ( 1 + b ) \frac { k } { k _ { \mathrm { r h } } } \right) ^ { - 2 b } \right) ^ { 2 } . } \end{array}
$$

This is the kernel squared that should be used in the induced GW spectrum (3.25) for scales $k \ll k _ { \mathrm { r h } }$ . In this way, the kernel (4.42) yields the right IR scaling for localized sources in a radiation dominated universe, i.e., $\Omega _ { \mathrm { G W s } } ^ { \mathrm { I R } } \propto k ^ { 3 }$ [78]. The matching between the superhozion (4.42) and subhorizon (4.14) approximations at $k \sim k _ { \mathrm { r h } }$ has shown to be very good in the instantaneous reheating case [74]. Note that for a gradual transition, the superhorizon approximation should still be good enough except for those modes which enter during the transition. We can then calculate the spectral density of induced GWs by

$$
\Omega _ { \mathrm { G W } } ( k \gg k _ { \mathrm { r h } } , \tau \gg \tau _ { \mathrm { r h } } ) = \frac { k ^ { 2 } } { 1 2 a ^ { 2 } H ^ { 2 } } \overline { { \mathcal { P } _ { h } ^ { R D } } } ,
$$

with

$$
\overline { { \mathcal { P } _ { h } ^ { R D } } } = 8 \int _ { 0 } ^ { \infty } d v \int _ { | 1 - v | } ^ { 1 + v } d u \left( \frac { 4 v ^ { 2 } - ( 1 - u ^ { 2 } + v ^ { 2 } ) ^ { 2 } } { 4 u v } \right) ^ { 2 } \overline { { I _ { R D } ^ { 2 } ( x \gg 1 , v , u ) } } \mathcal { P } _ { \Phi } ( k u ) \mathcal { P } _ { \Phi } ( k v ) ,
$$

and using Eq. (4.42). Nevertheless, it is worth noting that for a Dirac delta or a fairly sharp peak and $b > 0$ a good approximation to the full induced GW spectrum is to stop the subhorizon spectral density (4.21) at $k \sim 3 / 4 k _ { \mathrm { r h } }$ and match with a power-law $\Omega _ { \mathrm { G W } } = \Omega _ { \mathrm { G W , r h } } ( 4 k / 3 k _ { \mathrm { r h } } ) ^ { 2 }$ [74]. The amplitude of $\Omega _ { \mathrm { G W , r h } }$ can be found by matching the two.

It should be noted that Eq. (4.42) does not recover the logarithmic correction typical of induced GWs in a radiation dominated universe [79]. The main reason is that we assumed the source term to stop at reheating and, therefore, that superhorizon tensor modes at that time behave as free tensor modes. This is a good approximation taken for simplicity. However, the precise matching would require to first match the Newtonian potential $\Phi$ from a $b =$ constant universe to radiation domination and then continue the kernel (3.27) after reheating with the matched $\Phi$ . This would give a more accurate calculation and would most likely recover the logarithmic correction in the IR tail.

# 5 Typical induced GW spectra

In Sec. 4 we have derived analytical approximations for the kernel (or transfer functions) of induced GWs. However, we still have the integral over the scalar momenta. While the kernel was not so sensitive to the shape of the primordial spectrum, i.e., the approximation is valid as long as all the relevant primordial spectrum enters the horizon before reheating, the integral over momenta crucially depends on the shape of the primordial spectrum. In this section, we will present the final form of the induced GW spectrum and discuss their main features. We will not be so concerned in the series of approximations to achieve analytical formulas of the GW spectrum, which can be found in the papers. Before doing so, we will carefully derive in Sec. 5.1 what is the spectral density of induced GWs measured today. Then we will focus on the simplest types of motivated primordial spectra. These are a very sharp peak 5.2, a log-normal peak 5.3, a broken power-law 5.4 and a scale invariant spectrum 5.4.2. We will also comment on possible oscillatory features 5.5 on top of the basic shapes and the impact of primordial NG on the final GW spectrum 5.6.

$\pmb { \theta }$ Main references: Although there are many studies on the induced GW spectrum for various primordial spectra, we focus on the cases where analytical formulas have been derived. In this way, Sec. 5.1 can be derived using the formulas in App. A and can also be found in [64, 74]. Sec. 5.2 is mainly based on [74]. Sec. 5.3 follows [74, 82]. Then, Sec. 5.4 is based on [81]. Sec. 5.5 briefly describes the results of Refs. [84,87]. Lastly, Sec. 5.6 reports the main findings from Refs. [89,90,92].

# 5.1 The GW spectral density today

To find the power of GWs that we would observe we have to evaluate (2.7) today, namely

$$
\Omega _ { \mathrm { G W , 0 } } = \frac { 1 } { 3 M _ { \mathrm { p l } } ^ { 2 } H _ { 0 } ^ { 2 } } \frac { d \rho _ { \mathrm { G W , 0 } } } { d \ln k } .
$$

However, our computations in Sec. 4 were done up to and including the transition to a radiation dominated universe. Since deep inside the horizon we have that $\rho _ { \mathrm { G W } } \propto \rho _ { r } \propto a ^ { - 4 }$ then after reheating we have that $\Omega _ { \mathrm { G W } } = \Omega _ { \mathrm { G W , r h } } = \mathrm { c o n s t a n t }$ . To relate $\Omega _ { \mathrm { G W } , \mathrm { r h } }$ with $\Omega _ { \mathrm { G W } , 0 }$ we can make use of the fact that GWs behave as radiation and write

$$
\begin{array} { l } { \Omega _ { \mathrm { G W } , 0 } h ^ { 2 } = \Omega _ { r , 0 } h ^ { 2 } \displaystyle \frac { 1 } { \rho _ { r , 0 } } \frac { d \rho _ { \mathrm { G W } , 0 } } { d \ln k } } \\ { = 1 . 6 2 \times 1 0 ^ { - 5 } \left( \frac { \Omega _ { r , 0 } h ^ { 2 } } { 4 . 1 8 \times 1 0 ^ { - 5 } } \right) \left( \frac { g _ { * } ( T _ { \mathrm { r h } } ) } { 1 0 6 . 7 5 } \right) \left( \frac { g _ { * s } ( T _ { \mathrm { r h } } ) } { 1 0 6 . 7 5 } \right) ^ { - 4 / 3 } \Omega _ { \mathrm { G W , r h } } . } \end{array}
$$

where $\Omega _ { r , 0 } h ^ { 2 } \approx 4 . 1 8 \times 1 0 ^ { - 5 }$ is the density fraction of radiation today given by Planck [2]. We also traced ${ \rho } _ { r , 0 }$ and $\rho _ { G W , 0 }$ back to the reheating time taking into account that the effective degrees of freedom change with temperature. In the case that the induced GWs are generated during a radiation domination era we should replace the subscript “rh” for the evaluation at a time when the induced tensor modes start to behave as a GW. This is denoted with a subscript “ $\mathrm { \bf c }$ ” by Inomata et al. [126].

# 5.2 Dirac delta peak

The simplest case is that of a very sharp peak in the primordial spectrum. While this type of spectrum is not possible to generate during single field inflation [103, 109, 234], it may be achieved

in multi-field models of inflation [95, 235–242]. If the peak is extremely sharp, it is often modelled by a Dirac delta as

$$
\mathcal { P } _ { \mathcal { R } } ( k ) = \mathcal { A } _ { \mathcal { R } } \delta \left( \ln ( k / k _ { p } ) \right) .
$$

Although this might be an unrealistic situation, it captures the essence of sharp peaks and gives insight on the kernel. We discuss a more realistic situation in section 5.3. Now, for the power spectrum inside the integral (3.25) we have

$$
\mathcal { P } _ { \mathcal { R } } ( v k ) = { \mathcal A } _ { \mathcal { R } } \delta \left( \ln ( v k / k _ { p } ) \right) = { \mathcal A } _ { \mathcal { R } } \frac { k _ { p } } { k } \delta \left( v - \frac { k _ { p } } { k } \right) ,
$$

and similarly for $u$ . Recall, however, that the integral over $u$ is bounded by momentum conservation to $| 1 - v | < u < 1 + v$ . So, when we integrate over $\boldsymbol { v }$ and $u$ using the Dirac delta, the range is now $| k - k _ { p } | < k _ { p } < k + k _ { p }$ . This translates to a range in $k$ given by $0 < k < 2 k _ { p }$ . After taking this finite range of $k$ into consideration, we may simply evaluate at $v = u = k _ { p } / k$ the integrand (4.20) (and (4.44)) and insert it into (4.19) (and (4.43)) to arrive at

$$
\Omega _ { \mathrm { G W , r h } } ( k ) = \frac { 2 } { 3 } \left( \frac { k _ { p } } { k _ { \mathrm { r h } } } \right) ^ { 2 } \left( 1 - \frac { k ^ { 2 } } { 4 k _ { p } ^ { 2 } } \right) ^ { 2 } \overline { { I _ { R D } ^ { 2 } \left( k / k _ { \mathrm { r h } } , k / k _ { p } \right) } } \Theta ( 2 k _ { p } - k ) .
$$

Note that we are being general by allowing a $b =$ constant phase before the standard radiation domination. Since we are assuming an instantaneous transition at $\tau = \tau _ { \mathrm { r h } }$ from the $b =$ constant to radiation domination, we have to include the scale $k _ { \mathrm { r h } }$ corresponding to the last scale that entered the horizon at the transition. In more detail, $k _ { \mathrm { r h } }$ is related to $\tau _ { \mathrm { r h } }$ by

$$
k _ { \mathrm { r h } } = \mathcal { H } _ { \mathrm { r h } } = \frac { 1 + b } { \tau _ { \mathrm { r h } } } .
$$

Thus, we have that $x _ { \mathrm { r h } } = k \tau _ { \mathrm { r h } } = ( 1 + b ) k / k _ { \mathrm { r h } }$ . If we are considering the induced GWs in a radiation dominated universe we may simply replace $k _ { \mathrm { r h } }  k _ { p }$ and recover the standard formula [63]. In Figs. 3 and 4 we see the GW spectrum for different values of $b$ and respectively for $c _ { s } ^ { 2 } = w$ and $c _ { s } ^ { 2 } = 1$ , so that the resonance is evident.

Despite the fact that (5.5) is already a completely analytical formula, the functional complication does not provide much insight yet. Nevertheless, we can check one interesting limit which is the IR tail of the spectrum. Expanding (5.5) for $k \ll k _ { p }$ we arrive at a general analytical approximation for the low frequency tail of the GW spectrum. First, for $b < 0$ we have that

$$
\begin{array} { r l } { \Omega _ { \mathrm { G W , r h } } ( b < 0 , k \ll k _ { p } ) = \displaystyle \frac { \mathcal { A } _ { R } ^ { 2 } } { 1 2 } \left( \frac { 2 ^ { 1 + b } ( 2 + b ) \Gamma ^ { 2 } [ 3 / 2 + b ] } { \pi c _ { s } ^ { 2 ( 1 + b ) } \left( 1 + b \right) ^ { 1 + b } } \right) ^ { 2 } \left( \frac { k _ { \mathrm { r h } } } { k _ { p } } \right) ^ { 2 + 4 b } } & { } \\ { \times \left\{ \begin{array} { l l } { \displaystyle \frac { 2 ^ { 3 + 2 b } } { \pi \left( 1 + b \right) ^ { 2 b } } \left( \frac { k } { k _ { \mathrm { r h } } } \right) ^ { 2 } } & { ( k \lesssim k _ { \mathrm { r h } } / ( 1 + b ) ) } \\ { \displaystyle \left( \frac { \pi } { \sin ( b \pi ) \Gamma [ 2 + b ] } \right) ^ { 2 } \left( \frac { k } { k _ { \mathrm { r h } } } \right) ^ { 2 + 2 b } } & { ( k \gtrsim k _ { \mathrm { r h } } / ( 1 + b ) ) } \end{array} \right. , } \end{array}
$$

where we set the broken power-law knee at $k \sim k _ { \mathrm { r h } } / ( 1 + b )$ since it is when the subhorizon approximation breaks down for $b < 0$ . A more detailed discussion can be found in Sec. 4.2. Second,

![](images/d38d9500a2507313bfe54c56809193b1db514afcc8be8696f568eaf1941ee518.jpg)  
Figure 3: Induced GW spectral density for a Dirac delta primordial spectrum, in terms of wavenumber $k / k _ { p }$ . We restricted the plot to $k > k _ { \mathrm { r h } }$ . We show the induced GW generated in a radiation dominated universe (red line), in a stiff fluid domination with $w \sim 0 . 9$ (purple line) and in a soft fluid domination with $w = 1 / 9$ (orange line). All cases have $c _ { s } ^ { 2 } = w$ and, thus, the spectrum presents the resonant peak at $k \sim 2 c _ { s } ^ { 2 } k _ { p }$ . We see that for softer $w$ , the position of the peak moves to the left. We also see that stiff $w$ enhances the overall amplitude of the induced GW spectrum and has a sharper resonant peak.

for $b > 0$ we find

$$
\begin{array} { r l } { \Omega _ { \mathrm { G W , r h } } ( b > 0 , k \ll k _ { p } ) = \frac { \mathcal { A } _ { R } ^ { 2 } } { 2 4 \pi } \left( \frac { \left( 2 + b \right) \left( 1 + b + b ^ { 2 } \right) } { c _ { s } ^ { 2 } b \left( 1 + b \right) ^ { 2 } } \right) ^ { 2 } \left( \frac { k _ { \mathrm { r h } } } { k _ { p } } \right) ^ { 2 } } & { } \\ { \times \left\{ \begin{array} { l l } { \left( \frac { k } { k _ { \mathrm { r h } } } \right) ^ { 2 } } & { \ : \ : \left( k \lesssim k _ { \mathrm { r h } } \right) } \\ { \frac { 1 } { 2 } \left( \frac { 2 ^ { 1 + b } \Gamma \left[ b + 3 / 2 \right] } { \left( 1 + b \right) ^ { 1 + b } } \right) ^ { 2 } \left( \frac { k } { k _ { \mathrm { r h } } } \right) ^ { 2 - 2 b } } & { \ : \ : \ : \left( k \gtrsim k _ { \mathrm { r h } } \right) } \end{array} \right. , } \end{array}
$$

where this time the matching is roughly at $k \sim k _ { \mathrm { r h } }$ . The above formulas agree with those in Ref. [74]. The difference between $b > 0$ and $b < 0$ is the continued superhorizon growth in the case of $b < 0$ which is explained in Sec. 2. The most important aspect of Eqs. (5.7) and (5.8) is that it clearly shows how the IR spectral tilt of the induced GW spectrum is directly related to the equation of state parameter at the time of induced GW generation. Thus, the observation of the IR tail gives insight on the expansion history of the primordial universe. Interestingly, for $b > 1$ ( $w < 0$ ) the spectrum has a peak at $k \sim k _ { \mathrm { r h } }$ which is larger than that at $k \sim k _ { p }$ . This means that induced GWs for $b < 1$ peaks at a different scale than the peak of the primordial spectrum. This has been used, e.g., in [132] to fit the NANOGrav results [18] and at the same time predict PBH with a mass smaller than the solar mass. If instead one assumes induced GWs in radiation domination to fit the NANOGrav frequency range, the associated PBH counterpart must be of the order of solar mass. We discuss more about these possibilities in Sec. 9. Another important point is that the amplitude of the spectrum at $k \sim k _ { p }$ strongly depends on the ratio $k _ { \mathrm { r h } } / k _ { p }$ and often mildly on $b$ . We thus see that the smaller the ratio $k _ { \mathrm { r h } } / k _ { p }$ , the more suppressed is the spectrum at $k \sim k _ { \mathrm { r h } }$ . This is because the main induced GW generation occurs when the scalar mode $k _ { p }$ enters the horizon. Then, since the modes with $k \sim k _ { \mathrm { r h } }$ have been superhorizon until the transition they can only grow by a factor $( k _ { \mathrm { r h } } / k _ { p } ) ^ { 2 }$ . For $b < 0$ the argument is slightly different because of the second superhorizon growth and so the suppression is minor compared to $b > 0$ with a power index that depends on $b$ .

![](images/b135ea083716c91fb7b30f1e35952aef4e02bbac702b7968fd6a1bffb170c343.jpg)  
Figure 4: Induced GW spectral density for a Dirac delta primordial spectra, in terms of wavenumber $k / k _ { p }$ . This time we chose $c _ { s } ^ { 2 } = 1$ and, therefore, the resonant peaks of Fig. 3 are absent. We show in red $w = 1 / 3$ , in purple $w \sim 0 . 9$ and in orange $w = 1 / 9$ . We see how the stiffer the $w$ , the larger the overall amplitude of the induced GW spectrum.

# 5.3 Log-normal peak

We now turn to a more realistic situation where the peak in the primordial spectrum has a finite width. Inspired by several models of multi-field inflation the peak of the primordial spectrum may be parametrized by a log-normal [82], namely

$$
\mathcal { P } _ { \mathcal { R } } ( k ) = \frac { \mathcal { A } _ { \mathcal { R } } } { \sqrt { 2 \pi } \Delta } \exp \left[ - \frac { \ln ^ { 2 } ( k / k _ { p } ) } { 2 \Delta ^ { 2 } } \right] ,
$$

where $\Delta$ is the dimensionless width of the peak. Note that the power spectrum (5.9) is normalized, i.e., $\begin{array} { r } { \int _ { - \infty } ^ { \infty } d \ln k \mathcal { P } _ { \mathcal { R } } ( k ) = \mathcal { A } _ { \mathcal { R } } } \end{array}$ . The log-normal parametrization includes sharp peaks where $\Delta \ll 1$ [95, 235–243] and broad peaks where $\Delta \gtrsim 1$ [62, 85, 102, 128, 238, 244–255]. For $\Delta  0$ we recover the Dirac delta case.

In this review we are mainly interested in the case of a narrow peak ( $\Delta \ll 1$ ). The reasons are its simplicity and that we can use our results for general $b$ of Sec. 5.2. The interested reader for analytical approximation in the broad peak case ( $\Delta \gtrsim 1 )$ ) in radiation domination is referred to the work of $\mathrm { P i }$ and Sasaki [82]. Here we may directly borrow their result for $\Delta \ll 1$ which reads

$$
\Omega _ { \mathrm { G W } , \Delta } ( k ) = \mathrm { e r f } \left( \frac { 1 } { \Delta } \sinh ^ { - 1 } \frac { k } { 2 k _ { p } } \right) \Omega _ { \mathrm { G W } , \delta } ( k ) ,
$$

where $\operatorname { e r f } ( x )$ is the error function and $\Omega _ { \mathrm { G W } , \delta } ( k )$ is the GW spectrum induced by a $\delta$ -function peak given in Sec. 5.2. Then, Eq. (5.10) provides the correction to the Dirac delta spectrum of Sec. 5.2 due to the small but finite width of the spectrum which leads to the $k ^ { 3 }$ IR scaling in radiation domination [78]. The most important effect then appears when the ratio of scales $k / k _ { p }$ is smaller than the width $\Delta$ . Indeed, when $k \ll k _ { p }$ we have that

$$
\Omega _ { \mathrm { G W } , \Delta } ( k ) = \mathrm { e r f } \left( \frac { k } { 2 k _ { p } \Delta } \right) \Omega _ { \mathrm { G W } , \delta } ( k ) ,
$$

which gives a correction of $\mathrm { e r f } \left( k / ( 2 k _ { p } \Delta ) \right) \sim k / ( 2 k _ { p } \Delta )$ when $\Delta \gg k / ( 2 k _ { p } )$ . Thus, due to the presence of $\Delta$ our IR tail of Sec. 5.2 changes respectively for $2 k _ { p } \Delta < k _ { \mathrm { r h } }$ and $2 k _ { p } \Delta > k _ { \mathrm { r h } }$ to

$$
\Omega _ { \mathrm { G W s } } ( k \ll k _ { p } , 2 k _ { p } \Delta < k _ { \mathrm { r h } } ) \propto \mathcal { A } _ { \mathcal { R } } ^ { 2 } \left\{ \begin{array} { l l } { \left( \frac { k } { k _ { p } } \right) ^ { 3 } } & { k \ll 2 k _ { p } \Delta \ll k _ { \mathrm { r h } } } \\ { \left( \frac { k } { k _ { p } } \right) ^ { 2 } } & { 2 k _ { p } \Delta \ll k \ll k _ { \mathrm { r h } } } \\ { \left( \frac { k } { k _ { p } } \right) ^ { 2 - 2 | b | } } & { k \ll 2 k _ { p } \Delta \ll k _ { p } } \end{array} \right. ,
$$

or

$$
\Omega _ { \mathrm { G W s } } ( k \ll k _ { p } , 2 k _ { p } \Delta > k _ { \mathrm { r h } } ) \propto \mathcal { A } _ { \mathcal { R } } ^ { 2 } \left\{ \begin{array} { l l } { \left( \frac { k } { k _ { p } } \right) ^ { 3 } } & { k \ll k _ { \mathrm { r h } } } \\ { \left( \frac { k } { k _ { p } } \right) ^ { 3 - 2 | b | } } & { k _ { \mathrm { r h } } \ll k \ll 2 k _ { p } \Delta } \\ { \left( \frac { k } { k _ { p } } \right) ^ { 2 - 2 | b | } } & { 2 k _ { p } \Delta \ll k \ll k _ { p } } \end{array} \right. .
$$

Note that since $k _ { \mathrm { r h } } / k _ { p } \ll 1$ the case $2 k _ { p } \Delta > k _ { \mathrm { r h } }$ still allows for a very sharp peak with $k _ { \mathrm { r h } } / ( 2 k _ { p } ) <$ $\Delta \ll 1$ . See how the inclusion of the finite width increases the richness of the induced GWs spectrum. We illustrate this in Fig 5. Also note that if $b = 0$ then the induced GW spectrum only has two different slopes and $k _ { \mathrm { r h } }$ becomes meaningless.

Before ending this subsection, we briefly discuss the case when $\Delta > 1$ . It is shown in Ref. [82] that in the induced GW spectrum in radiation domination for $\Delta > 1$ and near $k \sim k _ { p }$ is well approximated by

$$
\Omega _ { \mathrm { G W s } } ^ { \mathrm { p e a k } } ( \Delta > 1 ) \approx 0 . 1 2 5 \frac { { \cal A } _ { \mathcal { R } } ^ { 2 } } { \Delta ^ { 2 } } e ^ { - \frac { \ln ^ { 2 } ( k / k _ { p } ) } { \Delta ^ { 2 } } } .
$$

This means that the GW spectrum induced by a log-normal peak in the primordial spectrum also follows a log-normal peak but with a shallower width given by $\Delta / \sqrt { 2 }$ . The factor 2 is a reflection of the secondary nature of induced GWs [82].

# 5.4 Broken power-law

In Sec. 5.3 we have studied the log-normal sharp peak which is inspired in multi-field models of inflation. However, if the curvature perturbation is enhanced during single field inflation it often takes a broken power-law shape [103, 109, 234, 256]. The induced GWs counterpart for a broken power-law primordial spectrum have been studied in Refs. [80,81,105,141,220]. Here we present the results of Ref. [81], which contain analytical approximations for the amplitude and spectral tilt of both the IR and UV tails of the induced GW spectrum. A detailed discussion on the approximations used can be found in [81]. At the end of this subsection, we also briefly discuss the case of a scale invariant primordial spectrum.

![](images/388cda06cef85897cc9958189f35d227fc4374cf292742f4a6193072c25cfd34.jpg)  
Figure 5: Induced GW spectral density for the log-normal primordial spectrum. We used $c _ { s } ^ { 2 } = 1$ , so there is no resonant peak. We also chose $b = 3 / 2$ ( $w = - 1 / 1 5$ ) to show that for $b < 1$ the largest peak of the induced GW spectrum for a Dirac delta is at $k \sim k _ { \mathrm { r h } }$ . In purple we show $\Delta = 1 0 ^ { - 5 }$ which for the range of $k$ shown in the plot is effectively the induced GW spectrum of a Dirac delta. For $k < k _ { \mathrm { r h } }$ the GW spectrum goes as $k ^ { 2 }$ . In red we show $\Delta = 1 0 ^ { - 3 }$ so that the effects of the finite width occur within the plot range. Around $k / k _ { p } \sim 5 \times 1 0 ^ { - 2 }$ the GW spectrum goes from $k ^ { 2 }$ to $k ^ { 3 }$ . Lastly, we show in orange $\Delta = 1 0 ^ { - 1 }$ . The finite width becomes important now for $k _ { \mathrm { r h } } < k < k _ { p }$ and the GW spectrum transition from $k ^ { 2 - 2 b } = k ^ { - 1 }$ to $k ^ { 3 - 2 b } = k ^ { 0 }$ .

Let us parametrize the primordial curvature power spectrum as a strict broken power-law given by

$$
\mathcal { P } _ { \mathcal { R } } = \mathcal { A } _ { \mathcal { R } } \left\{ \begin{array} { l l } { \left( \displaystyle \frac { k } { k _ { p } } \right) ^ { n _ { \mathrm { I R } } } } & { \quad k \leq k _ { p } } \\ { \left( \displaystyle \frac { k } { k _ { p } } \right) ^ { - n _ { \mathrm { U V } } } } & { \quad k \geq k _ { p } } \end{array} \right. ,
$$

where $n _ { \mathrm { I R } }$ , $n _ { \mathrm { U V } } > 0$ respectively are the IR and UV spectral tilts of the spectrum which peaks at $k = k _ { p }$ . In single field models one often finds that $n _ { \mathrm { I R } } \sim 4$ [103]. If the enhancement of the curvature fluctuations is due to a bump in the inflationary potential, then $n _ { \mathrm { U V } }$ can be related to the second derivative of the potential at the bump [80, 256]. In such models $n _ { \mathrm { U V } }$ is also related to the local non-gaussianity parameter $f _ { N L }$ [256]. In what follows, we will only focus on induced GWs in the radiation dominated universe and later discuss its generalisations to other values of the equation of state parameter. Currently, only analytical approximations for radiation domination are available. Now, using (4.22) and (5.15) we can compute the associated induced GW spectrum. Doing so for the IR tail, i.e., for modes with $k \ll k _ { p }$ , we find that

$$
\Omega _ { \mathrm { G W , r h } } ( k \ll k _ { p } ) \approx 1 2 \varLambda _ { \mathcal { R } } ^ { 2 } \left( \frac { 1 } { 2 n _ { \mathrm { I R } } - 3 } + \frac { 1 } { 2 n _ { \mathrm { U V } } + 3 } \right) \left( \frac { k } { k _ { p } } \right) ^ { 3 } \ln ^ { 2 } \left( \frac { k } { k _ { p } } \right) .
$$

Eq. (5.16) is valid for $n _ { \mathrm { I R } } > 3 / 2$ and $n _ { \mathrm { U V } } > 0$ and gives a good approximation of the IR tail. The condition $n _ { \mathrm { { I R } } } > 3 / 2$ comes from requiring convergence of the integral at large internal momenta ( $u \sim v \gg 1$ ).

The UV tail of the induced GW spectrum presents two different behaviours. If $0 < n _ { \mathrm { U V } } < 4$ the integral converges even in the strict limit $v  0$ . This means that we can pull out of the integral

(4.22) all the $k$ dependence in $\mathcal { P } _ { \mathcal { R } }$ and have that $\Omega _ { \mathrm { G W , r h } } \sim \mathcal { P } _ { \mathcal { R } } ^ { 2 }$ . The remaining piece is just a numerical factor. In this way, we find that the induced GW spectrum in the UV reads

$$
\Omega _ { \mathrm { G W , r h } } ( k \gg k _ { p } , n _ { \mathrm { U V } } < 4 ) \approx \frac { 1 } { 1 2 } { \cal A } _ { \mathcal { R } } ^ { 2 } F ( n _ { \mathrm { U V } } ) \left( \frac { k } { k _ { p } } \right) ^ { - 2 n _ { \mathrm { U V } } } ,
$$

where $F ( n _ { \mathrm { U V } } )$ , for $0 < n _ { \mathrm { U V } } < 4$ , is given by

$$
F ( n _ { \mathrm { U V } } ) = 8 \int _ { 0 } ^ { \infty } { d v } \int _ { | 1 - v | } ^ { 1 + v } { d u } \left( \frac { 4 v ^ { 2 } - ( 1 - u ^ { 2 } + v ^ { 2 } ) ^ { 2 } } { 4 u v } \right) ^ { 2 } ( u v ) ^ { n _ { \mathrm { U V } } } \overline { { I ^ { 2 } ( n _ { \mathrm { U V } } , k , v , u ) } } ,
$$

and converges everywhere. The range of $n _ { \mathrm { U V } }$ for which this approximation is valid depends on the value of $b$ . We discuss this after presenting the results for radiation domination ( $b = 0$ ). Since (5.18) has to be computed numerically, we present here a numerical fit for $n _ { \mathrm { U V } } < 4$ , which reads

$$
F ( n _ { \mathrm { U V } } ) \approx 4 1 + \frac { 1 6 n _ { \mathrm { U V } } ^ { 2 } } { \sqrt { 1 6 - n _ { \mathrm { U V } } ^ { 2 } } } .
$$

The form of (5.19) has been found noting that the integral diverges in the exact limit $n _ { \mathrm { U V } }  4$ . After several trial and error attempts, a reasonable fit was found to be (5.19). A detailed study of (5.18) might yield better analytical insights than (5.19). For the moment Eq. (5.19) gives a good order of magnitude estimate. Note that when $n _ { \mathrm { U V } } = 4$ the induced GW spectrum present a logarithmic divergence [80,81]. Lastly, for $n _ { \mathrm { U V } } > 4$ the primordial spectrum has a sharp decay and, in analogy with the sharp peak, we do not expect that $\Omega _ { \mathrm { G W , r h } } \sim \mathcal { P } _ { \mathcal { R } } ^ { 2 }$ . Instead, there should be a fast fall off at around $k \sim 2 k _ { p }$ by momentum conservation. Indeed when $n _ { \mathrm { U V } } > 4$ we find that

$$
\Omega _ { \mathrm { G W , r h } } ( k \gg k _ { p } , n _ { \mathrm { U V } } > 4 ) \approx \frac { 1 6 } { 3 } { \cal A } _ { \mathcal { R } } ^ { 2 } \left( \frac { 1 } { n _ { \mathrm { U V } } - 4 } + \frac { 1 } { n _ { \mathrm { I R } } + 4 } \right) \left( \frac { k } { k _ { p } } \right) ^ { - 4 - n _ { \mathrm { U V } } } .
$$

We show the analytical estimates against the numerical results in Fig. 6. See how even if the approximations are extrapolated to $k \sim k _ { p }$ they still yield a sensible order of magnitude estimate of the induced GW spectrum.

With the above analytical estimates for the amplitude and the spectral tilt in the IR and UV limits we conclude that the induced GW spectrum has the following broken power-law shape

$$
\Omega _ { \mathrm { G W s } } ( k ) \propto { \mathcal A } _ { \mathcal R } ^ { 2 } \left\{ \begin{array} { l l } { \left( \frac { k } { k _ { p } } \right) ^ { 3 } } & { k \ll k _ { p } } \\ { \left( \frac { k } { k _ { p } } \right) ^ { - \Delta } } & { k \gg k _ { p } } \end{array} \right. , \quad \mathrm { w i t h } \quad \Delta = \left\{ \begin{array} { l l } { 2 n _ { \mathrm { U V } } } & { 0 < n _ { \mathrm { U V } } < 4 } \\ { 4 + n _ { \mathrm { U V } } } & { n _ { \mathrm { U V } } > 4 } \end{array} \right. .
$$

Eq. (5.21) tells us that the UV spectral tilt of the induced GW has information the UV tail of the primordial power spectrum. This is to be contrasted with the IR spectral tilt, which does not tell us much about the inflationary model unless we measure very well the amplitude. Lastly, if we focus on the UV tail of the induced GW spectrum (5.21), we see that for example it may be degenerate with the GW spectrum from the sound waves in a first order phase transition [172].

![](images/d33df3309a6c7816ec8ae0e8ec9c761e0bf84657d39f50d854671b8368bf7cf2.jpg)  
Figure 6: Induced GW spectral density for a broken power-law primordial spectrum with $n _ { \mathrm { I R } } ~ = ~ 4$ and $n _ { \mathrm { U V } } = \mathrm { : 2 }$ . In orange we show the result of numerical integration. In red we show the IR approximation (5.16). In purple we show the UV approximation (5.17). See how the analytical estimates fit well the numerical integration for $k \ll k _ { p }$ and $k \gg k _ { p }$ . They even give a good order of magnitude estimate of the amplitude of the GW spectrum around $k \sim k _ { p }$ .

# 5.4.1 Alternative expansion histories

Here we briefly present the spectral tilts of the induced GW spectrum if instead of radiation the universe was dominated by another perfect fluid. In this case, we find that (5.21) changes to [81]

$$
\Omega _ { \mathrm { G W } } ( k ) \propto \mathcal { A } _ { \mathcal { R } } ^ { 2 } \left\{ \begin{array} { c c } { \left( \frac { k } { k _ { p } } \right) ^ { 3 } } & { k \ll k _ { \mathrm { r h } } } \\ { \left( \frac { k } { k _ { p } } \right) ^ { 3 - 2 | b | } } & { k _ { \mathrm { r h } } \ll k \ll k _ { p } \ , } \\ { \left( \frac { k } { k _ { p } } \right) ^ { - \Delta - 2 b } } & { k \gg k _ { p } } \end{array} \right.
$$

where $b$ is defined in Eq. (2.16) and this time

$$
\Delta = \left\{ \begin{array} { l l } { 2 n _ { \mathrm { U V } } \quad } & { 0 < n _ { \mathrm { U V } } + b < 4 } \\ { 4 + n _ { \mathrm { U V } } \quad } & { n _ { \mathrm { U V } } + b > 4 } \end{array} \right. .
$$

Previously, in Secs. 2.2 and 4, we derived the IR broken power-law behaviour of the induced GW spectrum for general equation of state parameter. Now, in this section we have a power-law UV tail in the induced GW coming from the UV tail of the primordial spectrum. The additional factor $- 2 b$ with respect to (5.21) in the UV tail can be understood as follows. All modes with $k \gg k _ { p }$ entered the horizon deep inside the $b =$ constant era and before the scalar peak at $k \sim k _ { p }$ . After that the induced tensor modes effectively behave as free GWs irrespective of whether $b < 0$ or $b > 0$ . Thus, the free GWs experience the typical relative redshift with respect to the background which is the factor $k ^ { - 2 b }$ . Note that if $b < 0$ the UV tail might have a blue tilt.

# 5.4.2 Scale invariant spectrum

A limiting case of the broken power-law studied (5.15), setting $n _ { \mathrm { U V } } = n _ { \mathrm { I R } } = 0$ , is a scale invariant spectrum typical of slow-roll inflation. In this case, it is easy to convince ourselves that the induced GW spectrum for general expansion histories is given by

$$
\Omega _ { \mathrm { G W , r h } } = \boldsymbol { \mathcal { A } } _ { \mathcal { R } } ^ { 2 } \mathcal { F } ( \boldsymbol { b } , \boldsymbol { c } _ { s } ) \left( \frac { k } { k _ { \mathrm { r h } } } \right) ^ { - 2 \boldsymbol { b } } .
$$

where

$$
\mathcal { F } ( b , c _ { s } ) = \frac { 2 } { 3 } \int _ { 0 } ^ { \infty } d v \int _ { | 1 - v | } ^ { 1 + v } d u \left( \frac { 4 v ^ { 2 } - ( 1 - u ^ { 2 } + v ^ { 2 } ) ^ { 2 } } { 4 u v } \right) ^ { 2 } \overline { { { I ^ { 2 } ( b , c _ { s } , k , v , u ) } } } ,
$$

and $\overline { { I ^ { 2 } } }$ is given by (4.14). Another explicit formula can be found at the summary section 10. The integral (5.25) converges everywhere for any value of $b$ and $c _ { s }$ . However, note that (5.25) with (4.14) is only valid for $k \gg k _ { \mathrm { r h } }$ . Nevertheless, since deep inside the radiation domination we expect a scale invariant induced GW spectrum it is reasonable to assume that for scales $k \sim k _ { \mathrm { r h } }$ we can match the $k ^ { - 2 b }$ behaviour to the constant spectral density. A more detailed, perhaps numerical, analysis is needed to determine the spectrum for $k \sim k _ { \mathrm { r h } }$ as induced GWs are being sourced before and after the transition.

# 5.5 Oscillatory features

In the subsections above we have discussed the GWs induced by the simplest shapes of the primordial spectrum, that is a log-normal peak and a broken power-law. However, in some situations, it is expected that the primordial power spectrum presents a series of oscillations usually referred to as “primordial features”. For recent reviews on such features see, e.g., [257–259]. These oscillations can be classified according to the $k$ dependence in their frequency. If the frequency is linear in $k$ , the oscillations resulted from sharp dynamics during inflation. For example, a step in the potential in single field inflation [260–267] or a sharp turn in field space [84, 86, 254, 255, 268–270]. This case is also known as sharp feature. If the frequency is logarithmic in $k$ , the oscillations are called resonant features. They are due to resonances during inflation on subhorizon scales. For instance, resonances occurs if the potential in single field inflation has wiggles or a massive scalar field is oscillating at the bottom of the potential [87, 170, 271–277]. In more general cases, such as general interactions [278, 279] or alternative scenarios to inflation [280], the frequency of the oscillations in the primordial spectrum could be a power-law of $k$ .

Remarkably, despite the induced GWs being a second order effect, oscillations are not completely washed out. The main difficulty is to derive analytical approximations to the induced GW spectrum. In this respect, Fumagalli, Renaux-Petel and Witkowski [84, 87] and also Braglia, Chen and Hazra [86] did a detailed numerical analysis of the induced GW spectrum and derived motivated semi-analytical templates. Perhaps the most interesting case which is when the oscillations in the primordial spectrum are $O ( 1 )$ . For example, this is the case when a sharp feature is responsible for the peak in the primordial spectrum [84,255]. Now, if the oscillations are large and separated linearly in $k$ , we can gain intuition by looking at the sum of Dirac delta peaks [83, 84]. In this case if we call $\omega _ { \mathrm { l i n } }$ to the frequency of the Dirac delta peaks in the primordial spectrum, then the frequency in the induced GW spectrum is ωGWlin $\omega _ { \mathrm { l i n } } ^ { \mathrm { G W s } } = \omega _ { \mathrm { l i n } } / c _ { s }$ [83, 84] (in radiation domination $c _ { s } = 1 / \sqrt { 3 }$ ).

![](images/2c9607ef2695df85f51fe9ed755a3c11ef763d4b3576febee13fc81a2a64b216.jpg)  
Figure 7: Primordial spectrum and induced GWs from a sharp turn in the inflationary trajectory from the model of Ref. [84], courtesy of L. Witkowski, J. Fumagalli and S. Renaux-Petel. Left: Normalized primordial spectrum in terms of wavenumber $k / k _ { p }$ . The solid line is the power spectrum resulting from the sharp feature. The dashed line is the envelope of the oscillations. They are respectively given by Eqs. (2.25) and (2.26) of Ref. [84] with $\delta = 0 . 5$ and $\eta _ { \perp } = 2 0$ . Right: Induced GW spectral density normalized by $\mathcal { A } _ { \mathcal { R } }$ . The solid line is the induced GW spectrum of the oscillatory power spectrum while the dashed line is the induced GWs from the envelope properly normalised. The oscillations have an amplitude of about 20% larger than the envelope around the induced GW spectrum peak.

Interestingly, in the more realistic situation studied [84] the induced GW spectrum follows an envelope as if there were no oscillations and, on top of that, oscillations appear near the resonant peak at $k \sim 2 c _ { s } k _ { p }$ and reach at most an amplitude of about 20% in radiation domination [84]. We illustrate this possibility in Fig. 7. Another example are $O ( 1 )$ oscillations due to a resonant feature in the primordial spectrum. In this case, if we call $\omega _ { \mathrm { l o g } }$ the frequency of the resonant feature, the resulting induced GW spectrum exhibits two oscillatory components with frequencies $\omega _ { \mathrm { l o g } }$ and $2 \omega _ { \mathrm { l o g } }$ . The relative amplitude of such components depend on both the frequency and the envelope of the primordial spectrum [87]. For the analytical templates and a more detailed discussion see Refs. [84, 87].

# 5.6 Impact of non-Gaussianities

Here we briefly discuss the effects that primordial non-gaussianities may have on the induced GW spectrum. We will not dwell into the details, which are well explained in Refs. [89, 90, 92]. The leading formulas for local-type non-gaussianity can be found in Sec. 3.3. We describe the main effects of local-type non-gaussianity below.

First, let us focus on the very sharp peaks of sec. 5.2 and 5.3. In this case, the most relevant effect is that the induced GW spectrum does not stop at $k \sim 2 k _ { p }$ but continues until $k \sim 3 k _ { p }$ . This is roughly because when including primordial non-gaussianity, the source term to induced GWs has three scalars. Thus, we have a cut-off at $k \sim 3 k _ { p }$ by momentum conservation. Note that this effect is characteristic of the sharp peak in the primordial spectrum. For large non-gaussianity, that is $F _ { N L } \gg 1$ in Eq. (3.30), the spectrum does not have the clear resonant peak of 5.2 but presents a few peaks with similar amplitude instead [89, 92]. Second, in the case where the peak is broad or a broken power-law, the non-gaussian contribution typically has the same IR and UV spectral tilts [81, 92]. For large enough $F _ { N L } \gtrsim 1$ , the induced GW spectrum also shows an additional peak/bump at around $k \sim 3 k _ { p }$ . If the non-gaussianity is large enough, i.e., $\mathcal { A } _ { \mathcal { R } } F _ { N L } ^ { 2 } > O ( 1 )$ , the non-gaussian contribution starts to dominate over the gaussian one [89, 92]. However, it is not so clear whether one can achieve $\mathcal { A } _ { \mathcal { R } } F _ { N L } ^ { 2 } > 1$ in inflationary models as in this case the non-gaussian expression (3.30) cannot be regarded as a perturbative expansion [81]. A more detailed and general analysis is necessary. It should be noted that if we include third order perturbation theory terms, the induced GW spectrum for a Dirac delta peak has three resonant peaks instead of one [143,179].

The primordial non-gaussian contribution to the induced GW spectrum, as we have just presented it, might not yield much information on inflation. For example, one may design a gaussian primordial spectrum such that the resulting induced GW spectrum is exactly as that of a primordial log-normal peak with large non-gaussianities. Although this may be a very complicated task, it is in principle possible. In this sense, there is no telling primordial non-gaussianity apart just from the induced GW spectrum [179]. Nevertheless, the story becomes more interesting when considering the PBH counterpart. Since PBH formation is highly dependent on the tail of the distribution of primordial fluctuations, any tiny deviation from a normal distribution could have an exponential impact on the fraction of PBHs. For the details see the recent discussions in Refs. [217, 219–221, 256, 281–284]. Then, ideally one may use the two observations, the PBH mass function and the induced GW counterpart, to perhaps disentangle the primordial non-gaussianity from the primordial spectrum.

# 6 The dust dominated universe

In previous sections we have derived intuitive and analytical formulas for the spectrum of induced GWs under the assumption that the universe was not dominated by a pressure-less perfect fluid with vanishing propagation speed of fluctuations, i.e., $w = c _ { s } ^ { 2 } = 0$ , so-called dust. The particularity of a dust dominated universe is that the Newtonian potential is constant on all scales. As can be seen from Eq. (4.1) with $c _ { s } ^ { 2 } = 0$ , $\Phi =$ constant is a solution. This also implies that density fluctuations of the dust fluid grow. In fact, they grow as $\delta \rho / \rho \propto a$ . This is the typical behaviour of a CDM dominated universe. This also means that there is a scale below which density fluctuations grow so much that they become non-linear, i.e., larger than $O ( 1 )$ . This occurs for modes with [51]

$$
k > k _ { N L } \sim \sqrt { \frac { 3 } { 2 } } { \mathcal P } _ { \Phi } ^ { - 1 / 4 } ( \tau _ { \mathrm { r h } } ) { \mathcal H } ( \tau _ { \mathrm { r h } } ) .
$$

Note that it does not mean that if there are fluctuations on $k > k _ { N L }$ there will be no production of induced GWs. It means that we cannot completely trust our calculations since non-linear dynamics might be important, e.g., due to GWs from mergers. Nevertheless, we quite often have $\Phi < 1$ and thus perturbation theory for $\Phi$ is sensible.

In Sec. 6.1 we show and discuss the subtleties of the dust dominated universe and derive analytical estimates for the amplitude of induced GWs in the case of an instantaneous transition. We apply our results to PBH dominated epoch in Sec. 6.2 and use overproduction of induced GWs to place stringent constraints on the scenario.

$\pmb { \theta }$ Main references: Sec. 6.1 is based on Inomata et al. [65, 66] with the notation of Refs. [70, 71]. These works are built upon previous papers by Assadullahi and Wands [51] and Kohri and Terada [63]. Then, Sec. 6.2 follows the pioneering work by Papanikolau, Vennin and Langlois [69] further extended by [70] to account for the transition to radiation domination. Lastly, Ref. [68] contains useful details on the transition of the PBH dominated universe to radiation domination.

# 6.1 General dust domination

Let us now derive the kernels and some estimates for the induced GWs. First we note that the fact that $\Phi =$ constant in an early Matter Dominated (eMD) era seemingly makes naive calculations of induced GWs easier. Just take a transfer function equal to unity in (3.20), which yields

$$
f ( \tau , q , | { \bf k - q } | ) = \frac { 5 } { 3 } ,
$$

where we took $b = 1$ ( $w = 0$ ). Now we have to simply integrate (3.27) with a constant source. In the limit where $x \gg 1$ , we have that the averaged kernel squared is just a constant [51, 63]. In our notation we have

$$
\overline { { I _ { e M D } ^ { 2 } ( x \gg 1 , q , | \mathbf { k } - \mathbf { q } | ) } } \approx \left( \frac { 2 0 } { 3 } \right) ^ { 2 } .
$$

We can then use (3.25) to give a naive estimation of the induced GW during the early matter era. However, this is far from being a complete picture. As first realised by Inomata, Kohri, Nakama and Terada, induced GWs from a dust dominated are more subtle and depend on the nature of the transition to radiation domination [65, 66]. If the transition is gradual, the induced GW spectrum is actually suppressed [65]. The suppression can be understood from the fact that the initial enhancement in the dust dominated universe found in Ref. [51] is due to the constant $\Phi$ . If $\Phi$ decays, the enhancement is not as efficient. Instead, if the transition from dust to radiation is instantaneous, the induced GW spectrum get very much amplified [66]. We will shortly explain the source of the amplification. Let us first note that the reason why we did not find such behaviour in Sec. 4 comes down to the particular behaviour of $\Phi$ in dust domination. In Sec. 4, due to the fact that we assumed $c _ { s } ^ { 2 } \neq 0$ , the general solution to $\Phi$ in a $w =$ constant universe is a decaying and oscillating function. After the transition to radiation domination, $\Phi$ is also decaying and oscillating, albeit with different frequency. Thus, the matching between the two periods is well described within the WKB approximation. In this case, only those scales close to $k \sim k _ { \mathrm { r h } }$ might receive at most a $O ( 1 )$ correction.

What is special about the instantaneous reheating in the dust dominated universe is that we are suddenly going from $\Phi ^ { \prime } = 0$ to $\Phi ^ { \prime } \ne 0$ . Since $\Phi$ did not have time to decay and the frequency of the oscillations is proportional to the ratio of the largest wavenumbers $k$ with the reheating scale $k _ { \mathrm { r h } }$ , the amplitude of $\Phi ^ { \prime }$ right after the sudden reheating will be huge. A more physical picture was presented in Ref. [66] and it goes as follows. Density fluctuations grow as $\delta \rho / \rho \propto a$ and attain a “large” amplitude by the end of the dust dominated era. These large fluctuations suddenly evaporate and are converted into fluctuations in a radiation fluid, which create strong pressure waves. These waves generate spacetime oscillations and are the source to induced GWs.

Let us explicitly show that $\Phi ^ { \prime }$ becomes very large right after reheating. To do that, we first consider that $\Phi$ has an arbitrary amplitude during the eMD of $\Phi = \Phi _ { e M D } ( k )$ . Then, the eMD ends abruptly and we enter a late Radiation Domination (lRD). Matching the general solution (4.4) and its first derivative for $b = 1$ and $b = 0$ we arrive at

$$
\Phi _ { l R D } = ( c _ { s } k \bar { \tau } ) ^ { - 3 / 2 } \left( C _ { 1 } J _ { 3 / 2 } ( c _ { s } k \bar { \tau } ) + C _ { 2 } Y _ { 3 / 2 } ( c _ { s } k \bar { \tau } ) \right) ,
$$

where $c _ { s } = 1 / \sqrt { 3 }$ since we are in a radiation dominated universe, $\tau$ is defined in (4.15) and comes from requiring continuity of $a$ and $\mathcal { H }$ and we defined

$$
\begin{array} { l } { { \displaystyle C _ { 1 } = - \Phi _ { \mathrm { e M D } } \frac { \pi } { 2 } \left( \frac { c _ { s } k \bar { \tau } _ { \mathrm { r h } } } { 2 } \right) ^ { 5 / 2 } Y _ { 5 / 2 } \left( \frac { c _ { s } k \bar { \tau } _ { \mathrm { r h } } } { 2 } \right) , } } \\ { { \displaystyle C _ { 2 } = \Phi _ { \mathrm { e M D } } \frac { \pi } { 2 } \left( \frac { c _ { s } k \bar { \tau } _ { \mathrm { r h } } } { 2 } \right) ^ { 5 / 2 } J _ { 5 / 2 } \left( \frac { c _ { s } k \bar { \tau } _ { \mathrm { r h } } } { 2 } \right) . } } \end{array}
$$

If we now compute the variation of $\Phi _ { \mathrm { l R D } }$ per Hubble time we find that the leading contribution for $x > x _ { \mathrm { r h } } \gg 1$ is given by

$$
\frac { d \Phi _ { \mathrm { l R D } } } { d \ln \bar { x } } \approx - \Phi _ { \mathrm { e M D } } \frac { c _ { s } \bar { x } _ { \mathrm { r h } } ^ { 2 } } { \bar { x } } \sin \left( c _ { s } ( \bar { x } - \bar { x } _ { \mathrm { r h } } ) \right) .
$$

Thus, we see that the amplitude of the time derivative is roughly

$$
\frac { d \Phi _ { l R D } } { d \ln \bar { x } } \propto \left( \frac { k } { k _ { \mathrm { r h } } } \right) ^ { 2 } .
$$

This means that if there are fluctuations on scales $k \gg k _ { \mathrm { r h } }$ the amplitude of $\Phi _ { \mathrm { { l R D } } } ^ { \prime }$ is very large and so it will produce induced GWs with a large amplitude.

Let us move on to the GWs induced after the sudden transition. For simplicity, we only focus on the largest contribution to the source (3.20), which comes from the time derivatives and reads

$$
f ( \tau , q , | { \bf k } - { \bf q } | ) \approx \frac { 1 } { 2 } \frac { d T _ { \Phi } ( q \tau ) } { d \ln \tau } \frac { d T _ { \Phi } ( | { \bf k } - { \bf q } | \tau ) } { d \ln \tau } .
$$

Inserting Eqs. (6.9) and (6.7) into (3.27) we arrive at the kernel during the lRD, namely

$$
I _ { l R D } ( \bar { x } , u , v ) \approx \Phi _ { \mathrm { e M D } } ^ { 2 } \frac { c _ { s } ^ { 2 } \bar { x } _ { \mathrm { r h } } ^ { 4 } } { 2 \bar { x } } u v \int _ { \bar { x } _ { \mathrm { r h } } } ^ { \bar { x } } d \tilde { \bar { x } } \frac { \sin ( \bar { x } - \tilde { \bar { x } } ) } { \tilde { x } } \sin \left( c _ { s } v ( \tilde { \bar { x } } - \bar { x } _ { \mathrm { r h } } ) \right) \sin \left( c _ { s } u ( \tilde { \bar { x } } - \bar { x } _ { \mathrm { r h } } ) \right) .
$$

The integral in (6.10) may be done analytically in terms of sine and cosine integrals but it is not so illuminating. The interested reader is referred to Ref. [66]. Using our experience of Sec. 4, we know that the integral often diverges when $c _ { s } ( u + v ) \sim 1$ . Thus, within our order of magnitude estimates, we shall focus solely on the neighbourhood of the resonance. In this case, the divergent piece is the cosine integral Ci $\lfloor x \rfloor$ and the kernel is approximately given by

$$
I _ { l R D , \mathrm { r e s } } ( \bar { x } , u , v ) \approx \Phi _ { \mathrm { e M D } } ^ { 2 } \frac { c _ { s } ^ { 2 } \bar { x } _ { \mathrm { r h } } ^ { 4 } } { 8 \bar { x } } { u v } \mathrm { C i } \left[ | 1 - c _ { s } ( u + v ) | \bar { x } _ { \mathrm { r h } } \right] \sin \bar { x } .
$$

The calculation of the averaged kernel squared is straightforward and yields

$$
\overline { { I _ { l R D , \mathrm { r e s } } ^ { 2 } ( \bar { x } , u , v ) } } \approx \Phi _ { \mathrm { e M D } } ^ { 4 } \frac { c _ { s } ^ { 4 } \bar { x } _ { \mathrm { r h } } ^ { 8 } } { 1 2 8 \bar { x } ^ { 2 } } u ^ { 2 } v ^ { 2 } \mathrm { C i } ^ { 2 } \left[ | 1 - c _ { s } ( u + v ) | \bar { x } _ { \mathrm { r h } } \right] .
$$

For other approximations regarding the IR tail, such as the large momentum contribution $u \sim v \gg 1$ , we refer the reader to Refs. [66, 68].

With the analytic approximation for the kernel (6.12) we shall turn our attention to the dominant contribution to the tensor spectrum (3.25). For clarity, let us explicitly insert (6.12) into (3.25) to obtain the resonant part of the tensor spectrum, which leads us

$$
\begin{array} { r } { \overline { { \mathcal { P } } } _ { h } ^ { \mathrm { r e s } } \approx \frac { c _ { s } ^ { 4 } \overline { { x } } _ { \mathrm { r h } } ^ { 8 } } { 1 6 \overline { { x } } ^ { 2 } } \int _ { 0 } ^ { \infty } d v \int _ { | 1 - v | } ^ { 1 + v } d u \left( \frac { 4 v ^ { 2 } - ( 1 - u ^ { 2 } + v ^ { 2 } ) ^ { 2 } } { 4 u v } \right) ^ { 2 } \mathcal { P } _ { \Phi } ( k u ) \mathcal { P } _ { \Phi } ( k v ) } \\ { \times u ^ { 2 } v ^ { 2 } \mathrm { C i } ^ { 2 } \left[ | 1 - c _ { s } ( u + v ) | \bar { x } _ { \mathrm { r h } } \right] . \qquad } \end{array}
$$

Before carrying out the integral, let us analyse some of the assumptions. First, we are assuming that (6.13) yields the dominant contribution. This will be the case if there is integration support for large $k$ . This means that ${ \mathcal { P } } _ { \Phi } ( k )$ should peak at large $k$ . We also argued that there might be a limit to the magnitude of $k$ due to non-linearities given by (6.1). We should use such limit if there are no stronger motivations to consider $k > k _ { N L }$ . However, as we shall see, if PBH dominate the universe, there must be fluctuations above $k _ { N L }$ [69]. For these reasons, let us parametrize the scalar power spectrum as power-law with a UV cut-off $k _ { U V }$ given by [71]

$$
\mathcal { P } _ { \Phi } = \mathcal { A } _ { \Phi } \left( \frac { k } { k _ { \mathrm { U V } } } \right) ^ { - n } \Theta ( k _ { U V } - k ) ,
$$

where $\mathcal { A } _ { \Phi }$ is the amplitude and $n$ the spectral tilt. Looking at (6.13) we see that the integrand peaks at large $k$ if $n < 2$ . This includes an almost scale invariant spectrum ( $n \sim 0$ ) and the PBH density fluctuations $( n \sim 1 )$ [69, 70].

With these assumptions we shall proceed to perform the integral in (6.13). We shall use the fact that $\operatorname { C i } [ z ]$ is divergent for $z \sim 0$ to evaluate the integrand at the resonant point except for $\operatorname { C i } [ z ]$ . For simplicity, let us switch integration variables to

$$
z \equiv \big ( 1 - c _ { s } ( u + v ) \big ) \bar { x } _ { \mathrm { r h } } \quad \mathrm { a n d } \quad s \equiv u - v ,
$$

which have a Jacobian given by $| J | = 1 / ( 2 c _ { s } \bar { x } _ { \mathrm { r h } } )$ . Replacing $( u , v )$ for $( z , s )$ in (6.13), evaluating integrand at $z = 0$ except for $\mathrm { C i } [ z ]$ and maintaining the $s$ dependence we arrive at

$$
\overline { { \mathcal { P } _ { h } ^ { \mathrm { r e s } } } } \approx \frac { \pi \bar { x } _ { \mathrm { r h } } ^ { 7 } } { 5 1 2 c _ { s } \bar { x } ^ { 2 } } \left( 1 - c _ { s } ^ { 2 } \right) ^ { 2 } \int _ { - s _ { 0 } ( k ) } ^ { s _ { 0 } ( k ) } d s ( 1 - s ^ { 2 } ) ^ { 2 } \mathcal { P } _ { \Phi } \left( k \frac { 1 + c _ { s } s } { 2 c _ { s } } \right) \mathcal { P } _ { \Phi } \left( k \frac { 1 - c _ { s } s } { 2 c _ { s } } \right) ,
$$

where we already integrated the cosine integral around the divergence $^ { 1 7 }$ and we have defined [66]

$$
\begin{array} { r } { s _ { 0 } ( k ) = \left\{ \begin{array} { l l } { 1 \qquad } & { k _ { U V } / k \ge \frac { 1 + c _ { s } ^ { - 1 } } { 2 } } \\ { 2 \frac { k _ { U V } } { k } - c _ { s } ^ { - 1 } \qquad } & { \frac { 1 + c _ { s } ^ { - 1 } } { 2 } \ge \frac { k _ { U V } } { k } \ge \frac { c _ { s } ^ { - 1 } } { 2 } } \\ { 0 \qquad } & { \frac { c _ { s } ^ { - 1 } } { 2 } \ge \frac { k _ { U V } } { k } } \end{array} \right. . } \end{array}
$$

These bounds on $s$ come from momentum conservation, i.e., $| 1 - v | < u < 1 + v$ , evaluated at the resonant point $z = 0$ . To have an order of magnitude estimate of the amplitude of the peak of the induced GW spectrum, we can evaluate (6.16) at $s = 0$ . By doing so, the amplitude of the induced GW spectrum at $k \sim k _ { \mathrm { U V } }$ due to the sudden reheating is roughly given by

$$
\Omega _ { \mathrm { G W s } } ^ { \mathrm { p e a k } } \approx \frac { \pi } { 3 \times 2 ^ { 1 2 } c _ { s } } \left( 1 - c _ { s } ^ { 2 } \right) ^ { 2 } \left( 4 c _ { s } ^ { 2 } \right) ^ { n } \left( \frac { k _ { \mathrm { U V } } } { k _ { \mathrm { r h } } } \right) ^ { 7 } \mathcal { A } _ { \Phi } ^ { 2 } ,
$$

where we used that $\bar { x } _ { \mathrm { r h } } = k \tau _ { \mathrm { r h } } / 2 = k / k _ { \mathrm { r h } }$ and we used that the numerical evaluation of the integral in $s$ roughly yields an extra factor $1 / 2$ [70]. Let us remind the reader that $c _ { s } = 1 / \sqrt { 3 }$ since we are in radiation domination. From (6.18) we see how if $k _ { \mathrm { U V } } \gg k _ { \mathrm { r h } }$ the amplitude of the induced GWs is tremendously large by a power of 7. Thus, not to backreact, we either need $\mathcal { A } _ { \Phi }$ to be extremely small or we restrict the value of $k _ { \mathrm { U V } }$ not to be too large. Now, knowing the amplitude of the peak (6.18) we can approximate the induced GW spectrum by

$$
\Omega _ { \mathrm { G W s , r h } } ( k \sim k _ { \mathrm { U V } } ) \approx \Omega _ { \mathrm { G W s } } ^ { \mathrm { p e a k } } \left( \frac { k } { k _ { \mathrm { U V } } } \right) ^ { 7 - 2 n } \Theta ( k _ { \mathrm { U V } } - k ) ,
$$

where we used that although the cut-off in the induced GWs is at $k = 2 k _ { \mathrm { U V } }$ the decay after $k \sim k _ { \mathrm { U V } }$ is so fast that we can safely neglect it.

The resonant peak is not the only contribution after the sudden reheating induced GWs. There is also the IR tail which corresponds to the $u \sim v \gg 1$ region of integration. Nevertheless, this contribution is always suppressed by a factor $k _ { \mathrm { r h } } / k _ { \mathrm { U V } }$ . The interested reader can find the corresponding formulas in Refs. [66, 68]. In addition to that, there is the contribution of the GWs induced during eMD, i.e., using the kernel (6.3) into (3.25). In the case of the sudden transition, we can take the amplitude of the induced GWs as initial conditions for the subsequent radiation domination era. Then the total spectrum is well approximated by the sum of the two contributions [66]. This contribution will be small compared to the resonant part (6.19) but since it may present a large plateau $\left\lfloor 5 1 , 6 6 , 6 9 \right\rfloor$ it may dominate on the very low frequency band. The case of the gradual transition requires a more careful treatment which can be found in Ref. [65]. We shall proceed with a very interesting application of (6.19).

# 6.2 PBH dominated era

An early matter dominated period could have been due to PBHs. Once formed, PBHs basically behave like a dust fluid, i.e., a fluid with no pressure and no propagation speed of fluctuations, like non-relativistic matter. Furthermore, their energy density practically redshifts as that of nonrelativistic matter. You can see this from the following. Since the number density of PBH, $n _ { \mathrm { P B H } }$ , is conserved (unless they substantially merge or evaporate) we have that $n _ { \mathrm { P B H } } ~ \propto ~ a ^ { - 3 }$ . The total energy density contained in these PBHs is $\rho _ { \mathrm { P B H } } = M _ { \mathrm { P B H } } n _ { \mathrm { P B H } }$ . Then in periods where PBH evaporation is negligible we have that $\rho _ { \mathrm { P B H } } \propto a ^ { - 3 }$ . For concreteness, let us assume that PBH formed in a radiation dominated era, with an initial fraction of PBH given by

$$
\beta \equiv \frac { \rho _ { \mathrm { P B H } , i } } { \rho _ { r , i } } \approx \frac { \rho _ { \mathrm { P B H } , i } } { 3 H _ { i } ^ { 2 } M _ { \mathrm { p l } } ^ { 2 } } ,
$$

where in the last step we used the first Friedmann equation (E.1). If $\beta$ is large enough, then PBH will eventually dominate the universe since we have that $\rho _ { r } \propto a ^ { - 4 }$ . Now, for simplicity, let us assume that these PBHs formed by the collapse of large primordial fluctuations with a very peaked primordial spectrum at a scale $k _ { p }$ . This has two implications. First, the PBH mass function is almost monochromatic. Then, we can use Eq. (2.30) to estimate the peak mass in terms of the peak scale $k _ { p }$ by using that $H _ { i } \equiv k _ { p } / a _ { i }$ . We refer the reader to Sec. 2.3 for more details. Second, the initial fraction of PBH $\beta$ is determined by the amplitude of the primordial spectrum. In this section, we take for convenience $M _ { \mathrm { P B H } }$ and $\beta$ as the free parameters of the model. One can then relate the scale and the amplitude of the primordial spectrum to $M _ { \mathrm { P B H } }$ and $\beta$ , if necessary. Interestingly, in this situation the PBH evaporation occurs almost instantaneously [68] and, therefore, we can use the estimates we derived in Sec. 10.2 with some corrections that we describe below. It should be noted that the results we will derive here only apply to a sharply peaked PBH mass function. If we considered an extended PBH mass function, induced GWs would be very much suppressed [68].

A remarkable fact is that, as first realised by Papanikolaou, Vennin and Langlois [69], due to the inhomogeneous distribution, PBH themselves create density fluctuations which might later source induced GWs. To see this, note that PBH formation by the collapse of large fluctuations is a rare event [174] and so each PBH form uncorrelated of the others. Also, clustering is often negligible. This means that, as a good approximation PBHs will be randomly distributed uniformly in space. In other words, PBHs are distributed according to Poisson statistics. Such Poisson statistics are dictated by the mean inter-PBH comoving separation. If PBH follow a monochromatic mass function, the mean inter-PBH comoving separation at formation is given by

$$
d _ { i } = \left( \frac { 3 } { 4 \pi n _ { \mathrm { P B H } , i } } \right) ^ { 1 / 3 } \equiv k _ { \mathrm { U V } } ^ { - 1 } .
$$

Note that in Eq. (6.21) we identify the comoving inter-PBH separation as the UV cut-off in Eq. (6.14). This is because the fluid description of the PBH gas is valid only for $k < k _ { \mathrm { U V } }$ , i.e., at distances much larger than $d _ { i }$ . In this coarse grained regime the initial dimensionless power spectrum of PBH density fluctuations reads [69]

$$
\mathcal { P } _ { \delta , \mathrm { P B H } } = \frac { 2 } { 3 \pi } \left( \frac { k } { k _ { \mathrm { U V } } } \right) ^ { 3 } \Theta ( k _ { \mathrm { U V } } - k ) .
$$

We have showed with Eq. (6.22) that PBHs give rise to density fluctuations. However, in the current model, PBHs form in an early Radiation Dominated stage (eRD) and, therefore, such density fluctuations correspond to isocurvature fluctuations (for the definition see footnote 15). Thus, they do not source induced GWs yet. Induced GWs are mainly generated by curvature fluctuations. If one is interested in the latter aspect, the general source term in a two fluid system can be found in Ref. [70]. The isocurvature nature of the PBH density fluctuations can be understood from the following [70]. PBH formation in the fluid picture may be regarded as a transition of a fraction of the homogeneous radiation fluid into dust. Yet, the total energy density of radiation remains homogeneous, while PBH are distributed randomly. Thus, the inhomogeneity due to PBHs must be isocurvature as the total energy density is homogeneous. Interestingly, such isocurvature is converted into curvature fluctuations when PBH dominate the universe. This type of transition from radiation to dust was studied analytically in detail by Kodama and Sasaki [285,286]. Thus, we can directly borrow their results which provide the transfer function for a vanishing initial curvature perturbation $\Phi$ and non-zero isocurvature deep inside the eMD era as

$$
T _ { \mathrm { e R D - e M D } } ^ { \mathrm { i s o \to c u r v } } ( k ; a \gg a _ { \mathrm { e q } } ) = \left\{ \begin{array} { l l } { \frac { 1 } { 5 } \qquad } & { k \ll k _ { \mathrm { e q } } } \\ { \frac { 3 } { 4 } \left( \frac { k _ { \mathrm { e q } } } { k } \right) ^ { 2 } \qquad } & { k \gg k _ { \mathrm { e q } } } \end{array} \right. .
$$

The subscript “eq” refers to the early radiation-PBH equality. For an intuitive re-derivation, see Ref. [69]. Eq. (6.23) tells us that the initial isocurvature has been transferred to a constant curvature perturbation. Modes which entered the horizon before the early radiation-PBH equality

have decayed substantially and, hence, the suppression factor $( k _ { \mathrm { e q } } / k ) ^ { 2 }$ . This means that the curvature power spectrum due to early PBH fluctuations in the eMD on the smallest scales, i.e., ( $k _ { \mathrm { U V } } > k \gg k _ { \mathrm { e q } }$ ) is given by

$$
\mathcal { P } _ { \Phi , \mathrm { P B H } } = \frac { 3 } { 8 \pi } \left( \frac { k _ { \mathrm { e q } } } { k _ { \mathrm { U V } } } \right) ^ { 4 } \left( \frac { k _ { \mathrm { U V } } } { k } \right) \Theta ( k _ { \mathrm { U V } } - k ) \Theta ( k - k _ { \mathrm { e q } } ) .
$$

It is the curvature perturbation spectrum given by (6.24) which sources induced GWs during the eMD. However, we are most interested in the induced GWs generated right at the start of the lRD. As we shall see, since PBH evaporation has a finite duration even for the monochromatic case, we must take into account an important suppression. Then we shall use our estimate Eq. (6.18). Before that, we need to understand and quantify the PBH domination a bit further.

Let us derive the conditions to have a PBH dominated era in the early universe allowed by current observations. We start with our PBHs given an initial mass $M _ { \mathrm { P B H } , i }$ (2.30) and an initial fraction $\beta$ . After formation, these PBHs will evaporate emitting Hawking radiation. This means that $\beta$ cannot be too small, otherwise PBH evaporate before they dominate. To quantify this requirement it is enough to look at the evaporation time which for a non-spinning black hole reads [68, 189, 287]

$$
t _ { \mathrm { e v a } } \approx { \frac { 1 6 0 } { 3 . 8 \pi g _ { H } ( T _ { \mathrm { P B H } } ) } } { \frac { M _ { \mathrm { P B H } , i } ^ { 3 } } { M _ { \mathrm { p l } } ^ { 4 } } } ,
$$

where $g _ { H } ( T _ { \mathrm { P B H } } )$ are the spin-weighted degrees of freedom and

$$
T _ { \mathrm { P B H } } \equiv M _ { \mathrm { p l } } ^ { 2 } / M _ { \mathrm { P B H } , i } \approx 1 . 0 6 \times 1 0 ^ { 9 } \mathrm { G e V } \left( \frac { M _ { \mathrm { P B H , f } } } { 1 0 ^ { 4 } \mathrm { g } } \right) ^ { - 1 } .
$$

If we assume only the standard model of particle physics we have that for PBHs which evaporated before BBN then $g _ { H } ( T _ { \mathrm { P B H } } ) \approx 1 0 8$ . If we include a possible PBH spin the evaporation time decreases reaching a factor $1 / 2$ for the extremal BH case [288–292]. Thus, we can take into account the PBH spin by replacing $t _ { \mathrm { e v a } }  t _ { \mathrm { e v a } } / 2$ . This effect is considered in the induced GWs by Ref. [71]. We will not consider PBH spin in what follows. From Eq. (6.25) we see that the “reheating” temperature, i.e., the temperature of the radiation fluid which dominates the universe after PBH evaporate, is given solely in terms of $M _ { \mathrm { P B H } , i }$ . Using the current cosmological parameters, which are given in App. A, we find that the evaporation temperature can be written as

$$
T _ { \mathrm { e v a } } \approx 2 . 7 6 \times 1 0 ^ { 4 } \mathrm { G e V } \left( \frac { M _ { \mathrm { P B H , } i } } { 1 0 ^ { 4 } \mathrm { g } } \right) ^ { - 3 / 2 } \left( \frac { g _ { H } ( T _ { \mathrm { P B H } } ) } { 1 0 8 } \right) ^ { 1 / 2 } \left( \frac { g _ { * } ( T _ { \mathrm { e v a } } ) } { 1 0 6 . 7 5 } \right) ^ { - 1 / 4 } ,
$$

where $g _ { * }$ are the effective degrees of freedom in the energy density of radiation [293, 294]. Here we find our first constraint on the model: PBH cannot evaporate too late if they are to reheat the universe. For a successful BBN the reheating temperature must be $T _ { \mathrm { e v a } } > 4 \mathrm { M e V }$ [295–298]. This puts an upper bound on the PBH mass as

$$
M _ { \mathrm { P B H } , i } < 5 \times 1 0 ^ { 8 } \mathrm { g } .
$$

Using Eq. (6.27), the comoving scale corresponding to the horizon size at the time of evaporation is given by

$$
k _ { \mathrm { e v a } } \approx 4 . 7 \times 1 0 ^ { 1 1 } \mathrm { M p c } ^ { - 1 } \left( \frac { g _ { H } ( T _ { \mathrm { P B H } } ) } { 1 0 8 } \right) ^ { 1 / 2 } \left( \frac { g _ { * } ( T _ { \mathrm { e v a } } ) } { 1 0 6 . 7 5 } \right) ^ { 1 / 4 } \left( \frac { g _ { * , s } ( T _ { \mathrm { e v a } } ) } { 1 0 6 . 7 5 } \right) ^ { - 1 / 3 } \left( \frac { M _ { \mathrm { P B H } , i } } { 1 0 ^ { 4 } \mathrm { g } } \right) ^ { - 3 / 2 } ,
$$

where $y _ { * , s }$ are the effective degrees of freedom in the entropy. With the above formulas we have that the end of the PBH domination era is fixed by the PBH mass. The second constraint on the model comes from requiring that PBHs dominate before they evaporate. This is a constrain on the initial fraction of PBHs in terms of the PBH mass, which is found to be [68, 70]

$$
\beta > 6 . 3 5 \times 1 0 ^ { - 1 0 } \left( { \frac { g _ { H } ( T _ { \mathrm { P B H } } ) } { 1 0 8 } } \right) ^ { 1 / 2 } \left( { \frac { \gamma } { 0 . 2 } } \right) ^ { - 1 / 2 } \left( { \frac { M _ { \mathrm { P B H } , f } } { 1 0 ^ { 4 } { \mathrm { g } } } } \right) ^ { - 1 } .
$$

Before we compute the final amplitude of the induced GW spectrum, it is very important to estimate the effects of the finite duration of the evaporation to the perturbations. Although the transition to a radiation dominated universe takes place within less than $1 / 4$ of $\mathrm { e }$ -fold, perturbations in very small scales are very much affected by the finite width of the transition, as was discovered by Inomata et al. [65, 66, 68]. The main reason is clear if we neglect the expansion of the universe, which is justified as we are interested in very subhorizon scales. As PBHs evaporate their energy density decays as [68]

$$
\rho _ { \mathrm { P B H } } \propto M _ { \mathrm { P B H } } \propto \left( 1 - \frac { t } { t _ { \mathrm { e v a } } } \right) ^ { 1 / 3 } .
$$

Now, we are interested in any effect that this decay may have on $\Phi$ . The Newtonian potential is related to fluctuations by the Poisson equation which in Fourier space reads

$$
2 \frac { k ^ { 2 } } { a ^ { 2 } } \Phi \approx \rho _ { \mathrm { P B H } } \delta _ { \mathrm { P B H } } + \rho _ { r } \delta _ { r } ,
$$

where $\delta _ { Q } \equiv \delta \rho _ { Q } / \rho _ { Q }$ is the density contrast. We will do a big step here that can be easily confirmed by looking at the formulas in the appendix of Ref. [70] or in Ref. [68]. If we completely neglect the expansion of the universe we find that $\delta _ { \mathrm { P B H } } \approx$ constant is a solution to the equations of motion of PBH density fluctuations. With this solution, we can estimate the size of the fluctuations in the radiation fluid sourced by the evaporation. With the Green’s method to solve the equations of motion of radiation fluctuations, we find that

$$
\delta _ { r } \sim \frac { \rho _ { \mathrm { P B H } } } { \rho _ { r } } \frac { a ^ { 2 } \Gamma ^ { 2 } } { k ^ { 2 } } \delta _ { \mathrm { P B H } } ,
$$

where $\Gamma$ is the evaporation rate of PBHs and it is given by

$$
\Gamma \equiv - \frac { d \ln M _ { \mathrm { P B H } } } { d t } \sim \frac { 1 } { t - t _ { \mathrm { e v a } } } .
$$

What (6.33) tell us is that fluctuations in the radiation fluid $\delta _ { r }$ with $k / a \gg \Gamma$ are very suppressed with respect to $\delta _ { \mathrm { P B H } }$ due to radiation pressure. This means that for such modes the dominant contribution to $\Phi$ is given by $\delta _ { \mathrm { P B H } }$ , even when PBH do not dominate the universe. Then by Eq. (6.32) we see that $\Phi \propto \rho _ { \mathrm { P B H } }$ until $\Gamma \sim k / a$ , at which point the fluctuations in radiation dominate and perturbations behave as in a radiation dominated universe. The temporal decay of $\Phi$ due to the decay of $\rho _ { \mathrm { P B H } }$ yields a relative suppression given by [68]

$$
S _ { \Phi } ( k / k _ { \mathrm { e v a } } ) \equiv \frac { \Phi } { \Phi _ { \mathrm { i n s t a n t } } } \approx \left( \sqrt { \frac { 2 } { 3 } } \frac { k } { k _ { \mathrm { e v a } } } \right) ^ { - 1 / 3 } ,
$$

where $\Phi _ { \mathrm { i n s t a n t } }$ refers to the value of $\Phi$ if the transition is instantaneous.

Now, we can use our estimate for an instantaneous transition (6.18) but taking into account the suppression of $\Phi$ until the transition to radiation domination is completely achieved. This yields a spectrum of curvature fluctuations at the start of the lRD given by

$$
\begin{array} { r l } & { \mathcal { P } _ { \Phi , \mathrm { I R D } } = S _ { \Phi } ^ { 2 } ( k / k _ { \mathrm { e v a } } ) \mathcal { P } _ { \Phi , \mathrm { P B H } } } \\ & { \qquad = \frac { 3 } { 8 \pi } \left( \frac { 2 } { 3 } \right) ^ { - 1 / 3 } \left( \frac { k _ { \mathrm { U V } } } { k _ { \mathrm { e v a } } } \right) ^ { - 2 / 3 } \left( \frac { k _ { \mathrm { e q } } } { k _ { \mathrm { U V } } } \right) ^ { 4 } \left( \frac { k } { k _ { \mathrm { U V } } } \right) ^ { - 5 / 3 } \Theta ( k _ { \mathrm { U V } } - k ) \Theta ( k - k _ { \mathrm { e q } } ) . } \end{array}
$$

Comparing (6.36) with (6.14) we see that $n = 5 / 3$ and

$$
\mathcal { A } _ { \Phi } = \frac { 3 } { 8 \pi } \left( \frac { 2 } { 3 } \right) ^ { - 1 / 3 } \left( \frac { k _ { \mathrm { U V } } } { k _ { \mathrm { e v a } } } \right) ^ { - 2 / 3 } \left( \frac { k _ { \mathrm { e q } } } { k _ { \mathrm { U V } } } \right) ^ { 4 } .
$$

The final ingredient to derive the induced GW spectrum is the hierarchy of the scales involved. First, note that the ratio between the cut-off $k _ { \mathrm { U V } }$ and $k _ { \mathrm { e v a } }$ is independent of $\beta$ and it is given by [70]

$$
{ \frac { k _ { \mathrm { U V } } } { k _ { \mathrm { e v a } } } } \approx 2 . 3 \times 1 0 ^ { 6 } \left( { \frac { g _ { H } ( T _ { \mathrm { P B H } } ) } { 1 0 8 } } \right) ^ { - 1 / 3 } \left( { \frac { M _ { \mathrm { P B H } , i } } { 1 0 ^ { 4 } { \mathrm { g } } } } \right) ^ { 2 / 3 } .
$$

The $\beta$ independence of the ratio is due to the fact that $H _ { \mathrm { e v a } }$ only depends on the PBH mass and $a _ { \mathrm { e v a } } / a _ { i } \propto n _ { \mathrm { P B H } , i } ^ { 1 / 3 }$ because it is a dust dominated universe. The hierarchy is closed with the second and third relations respectively given by [70]

$$
\frac { k _ { \mathrm { e q } } } { k _ { \mathrm { U V } } } = \sqrt { 2 } \gamma ^ { 1 / 3 } \beta ^ { 2 / 3 } \quad \mathrm { a n d } \quad \frac { k _ { \mathrm { e q } } } { k _ { p } } = \sqrt { 2 } \beta .
$$

Now, inserting Eqs. (6.38), (6.39) and (6.36) into (6.19) yields an amplitude of induced GWs at the peak of approximately

$$
\Omega _ { \mathrm { G W s , e w a } } ^ { \mathrm { p e a k } } \approx 1 . 5 \times 1 0 ^ { - 2 } \left( \frac { \beta } { 1 0 ^ { - 6 } } \right) ^ { 1 6 / 3 } \left( \frac { \gamma } { 0 . 2 } \right) ^ { 8 / 3 } \left( \frac { g _ { H } ( T _ { \mathrm { P B H } } ) } { 1 0 8 } \right) ^ { - 1 7 / 9 } \left( \frac { M _ { \mathrm { P B H } , f } } { 1 0 ^ { 4 } \mathrm { g } } \right) ^ { 3 4 / 9 } .
$$

Note that the estimate Eq. (6.40) is the amplitude of induced GWs right after evaporation. It should also be noted that (6.40) is valid for very sharp PBH mass functions. As the mass function widens, the induced GW counterpart gets suppressed [68]. On top of that, we have that scales $k \ > \ k _ { N L }$ (6.1), specially for $k \sim k _ { U V }$ , PBH density fluctuations $\delta _ { \mathrm { P B H } }$ become $O ( 1 )$ or larger. However, our estimate (6.40) has been derived in the linear regime and might receive corrections due to non-linear effects. Nevertheless, we expect it to be a crude order of magnitude estimate since the main source of induced GWs, the curvature perturbation, remains always smaller than unity,18 i.e., $\Phi \ll 1$ . Numerical relativity simulations are needed to derive a preciser estimate of the induced GWs generated in the non-linear regime. We show the resulting induced GW spectrum in Fig. 8. Using (6.29) and (6.38) we find that the peak of induced GWs today lies at a frequency given by

$$
f _ { \mathrm { U V } } \approx 1 . 7 \times 1 0 ^ { 3 } \mathrm { { H z } } \left( { \frac { g _ { H } ( T _ { \mathrm { { P B H } } } ) } { 1 0 8 } } \right) ^ { 1 / 6 } \left( { \frac { g _ { * } ( T _ { \mathrm { { e v a } } } ) } { 1 0 6 . 7 5 } } \right) ^ { 1 / 4 } \left( { \frac { g _ { * , s } ( T _ { \mathrm { { e v a } } } ) } { 1 0 6 . 7 5 } } \right) ^ { - 1 / 3 } \left( { \frac { M _ { \mathrm { { P B H } } , i } } { 1 0 ^ { 4 } \mathrm { { g } } } } \right) ^ { - 5 / 6 } .
$$

Quite surprisingly, the frequency of the peak enters the observational range of LISA, DECIGO and LIGO for $5 \times 1 0 ^ { 8 } \mathrm { g } > M _ { \mathrm { P B H , i } } > 2 \times 1 0 ^ { 4 } \mathrm { g }$ . Thus, this scenario is testable in the future.

![](images/5bd083e80632200c7e012221bffcf5133fca4950a9469e366ae67982cac5cca6.jpg)  
Figure 8: Induced GW spectral density after PBH evaporation normalized by $\beta ^ { 1 6 / 3 }$ and in terms of comoving wavenumber $k / k _ { \mathrm { U V } }$ . The dashed red line shows the resonant contribution from Eq. (6.16). The dashed orange line is the large momentum contribution which can be found in [70]. The purple line is the total GW spectrum. Due to the almost sudden transition the GW spectrum is amplified. This implies a very small initial fraction $\beta$ of PBH not to overproduce induced GWs.

To compute the amount of induced GWs measured today we must consider the redshift of GWs until today. We did this in Sec. 5 with Eq. (5.2). However, if we want to evaluate the amplitude of induced GWs at BBN, we only need to know the fraction of GWs that compose the total radiation after reheating. This can be done by considering the degrees of freedom of the standard model, which leads us to

$$
\Omega _ { \mathrm { G W , B B N } } = 0 . 3 9 \left( \frac { g _ { * } ( T _ { \mathrm { e v a } } ) } { 1 0 6 . 7 5 } \right) \left( \frac { g _ { * s } ( T _ { \mathrm { e v a } } ) } { 1 0 6 . 7 5 } \right) ^ { - 4 / 3 } \Omega _ { \mathrm { G W , e v a } } .
$$

Since these induced GWs act as additional radiation, they contribute to the effective number of relativistic species $N _ { \mathrm { e f f } }$ at BBN. The contribution of GWs to $N _ { \mathrm { e f f } }$ is by convention $^ { 1 9 }$ written as [28]

$$
\Omega _ { \mathrm { G W , B B N } } = \frac { 7 } { 8 } \left( \frac { 4 } { 1 1 } \right) ^ { 4 / 3 } \Delta N _ { \mathrm { e f f } } < 0 . 0 5 ,
$$

where in the last step we used that BBN [299, 300] sets an upper bound $\Delta N _ { \mathrm { e f f } } < 0 . 2$ .20 In this way, we can constrain the amplitude of GWs from existing BBN bounds. Note that to be precise the BBN bound is a constrain on the total energy density of relativistic particles. Thus, we should have actually integrated our induced GW spectrum over $\ln { k }$ and then compare it with the bound (6.43). However, since the GW spectrum is very peaked and we are already working with order of magnitude estimates, it is justified to just look at the peak of the GW spectrum. If we use the current constraints from BBN, then we obtain that

$$
\beta < 1 . 5 \times 1 0 ^ { - 6 } \left( \frac { M _ { \mathrm { P B H } , i } } { 1 0 ^ { 4 } \mathrm { g } } \right) ^ { - 1 7 / 2 4 } .
$$

This is a new constraint on early epochs of PBH dominations which cannot be obtained by any other means.

Interestingly, PBH evaporation also emits “gravitons”, i.e., very high frequency GWs. While these gravitons are not observable by GW detectors, they might be seen as effective relativistic particles at BBN [288–292]. Future CMB probes such as CMB-S4 [303] will be able to improve current bounds down to $\Delta N _ { \mathrm { e f f } } \sim 0 . 0 2$ . Unfortunately, the graviton contribution of non-spinning PBHs to $N _ { \mathrm { e f f } }$ is out of reach for future CMB probes. Nevertheless, if PBH have a large spin (and dominate the universe at some point), the graviton contribution to $N _ { \mathrm { e f f } }$ will be accessible to future experiments [291, 292]. This signature from graviton emission together with induced GWs will be an interesting probe of PBH dominated eras. While the graviton contribution to $N _ { \mathrm { e f f } }$ tells us about PBH spin, the induced GW counterpart has information on the formation mechanism [71]. As a clarification, note that the graviton emission and induced GWs are two very different effects. While the former is emitted by Hawking evaporation, the latter is generated by the time dependence of density fluctuations. The composition of such density fluctuations is not important, e.g., if a fraction are gravitons, as long as it behaves as fluctuations of a radiation fluid.

Before ending this section, we should note that we also have the induced GWs generated in the PBH dominated stage by using the Kernel (6.3). This is studied in detail in Ref. [69]. However, as we discussed at the beginning of this section this contribution is sensitive to the detailed transition to radiation domination. In the present case, where the transition is almost instantaneous, we can continue the tensor mode amplitude build up during eMD to the lRD. Nevertheless, this contribution is always subdominant compared to the one after reheating [66]. Thus, our estimate (6.40) provides the dominant peak of the induced GW spectrum.

# 7 The gauge issue

Despite the large amount of research on induced GWs, there is still the open question of what we really observe. This was made explicit in 2017, when Hwang, Jeong and Noh [149] showed that the induced GW spectrum generated in a dust dominated universe depends very much (by orders of magnitude) on the gauge chosen. Although the gauge issue was mentioned earlier by Matarrese, Mollerach and Bruni [37], it was not until [149] that it received more attention. From then and on, there has been a big activity to understand the problem [150–162]. For example in Refs. [151, 152] other cosmological backgrounds rather than dust were studied. They found that the gauge dependence is in general present. Later studies [153–162], proposed partial solutions and investigated in which situations the spectrum of induced GW might be well defined. We dedicate sec. 7.1 to explain the origin of the gauge issue. Then, we discuss these approaches in detail in Sec. 7.2.

 Main references: The discussion in sec. 7.1 is mainly based on [150, 161]. Then, in Sec. 7.2 we revisit the main arguments of [153, 154] and explain the improved results of [161].

# 7.1 The origin of the issue

To understand the source of problem, we must distinguish between what we call tensor modes and GWs. On the theoretical side, we define tensor modes in a homogeneous and isotropic universe as the transverse-traceless fluctuations of the spatial metric.21 However, this definition must depend on how one chooses the spatial hypersurface. Although tensor modes are gauge invariant at linear order, they fail to be so at second order in cosmological perturbation theory. This is reflected by the fact that tensor, vector and scalar modes mix at second order [37]. This may pose a problem when we want to relate the tensor modes in a given slicing to the observational effect, which are the GWs. Note that this is not necessarily an “issue”. If the quantity related to observation is clear and calculations are done properly (perhaps in a reasonable coordinate system), one should get proper results. For example, in studies of the CMB the temperature anisotropies and the polarization patterns of the CMB are well defined at second order. The interested reader is referred to Refs. [306–308] and references therein.

The trouble with GW observations is that we only know the GW detector response to linear GWs. Only at first order the relation between the tensor modes and GWs in the linearised theory is clear, since tensor modes are gauge invariant at that order. There is a subtlety, though. A tensor mode whose wavelength is larger than the horizon is frozen, it does not evolve. So it acts as a constant anisotropy or shear and, as such, it has nothing to do with actual GWs. Furthermore, since the wavelength of the tensor modes is larger than the curvature scale, the averaging procedure used to derive the (pseudo) energy momentum tensor of GWs in Sec. 2.2 does not apply. For these reasons, we will be only concerned about tensor modes on subhorizon scales. These tensor modes have a wavelength smaller than the horizon and behave as a wave, which are the GWs we could observe.

In the absence of the GW detector response at second order, we face the problem that we do not know the relation between tensor modes and the true GWs. In most situations though this should not really be a problem, unless one is choosing a very strange coordinate system to describe the observations. For instance, to describe the GWs measured by a GW detector today we usually do not need to consider second order terms as the amplitude of the GWs is already tiny enough. However, this issue is particularly relevant for induced GWs due to their secondary nature. Now, there are two important aspects of the problem. First, we have that the derived tensor spectrum depends on the gauge choice. Second, we expect that once the source term in (3.15) is absent, i.e., its amplitude decayed enough, such previously induced tensor modes behave as a freely propagating GWs. From that moment on we should be able to relate the induced tensor modes to GWs. Thus, we must reconcile our physical intuition with the fact that tensor modes are gauge dependent. To arrive to that, there are two points that we would like to make as clear as possible. The first one concerns the tensor modes $h _ { i j }$ themselves and the second one to the actual observable, which in Sec. 2.2 we decided it would be the energy density of induced GWs (2.5). We present them in the following subsections and we later discuss the current state of the issue in Sec. 7.2.

# 7.1.1 The definition of tensor modes is gauge dependent

When working at second order in cosmological perturbation theory, it is very important to be clear about our convention. Here we will use the conformal decomposition from Eqs. (3.1) and (3.5) which in a general gauge reads

$$
d s ^ { 2 } = a ^ { 2 } ( \tau ) \left( - N ^ { 2 } d \tau ^ { 2 } + \mathrm { e } ^ { 2 \phi } \Upsilon _ { i j } \left( d x ^ { i } + N ^ { i } d \tau \right) \left( d x ^ { j } + N ^ { j } d \tau \right) \right) ,
$$

where $N$ and $N ^ { i }$ respectively are the lapse and shift vector. We then perturb the variables as follows

$$
\begin{array} { c } { { N = 1 + \alpha \quad , \quad N _ { i } = \partial _ { i } \beta } } \\ { { { } } } \\ { { [ \ln \Upsilon ] _ { i j } = h _ { i j } + 2 \left( \partial _ { i } \partial _ { j } - \frac { 1 } { 3 } \delta _ { i j } \Delta \right) E , } } \end{array}
$$

where we only focused on the tensor and scalar components and $\phi$ is already a perturbation. Our convention differs from the common expansions, which expands the metric linearly in the perturbation variables instead of exponentially. Nevertheless, our choice simplifies considerably calculations. To relate the two different conventions we refer the reader to the appendix of Ref. [161]. We also use the exponential mapping for a gauge transformation (e.g., see the review by Malik and Wands [164]) which naturally follows from the Hamiltonian flow (see e.g., [150] for the application to second order cosmological perturbations). To be more concrete, let us do an infinitesimal coordinate transformation by

$$
\tilde { x } ^ { \mu } = x ^ { \mu } - \xi ^ { \mu } \quad \mathrm { w i t h } \quad \xi ^ { \mu } = ( T , \partial ^ { i } { \cal L } ) ,
$$

where we focused only on the scalar component of the spatial vector $\xi ^ { i }$ . Then a quantity $Q$ in one gauge is related to the same quantity evaluated in another gauge $\tilde { Q }$ by the exponential mapping

$$
\tilde { Q } = e ^ { \pounds _ { \xi } } Q ,
$$

where $\mathcal { E } _ { \xi }$ is the Lie derivative along $\xi$ . With this convention, we find that the tensor modes at second order change according to

$$
\tilde { h } _ { i j } = h _ { i j } - \widehat { T T } _ { i j } ^ { a } { } ^ { a } \Big \{ - 2 \partial _ { a } \left( \beta - { \cal E } ^ { \prime } \right) \partial _ { b } T + 2 \partial _ { a } \partial _ { k } L \partial _ { k } \partial _ { b } { \cal E } + \partial _ { a } T \partial _ { b } T + \partial _ { a } \partial _ { k } L \partial _ { b } \partial _ { k } { \cal L } \Big \} .
$$

Eq. (7.6) is the first cause of the gauge issue for induced GWs. Since the source to induced tensor modes acts at second order in perturbation theory, the actual gauge in which we do the calculations might change drastically the form of the solutions for $h _ { i j }$ [149]. The reader interested in the gauge transformations particularly related to induced GWs might go to Ref. [161]. General reviews of cosmological perturbation theory are listed at the beginning of this review.

# 7.1.2 The definition of GW energy density is gauge dependent

Once we showed that the tensor modes $h _ { i j }$ are gauge dependent, let us look at the definition of the “observable” energy density of GWs. Using (2.2) we have that

$$
\rho _ { \mathrm { G W } } = t _ { 0 0 } ^ { \mathrm { G W } } = \frac { M _ { p l } ^ { 2 } } { 8 a ^ { 2 } } \bigg \langle h ^ { \prime i j } h _ { i j } ^ { \prime } + \partial _ { k } h ^ { i j } \partial ^ { k } h _ { i j } \bigg \rangle .
$$

Now, looking at (7.6) and (7.7) the first question that comes to mind is: $h _ { i j }$ in (7.7) is evaluated in which gauge? Indeed, if we naively apply the gauge transformation (7.6) to (7.7) we see that

$$
\tilde { \rho } _ { \mathrm { G W } } \sim \langle \tilde { h } ^ { \prime i j } \tilde { h } _ { i j } ^ { \prime } \rangle = \rho _ { \mathrm { G W } } + \langle \partial _ { i } T \partial _ { j } T \partial ^ { i } T \partial ^ { j } T \rangle + \ldots ,
$$

where we neglected other terms to illustrate the main point, which is that the term quartic in $T$ in (7.8) does not vanish in general. This shows something that we were expecting in Sec. 2: the energy density of GWs (7.7) in analogy of the Ricci flat result (2.2) is strictly speaking not well-defined on a cosmological background at second order in perturbation theory. Furthermore, it does not matter when you evaluate the energy density, e.g., today. In principle, we can find a coordinate transformation in which $\rho _ { \mathrm { G W } }$ is very different from the usual estimate. For example, if we go to a frame where the detector is wildly oscillating, Eq. (7.7) might not yield sensible results. This is the second and the most important cause for the gauge dependence of induced GWs.

# 7.2 Current “solutions”

In view of the current lack of a description at second order in cosmological perturbation theory of the detector response to passing GWs, all we can do is to try to argue when Eq. (7.7) yields sensible results. Before we start discussing the details, it is important to realize that a gauge invariant formulation of the equations of motion of induced GWs (3.15) does not help at all. There are infinitely many ways to define gauge invariant variables, each definition corresponding to a particular gauge choice. Thus, the same question remains, although with a slightly different language: which gauge invariant definition of the tensor modes goes into (7.7)? Similarly, if one tries to find a gauge invariant formulation of (7.7), which implies going to fourth order in cosmological perturbation theory (and it is clearly not the point), it is not clear what is the relation with the real observable. So, what can we do?

An interesting direction, first explored by [153] and later corrected by [154], is to argue what is the gauge (or coordinate frame) which best describes the GW detection. According to Ref. [153], based on the analogy with asymptotically flat spacetimes, the best gauge is the so-called transversetraceless (TT) gauge where the metric reads

$$
d s ^ { 2 } = - d t ^ { 2 } + ( \delta _ { i j } + h _ { i j } ) d x ^ { i } d x ^ { j } .
$$

In Minkowski spacetime, there are only two degrees of freedom, the ones in $h _ { i j }$ , since there is no source to the energy momentum tensor. In this gauge and in the linearised theory, the GW detector is at rest, even for passing GWs, which makes the physical interpretation (and calculations) much easier [184,185]. The closest gauge to the TT gauge in a cosmological background is the synchronous gauge which is a coordinate system spanned by a family of geodesics. In our convention the metric in the synchronous gauge is given by

$$
d s ^ { 2 } = a ^ { 2 } ( \tau ) \left( - d \tau ^ { 2 } + { \mathrm e } ^ { 2 \phi } \Upsilon _ { i j } d x ^ { i } d x ^ { j } \right) ,
$$

where we set $\alpha = \beta = 0$ in (7.1). Let us remind the reader that

$$
\begin{array} { r } { [ \mathrm { l n } \Upsilon ] _ { i j } = h _ { i j } + 2 \left( \partial _ { i } \partial _ { j } - \frac { 1 } { 3 } \delta _ { i j } \Delta \right) E , } \end{array}
$$

and therefore we have two more variables, $\phi$ and $E$ , than in (7.9). In the end, only one of them is dynamical. Thus, although at linear order (7.11) resembles the TT gauge (7.9) it is certainly not the same. At linear order and if we neglect the drift due to the expansion $a$ , the metric (7.11) does describe a fixed detector. However, at second order the detector will not be fixed and will feel the influence of $E$ . Another “problem” of the synchronous gauge is that it is not a completely fixed gauge. There is a residual gauge ambiguity which corresponds to a change of the reference geodesics. This gauge ambiguity turns out to be very important in the final spectrum of induced tensor modes. If one does not properly fix the synchronous gauge, then induced tensor modes could be very different than, e.g., in the Newtonian gauge [158]. This is because if we start with a family of geodesics defined in the very early universe and we use the same geodesics to describe the GW detection, it is very possible that these geodesics do not match the rest frame of the detector. The resulting induced tensor spectrum might be singular if those geodesics happen to have focusing singularities near the detector [161]. Nevertheless, by properly fixing the gauge one finds that the induced GW spectrum in the synchronous gauge and in the Newtonian gauge yield the same prediction in a radiation dominated universe [153–155, 158]. This also holds for any cosmological background with a constant equation of state [161] if it is not dust, i.e., $c _ { s } ^ { 2 } \neq 0$ . This result provides evidence that perhaps the energy density of GWs (7.7) computed in the Newtonian gauge, which we do for simplicity of the calculations, yields meaningful results. However, it does not explain why these two predictions coincide. Furthermore, the original issue raised in [149] in a dust dominated universe persist.

Here is where the direction explored in Ref. [161] becomes relevant: when and why the energy density of GWs (7.7) yields the same predictions and for which gauges? The physical intuition is that the analogy with Ricci flat spacetimes should work well if:

(i) we look at really subhorizon scales ( $k \gg \mathcal { H }$ ), where cosmology should be less relevant,   
(ii) there is (barely) no source of induced GWs (3.15), so that induced tensor modes are freely propagating GWs,   
(iii) we use a coordinate system suitable for small distances calculations, so that we are not confused by strange coordinate artefacts.

As shown in [161], if points $( i ) - ( i i i )$ are satisfied then (7.7) is gauge independent up to corrections of $O ( \mathcal { H } ^ { 2 } / k ^ { 2 } )$ . Note that conditions $( i i )$ and $( i i i )$ yield some restrictions respectively on the type of cosmological background and on the class of gauges. In order to show such approximate gauge independence, Ref. [161] argued that a good gauge choice to start with is the Newtonian gauge. The physical reason for that choice is that on small distances the Newtonian gauge reduces to the well-known Newtonian gravity. The practical reason is that calculations are simpler. Nevertheless, the argument provided in [161] does not strongly depend on the initial choice provided that it is suitable for subhorizon calculations. For example, one could have started with the synchronous gauge or the uniform Hubble gauge.

Starting from the Newtonian gauge we can relate the curvature perturbation $\Phi$ in any gauge, say $\Phi ^ { G }$ , with that of the Newtonian gauge, say $\Phi ^ { N }$ , by (7.5) which yields

$$
\begin{array} { r } { \Phi _ { G } = \Phi _ { N } + \mathcal { H } T _ { G } + \frac { 1 } { 3 } \Delta L _ { G } . } \end{array}
$$

Then, the class of suitable gauges for subhorizon physics is defined as those gauges in which

$$
\Phi _ { G } ( k \gg \mathcal { H } ) = O ( \Phi _ { N } ( k \gg \mathcal { H } ) ) .
$$

This means that the curvature perturbation need not be the same but have the same qualitative behaviour. We shall see that although this is a requirement on the scalar variable $\Phi$ , it yields the gauge independence of $h _ { i j }$ . Using (7.13) into (7.12) we find conditions on the gauge parameters $T _ { G }$ and $L _ { G }$ . For example, the gauge time parameter must be

$$
T _ { G } ( k \gg \mathcal { H } ) = O ( \mathcal { H } ^ { - 1 } \Phi _ { N } ( k \gg \mathcal { H } ) ) \mathrm { o r h i g h e r o r d e r } .
$$

Note that this abstract condition (7.13) actually includes most of the commonly used gauges such as the synchronous, the flat and the constant Hubble gauges [161]. However, it excludes the comoving slicing gauge [161]. The main reason for such exclusion is that the comoving slicing gauge is a choice where the spatial hypersurface is orthogonal to the flow lines of the fluid. This is a good choice for superhorizon scales where the flow lines are slowly changing with time, but it is a poor choice for subhorizon scales where fluid velocities oscillate. To convince ourselves of the gauge independence of (7.7), take the solution to $\Phi ^ { N }$ (4.5) and $h _ { i j } ^ { N }$ (4.14) for constant $w$ , which read

$$
\Phi _ { k } ^ { N } \propto \left( \frac { k } { \mathcal { H } } \right) ^ { - 2 - b } \quad \mathrm { a n d } \quad h _ { k } ^ { N } \propto \left( \frac { k } { \mathcal { H } } \right) ^ { - 1 - b } .
$$

For such solutions, the condition (7.14) translates into

$$
T _ { G } = O ( h _ { k } ^ { N } ) \mathrm { o r ~ h i g h e r ~ o r d e r } .
$$

Then, using (7.6) with $L _ { G } = 0$ and in Fourier space we have

$$
h _ { k } ^ { G } = h _ { k } ^ { N } - \int \frac { d ^ { 3 } q } { ( 2 \pi ) ^ { 3 } } e ^ { i j } q _ { i } q _ { j } T _ { G } ( q ) T _ { G } ( | { \bf k - q } | ) ,
$$

where we used that in the Newtonian gauge we have $E = \beta = 0$ . So when substituting (7.16) in (7.17) we conclude that for all gauges which satisfy (7.13) we have that

$$
h _ { k } ^ { G } ( k \gg \mathcal { H } ) = h _ { k } ^ { N } ( k \gg \mathcal { H } ) + O ( \mathcal { H } ^ { 2 } / k ^ { 2 } ) ,
$$

which proves the approximate gauge independence of $\rho$ GW (7.7). It should be noted that while the work of [161] is not a solution per se, it shows when and why the predictions for induced GWs are well-defined and gives strong evidence that the calculations in this class of gauges are meaningful. In any case, the final word would be to find the GW detector response at second order.

Before ending this section, let us place some more attention to point $( i i )$ , i.e., that the source term to induced GWs is not active. This means that the amplitude of scalar fluctuations has decayed enough so that they are no longer a significant source of induced GWs. This is often implied by taking the subhorizon limit $k \gg \mathcal { H }$ since induced GWs are mainly generated at horizon crossing, i.e., $k \sim \mathcal { H }$ , and not afterwards. However, there is one exception: the dust dominated universe studied in Sec. 6. In a dust dominated universe, the Newtonian potential $\Phi$ is constant on all scales and, therefore, is constantly sourcing induced GWs. This is the reason why Ref. [149] finds such large gauge dependence of induced GWs in a dust dominated universe. Yet, we learned in Sec. 6 that the final spectrum of induced GWs is very sensitive to the transition from dust to radiation, where $\Phi$ changes from a constant to an oscillating function. Thus, one must follow the induced tensor modes generated in the dust dominated universe until they are deep inside the horizon in the radiation dominated era. It is from that moment on that the conditions $( i ) - ( i i i )$ of [161] apply. Then we know that the spectrum of induced GWs is approximately gauge invariant.

# 8 Other GW sources related to PBH formation

So far, we have focused on the GW induced by large primordial fluctuations. These large fluctuations collapse to form PBH if their rms amplitude is large enough. Once PBH form they may source other GWs independent of the induced GWs. Let us anticipate that the other GW counterparts are from PBHs mergers and graviton emission by Hawking evaporation. We briefly comment on these possibilities below.

On one hand, PBHs will form binaries in the early universe and eventually merge. The formation of such binaries is mainly due to the three body interaction with the nearest PBH [309]. These PBH binaries can be detected by the observation of resolved or unresolved merger events. In the former we would see the full GW waveform, e.g., as in the LIGO detections [310], and the latter will appear as a stochastic GW background. These makes two additional possible GW counterparts to PBHs. Note that if PBHs are lighter than $\mathrm { 1 0 ^ { 1 5 } g }$ they evaporated by today and, therefore, we probably cannot observe any resolved merger. PBHs heavier than $\mathrm { 1 0 ^ { 1 5 } g }$ have not yet evaporated and their binaries could be merging in the nearby universe. The GW spectrum from the unresolved mergers is studied in Refs. [142, 311, 312] while the estimates for the merger rates can be found in Refs. [174, 309, 313–316]. A very rough order of magnitude estimate of the frequency at which the GWs from the mergers of PBH binaries will show up is given by the frequency of the GWs emitted at the Innermost Stable Circular Orbit [185]

$$
f _ { \mathrm { G W , m a x } } \approx 2 f _ { \mathrm { I S C O } } \approx 4 . 4 \mathrm { k H z } \left( \frac { M _ { \odot } } { M } \right) ,
$$

where $M$ is the total mass of the binary and $M _ { \odot }$ is a solar mass. For a monochromatic PBH mass function then $M = 2 M _ { \mathrm { P B H , i } }$ . This may change by a factor of a few depending on the redshift at the time of merger, so that $f _ { \mathrm { G W , m a x , 0 } } = f _ { \mathrm { G W , m a x } } / ( 1 + z )$ . For PBHs with $M _ { \mathrm { P B H , i } } \gg 1 0 ^ { 1 5 } \mathrm { g }$ we can assume that most of the mergers occur in the nearby universe and so the frequency (8.1) already gives a good intuition of the position of the peak in the SGWB from mergers and the chirp frequency of the GW waveform, see for example Ref. [142]. However, PBHs with $M _ { \mathrm { P B H , i } } < 5 \times 1 0 ^ { 8 } \mathrm { g }$ have merged and evaporated long before BBN. In this case, we can assume that most of the mergers occur close to the evaporation time and, if PBH dominated the universe as in Sec. 6.2, we can take into account the redshift of the frequency (8.1) until today. A quick estimate yields

$$
f _ { \mathrm { p e a k , 0 } } ^ { \mathrm { m e r g e r } } \approx 1 0 ^ { 1 5 } \mathrm { H z } \left( \frac { M _ { \mathrm { P B H , i } } } { 1 0 ^ { 4 } \mathrm { g } } \right) ^ { 1 / 2 } \left( \frac { g _ { \ast } ( T _ { \mathrm { e v a } } ) } { 1 0 6 . 7 5 } \right) ^ { 1 / 4 } \left( \frac { g _ { s \ast } ( T _ { \mathrm { e v a } } ) } { 1 0 6 . 7 5 } \right) ^ { - 1 / 3 } \left( \frac { g _ { H } ( T _ { \mathrm { P B H } } ) } { 1 0 8 } \right) ^ { - 1 / 2 } ,
$$

which gives the right order of magnitude estimate for the position of the peak. For the detailed spectral shape in this case see Ref. [68]. The peak frequency of this SGWB is unfortunately too high to be observed by current laser interferometers. Note that the PBH mass range $1 0 ^ { 9 } \mathrm { g } < M _ { \mathrm { P B H , i } } <$ $\mathrm { 1 0 ^ { 1 4 } g }$ is subject to tight constraints from entropy production, changes in the abundance of light elements, the extragalactic photon background and damping of CMB temperature anisotropies. For a detailed review see Ref. [176].

On the other hand, when PBHs evaporate they also emit “gravitons” by Hawking radiation. The typical frequency of such gravitons can be estimated by assuming that Hawking radiation follows a black body spectrum. Then, the peak frequency is roughly at $f _ { \mathrm { p e a k } } \approx 2 . 8 2 T _ { \mathrm { P B H , i } }$ where $T _ { \mathrm { P B H , i } }$ is given in Eq. (6.26) in terms of the initial PBH mass $M _ { \mathrm { P B H , i } }$ . Note that the frequency $f _ { \mathrm { p e a k } }$ is the peak frequency of the spectrum when PBH evaporate. Thus, we have to take into account that frequencies redshift proportional to $a ^ { - 1 }$ to calculate the frequency of these gravitons today. To do that, we will use the calculations of Sec. 6.2 which considers the case that PBH dominate the universe. Then, we can compute the evaporation temperature $\chi _ { \mathrm { e v a } }$ in terms of $M _ { \mathrm { P B H , i } }$ by Eq. (6.27). Inserting all numerical coefficients, we find that the graviton peak frequency today is given by

$$
f _ { \mathrm { p e a k , 0 } } ^ { \mathrm { g r a v i t o n } } \approx 1 0 ^ { 1 6 } \mathrm { H z } \left( \frac { M _ { \mathrm { P B H , i } } } { 1 0 ^ { 4 } \mathrm { g } } \right) ^ { 1 / 2 } \left( \frac { g _ { * } ( T _ { \mathrm { e v a } } ) } { 1 0 6 . 7 5 } \right) ^ { 1 / 4 } \left( \frac { g _ { s * } ( T _ { \mathrm { e v a } } ) } { 1 0 6 . 7 5 } \right) ^ { - 1 / 3 } \left( \frac { g _ { H } ( T _ { P B H } ) } { 1 0 8 } \right) ^ { - 1 / 2 } .
$$

A more detailed derivation of the graviton spectrum and the frequency range can be found in Ref. [68]. Unfortunately, these are very high frequency GWs which are not observable by direct detection with the current capabilities. Nevertheless, they might be within range of future CMB experiments by looking at the contribution of these gravitons to the effective number of relativistic species at BBN [288–292]. Very interestingly if PBHs have a large spin, their imprint on the effective number is within range of the CMB-S4 experiment [291, 292].

It is also important to notice that in some inflationary models involving axions coupled to gauge fields the enhancement in the primordial curvature perturbation is accompanied by an enhancement in the primordial tensor spectrum [88, 100, 317]. In this case the primordial GW signal is in general larger than the induced GW one. Thus, in this scenario the induced GW signal may be buried inside the primordial GWs. It is possible that a detailed observation of the spectrum and the PBH counterpart helps to distinguish such scenario.

# 9 Current and future observational prospects

In this section, we briefly discuss the future observational prospects regarding induced GWs. We will not focus on the prospects for PBHs, although they are equally interesting. Nevertheless, let us mention the most interesting PBH windows as they provide good motivation to look for induced GWs in particular ranges. The first one is the LIGO binary black hole mergers [309, 313–315]. Notably, although some models are already ruled out by current data [318] there seems to be evidence for a small fraction of PBHs in addition to astrophysical ones [319, 320]. Interestingly, the corresponding induced GWs to the PBHs in the LIGO window fall in the PTA band. $^ { 2 2 }$ Coincidently, the NANOGrav collaboration reported a possible SGWB in such range [18], yet to be confirmed. We discuss more on NANOGrav a bit later. Another interesting window is the planet mass PBHs [321] where the OGLE collaboration reported few microlensing events of planet mass objects [322]. Future microlensing observations such as with Subaru/HSC [323] will be able to confirm the results from OGLE. If we assume that radiation dominated early universe, planet mass PBHs have an induced GW counterpart that falls in between PTA and LISA. The last promising window is for PBHs in the asteroid mass range where there are practically no observational constraints yet [174, 176] and therefore PBHs can make up for all dark matter. In this case, the induced GW counterpart falls right inside the LISA band. Thus, induced GW will be an essential probe of PBH as dark matter. For a review see Ref. [179]. Also see Ref. [142] for a detailed discussion.

Let us now turn to the observational prospects of induced GWs. Although there are weak constraints from LIGO [324] on the induced SGWB [312, 325, 326], the most interesting part is the future prospects. On one hand, the absence of induced GWs directly translates into bounds on the primordial spectrum [29]. In this way, assuming radiation domination, we see from Ref. [29] that the bounds are roughly $\mathcal { P } _ { \mathcal { R } } \sim 1 0 ^ { - 5 }$ for $k \sim 1 0 ^ { 6 } - 1 0 ^ { 8 } \mathrm { M p c ^ { - 1 } }$ in the PTA band, $\mathcal { P } _ { \mathcal { R } } \sim 1 0 ^ { - 4 }$ for $k \sim 1 0 ^ { 1 1 } - 1 0 ^ { 1 4 } \mathrm { M p c ^ { - 1 } }$ in the LISA band and $\mathcal { P } _ { \mathcal { R } } \sim 1 0 ^ { - 3 }$ for $k \sim 1 0 ^ { 1 5 } - 1 0 ^ { 1 8 } \mathrm { M p c ^ { - 1 } }$ in the ET band. CMB spectral distortions will probe down to $\mathcal { P } _ { \mathcal { R } } \sim 1 0 ^ { - 8 }$ for $k \sim 1 0 - 1 0 ^ { 5 } \mathrm { M p c ^ { - 1 } }$ [31, 32]. However, one of the problems is that such future bounds depend on the shape of the induced GW spectrum. For example, if we only see part of the induced GW spectrum, e.g., the UV or IR tail but not the peak, then in order to extract information on the amplitude of primordial fluctuations we must extrapolate the results beyond the range of the GW detector by assuming some template [172]. On top of that, we have the issue that some induced GW templates might degenerate with other sources. As a good example for these potential problems, we proceed to discuss the various induced GW explanations of the NANOGrav results [18].

![](images/ffe1f9eaba71c7f3d7bcc19eff2f5d786d6e166aea2d8743838523f1703962dc.jpg)  
Figure 9: NANOGrav results on the possible SGWB [18] in terms of spectral density. The orange dots are the data points from the timing residuals with their error bars. We only show the first five data points which are the most relevant. The points in the orange shaded region were compatible with white noise and not considered for the fit. In light purple we also show the NANOGrav 11-yr sensitivity curve from [327]. In solid lines we show the allowed slopes within the 1- $\sigma$ contours. In blue and purple we respectively show the upper and lower limits on the slope, $k ^ { 1 / 2 }$ and $k ^ { - 3 / 2 }$ . In magenta we give the approximate best fit for the data, which is a scale invariant spectrum.

The NANOGrav collaboration reported a common process signal in the time residuals of the frequencies of pulsars [18]. While no quadrupolar nature of the signal has been found, it is interesting to consider the possibility that the signal measured is in fact the SGWB of induced GWs. The main features of the reported spectrum [18], in cosmologists terms, are that it has an amplitude of $\Omega _ { \mathrm { G W } , 0 } h ^ { 2 } \sim 1 0 ^ { - 9 }$ at a frequency of $2 \times 1 0 ^ { - 9 } \mathrm { H z }$ and a spectral index, that is $\Omega _ { \mathrm { G W } , 0 } \propto k ^ { n }$ , that ranges from $n \sim 1 / 2$ to $n \sim - 3 / 2$ within the 1- $\sigma$ bounds. This means that the NANOGrav data seems to prefer a rather flat GW spectrum. This is illustrated in Fig. 9. Using the very rough estimate of Sec. 2, that is $\Omega _ { \mathrm { G W } , 0 } h ^ { 2 } \sim 1 0 ^ { - 6 } \mathcal { P } _ { \mathcal { R } } ^ { 2 }$ , we find that if the peak of the induced GW spectrum lies around $f \sim 2 \times 1 0 ^ { - 9 } \mathrm { { H z } }$ then the amplitude of primordial fluctuations that sourced such induced GWs is about $\mathcal P _ { \mathcal R } \sim O ( 1 0 ^ { - 2 } )$ . Such amplitude of primordial fluctuations is right at the value when PBH formation is interesting, and their masses are in the LIGO window.

The main complication is that the NANOGrav GW spectrum is rather flat and the induced GWs from a sharp peak are very peaked and decay as $k ^ { 3 }$ in the IR. This means that there are two possibilities: either the GWs were induced by a broad peak in the primordial spectrum (including a flat spectrum) [129–131, 133, 135] or the GWs were induced in non-radiation dominated universe with $w < 1 / 3$ [132]. Below we list the main results of these works:

– Ref. [129] found a negligible amount of PBH in LIGO region but the PBH could be the seeds of supermassive black holes.

– Ref. [131] found a larger amount of PBH in the LIGO band than [129] and also pointed out that the SGWB from unresolved mergers could detectable in the future by LISA and ET.

– Ref. [130] showed that the induced GWs from a flat primordial spectrum could explain all dark matter.

– Ref. [134] proposed a particular inflationary model with an axion-like curvaton which could explain the NANOGrav result as well as the LIGO events due to primordial non-gaussianities. Similar claims appear in Ref. [135] with a Higgs-like inflation with non-canonical kinetic terms.

– In a different direction, Refs. [132] and [133] studied the induced GWs from a peaked primordial spectrum in a non-radiation dominated universe. They both find that a soft equation of state seems to be preferred. In particular, Ref. [132] use the IR tail of the induced GW spectrum from a very peaked primordial spectrum (see Sec. 5) to fit the NANOGrav results. They found that the $1 \sigma$ contours on the spectral tilt translate to bounds for the equation state parameter as $- 0 . 1 < w < 0 . 0 5$ .

– Ref. [81] uses the UV tail of the induced GW spectrum from a broken power-law primordial spectrum. They concluded that the NANOGrav results imply a small non-gaussianity parameter $f _ { N L } < 0 . 7$ .

It is important to note that the induced GWs are not the only explanations of the NANOGrav results. For example, among many others, possible candidates are cosmic strings [328–331] and first order phase transitions [332–339]. Within the next decades, we expect to have more information from PTA experiments. We also expect the GW detector LISA to launch. In order to distinguish these candidates to the NANOGrav data, we will need better resolution for a better Bayesian analysis [336] but crucially we will need other discriminators of cosmic GWs. In the case of induced GWs, if some of the LIGO binary black hole mergers are found to be PBHs, the NANOGrav signal would have a strong case to be induced GWs.

# 10 Summary of main formulas

We dedicate this section to recollect the main formulas scattered around the review and present them so that they are ready for use. We first give the GW spectrum measured today $\Omega _ { \mathrm { G W } , 0 }$ in terms of the spectral density of GWs at a pivot scale $\Omega _ { \mathrm { G W , r h } }$ . The subscript “rh” stands for reheating and refers to the time of instantaneous transition to the standard radiation dominated era. In the case where GWs are induced during radiation domination, the pivot time “rh” refers to the time when induced GWs of given wavenumber $k$ are sufficiently inside the cosmological horizon to be treated as a radiation fluid in an expanding universe. With these clarifications, we can use the results of Secs. 4 and 5 to write

$$
\Omega _ { \mathrm { G W } , 0 } h ^ { 2 } = 1 . 6 2 \times 1 0 ^ { - 5 } \left( \frac { \Omega _ { r , 0 } h ^ { 2 } } { 4 . 1 8 \times 1 0 ^ { - 5 } } \right) \left( \frac { g _ { * } ( T _ { \mathrm { r h } } ) } { 1 0 6 . 7 5 } \right) \left( \frac { g _ { * s } ( T _ { \mathrm { r h } } ) } { 1 0 6 . 7 5 } \right) ^ { - 4 / 3 } \Omega _ { \mathrm { G W , r h } } .
$$

We give the detailed expression of $\Omega _ { \mathrm { G W , r h } }$ for a general equation of state in Sec. 10.1 and for the particular case of a dust universe with an instantaneous transition to radiation domination in Sec. 10.2.

# 10.1 General equation of state

We studied in the detail the derivation of $\Omega _ { \mathrm { G W , r h } }$ for general expansion histories in Sec. 4. The main approximations used are the following: $( i )$ there is an epoch of constant $w$ and $c _ { s }$ after inflation, (ii) the peak (or plateau) in the primordial spectrum enters the horizon during such era and $( i i i )$ the transition to radiation domination is instantaneous. Note that in the case of standard radiation domination these assumptions are unnecessary. The presence of a transition to radiation domination introduces another relevant scale $k _ { \mathrm { r h } }$ , which is the last comoving scale that entered the horizon at the transition. The GW spectrum for scales $k \gg k _ { \mathrm { r h } }$ takes a general form given by

$$
\Omega _ { \mathrm { G W , r h } } = \left( \frac { k } { k _ { \mathrm { r h } } } \right) ^ { - 2 b } \int _ { 0 } ^ { \infty } d v \int _ { | 1 - v | } ^ { 1 + v } d u T ( u , v , b , c _ { s } ) \mathcal { P } _ { \mathcal { R } } ( k u ) \mathcal { P } _ { \mathcal { R } } ( k v ) ,
$$

where we defined the transfer function as

$$
\begin{array} { l } { { \displaystyle { \mathcal T } ( u , v , b , c _ { s } ) = \mathcal N ( b , c _ { s } ) \left( \frac { 4 v ^ { 2 } - ( 1 - u ^ { 2 } + v ^ { 2 } ) ^ { 2 } } { 4 u ^ { 2 } v ^ { 2 } } \right) ^ { 2 } \left| 1 - y ^ { 2 } \right| ^ { b } } } \\ { { \displaystyle \qquad \times \left\{ \left( \mathsf { P } _ { b } ^ { - b } ( y ) + \frac { b + 2 } { b + 1 } \mathsf { P } _ { b + 2 } ^ { - b } ( y ) \right) ^ { 2 } \Theta [ c _ { s } ( u + v ) - 1 ] \right. } } \\ { { \displaystyle \qquad + \frac { 4 } { \pi ^ { 2 } } \left( \mathsf { Q } _ { b } ^ { - b } ( y ) + \frac { b + 2 } { b + 1 } \mathsf { Q } _ { b + 2 } ^ { - b } ( y ) \right) ^ { 2 } \Theta [ c _ { s } ( u + v ) - 1 ] \qquad } } \\ { { \displaystyle \qquad + \left. \frac { 4 } { \pi ^ { 2 } } \left( \mathsf { Q } _ { b } ^ { - b } ( - y ) + 2 \frac { b + 2 } { b + 1 } \mathsf { Q } _ { b + 2 } ^ { - b } ( - y ) \right) ^ { 2 } \Theta [ 1 - c _ { s } ( u + v ) ] \right\} , } } \end{array}
$$

and the numerical coefficient is given by

$$
\mathcal { N } ( b , c _ { s } ) \equiv \frac { 4 ^ { 2 b } } { 3 c _ { s } ^ { 4 } } \Gamma ^ { 4 } \left[ b + \textstyle \frac { 3 } { 2 } \right] \left( \frac { b + 2 } { 2 b + 3 } \right) ^ { 2 } ( 1 + b ) ^ { - 2 ( 1 + b ) } .
$$

In Eq. (10.3) we have introduced the following notation for convenience:

$$
b = \frac { 1 - 3 w } { 1 + 3 w } \quad \mathrm { a n d } \quad y = 1 - \frac { 1 - c _ { s } ^ { 2 } ( u - v ) ^ { 2 } } { 2 c _ { s } ^ { 2 } u v } .
$$

These equations are general enough for $k \gg k _ { \mathrm { r h } }$ that can be used for any shape of the primordial spectrum as long as the main feature, whether it is a peak or a plateau, enters during the $w =$ constant epoch. If the transition to radiation domination is gradual, then we only expect a change in the IR tail of the spectrum for modes which entered during the relevant stages of the transition. Following with the instantaneous transition, it is important to note that for $b > 1$ the IR tail has a red tilt and the spectrum for $k \ll k _ { \mathrm { r h } }$ becomes important. Nevertheless, a good approximation is to stop the spectrum at $k \sim k _ { \mathrm { r h } }$ and match it to the typical IR scaling in radiation domination, i.e., $\Omega _ { \mathrm { G W , r h } } \propto k ^ { 3 }$ . Details on the spectrum for $k \ll k _ { \mathrm { r h } }$ can be found in Sec. 4. It should be noted that (10.3) is not valid for ${ c _ { s } = 0 }$ . The case of ${ c _ { s } = 0 }$ is studied in detail in Sec. 6 and a quick estimate is presented below in Sec. 10.2.

The transfer function (10.3) is expressed in terms of Associated Legendre functions which are provided in App. H in terms of Hypergeometric functions. This general form, while very useful, might be a hindrance to a quick implementation. For this reason, we present below particular examples of the transfer function (10.3). We choose the cases where $b \in \mathbb { Z }$ and $b \in \mathbb { Z } + { \frac { 1 } { 2 } }$ since then the associated Legendre functions (and the Hypergeometric functions) reduce to polynomials. Note that only when $b \in \mathbb { Z }$ logarithmic terms appear. We will first check the standard case of radiation domination ( $b = 0$ , $w = 1 / 3$ ) and we will later turn to other situations. We give the transfer function for a stiff fluid $b = - 1 / 2$ ( $w = 1$ ), a soft fluid $b = 1 / 2$ ( $w = 1 / 9$ ), a pressureless fluid $b = 1$ ( $w = 0$ ) and negative equation of state fluid $b = 2$ ( $w = - 1 / 9$ ). We keep the sound speed $c _ { s }$ arbitrary. For an adiabatic perfect fluid, we have $c _ { s } ^ { 2 } = w$ and for a canonical scalar field $c _ { s } ^ { 2 } = 1$ .

# 10.1.1 Radiation domination

The transfer function (10.3) for $b = 0$ ( $w = 1 / 3$ ) reads

$$
\begin{array} { c } { { \displaystyle { \mathcal { T } _ { R D } ( u , v , c _ { s } , w = 1 / 3 ) = \frac { y ^ { 2 } } { 3 c _ { s } ^ { 4 } } \left( \frac { 4 v ^ { 2 } - ( 1 - u ^ { 2 } + v ^ { 2 } ) ^ { 2 } } { 4 u ^ { 2 } v ^ { 2 } } \right) ^ { 2 } } } } \\ { { \displaystyle { \phantom { \frac { y ^ { 2 } } { \sqrt { 3 } } y ^ { 2 } } } \times \left\{ \frac { \pi ^ { 2 } } { 4 } y ^ { 2 } \Theta [ c _ { s } ( u + v ) - 1 ] + \left( 1 - \frac { 1 } { 2 } y \ln \left| \frac { 1 + y } { 1 - y } \right| \right) ^ { 2 } \right\} , } } \end{array}
$$

where we kept the variable $y$ as it simplifies considerably the expressions. This recovers the result of Kohri and Terada [63] after taking into account all numerical factors in (2.7).

# 10.1.2 Stiff fluid (kinetic) domination

Another notable case of interest is a stiff fluid with $b = - 1 / 2$ ( $w = 1$ ). This is for example typical of quintessential inflation scenarios [340–343]. For a kinetic dominated period, the transfer function (10.3) is given by

$$
\begin{array} { l } { \displaystyle \mathcal { T } _ { K D } ( u , v , c _ { s } , w = 1 ) = \frac { 4 } { 3 \pi c _ { s } ^ { 4 } | 1 - y ^ { 2 } | } \left( \frac { 4 v ^ { 2 } - ( 1 - u ^ { 2 } + v ^ { 2 } ) ^ { 2 } } { 4 u ^ { 2 } v ^ { 2 } } \right) ^ { 2 } } \\ { \displaystyle \times \left. \left( 1 + 3 y ^ { 2 } \right) \Theta [ c _ { s } ( u + v ) - 1 ] + \left( 1 - 3 y ^ { 2 } + 3 y \sqrt { | 1 - y ^ { 2 } | } \right) ^ { 2 } \Theta [ 1 - c _ { s } ( u + v ) ] \right. . } \end{array}
$$

This coincides with the formulas derived in Ref. [64, 74]. It has also been studied numerically in Ref. [75].

# 10.1.3 Soft fluid domination

The next case is that of a soft fluid with $b = 1 / 2$ ( $w = 1 / 9$ ). This could be due to a scalar field rolling down an exponential potential. After some algebra, we find that

$$
\begin{array} { r l } { \mathcal { T } ( u , v , c _ { s } , w = 1 / 9 ) = \frac { 2 ^ { 8 } } { 3 ^ { 8 } \pi c _ { s } ^ { 4 } } \left( \frac { 4 v ^ { 2 } - ( 1 - u ^ { 2 } + v ^ { 2 } ) ^ { 2 } } { 4 u ^ { 2 } v ^ { 2 } } \right) ^ { 2 } } & { } \\ { \times \left\{ \vphantom { \frac { 2 ^ { 8 } } { 1 6 } } \left( 4 + 4 5 y ^ { 2 } \right) \Theta [ c _ { s } ( u + v ) - 1 ] \right. } & { } \\ & { \left. + \vphantom { \frac { 2 ^ { 8 } } { 1 6 } } \left( y ( 3 - 1 0 y ^ { 2 } ) + ( 2 + 1 0 y ^ { 2 } ) \sqrt { \left| 1 - y ^ { 2 } \right| } \right) ^ { 2 } \Theta [ 1 - c _ { s } ( u + v ) ] \vphantom { \frac { 2 ^ { 8 } } { 1 6 } } \right\} . } \end{array}
$$

# 10.1.4 Pressure-less fluid domination

We turn now to the case of a pressure-less fluid with $b = 1$ ( $w = 0$ ). Note that this is not dust in the sense that $c _ { s } \neq 0$ . So that even though the fluid has no pressure, perturbations still propagate at a finite speed. This is the case of a scalar field rolling down an exponential potential and might also be close to the coherent oscillations of a scalar field around the bottom of the potential [344]. The kernel for $b = 1$ is given by

$$
\begin{array} { c } { { \displaystyle { \mathcal { T } ( u , v , c _ { s } , w = 0 ) = \frac { 3 ^ { 3 } 5 ^ { 2 } } { 2 ^ { 1 4 } c _ { s } ^ { 4 } } \left( \frac { 4 v ^ { 2 } - ( 1 - u ^ { 2 } + v ^ { 2 } ) ^ { 2 } } { 4 u ^ { 2 } v ^ { 2 } } \right) ^ { 2 } } } } \\ { { \displaystyle { \qquad \times \left\{ \frac { \pi ^ { 2 } } { 4 } ( 1 - y ^ { 2 } ) ^ { 2 } ( 1 + 3 y ^ { 2 } ) ^ { 2 } \Theta [ c _ { s } ( u + v ) - 1 ] \right. } } }  \\ { { \displaystyle { \qquad + \left. \left( y ( 1 - 3 y ^ { 2 } ) - \frac { 1 } { 2 } ( 1 + 2 y ^ { 2 } - 3 y ^ { 4 } ) \ln \left| \frac { 1 + y } { 1 - y } \right| \right) ^ { 2 } \right\} . } } } \end{array}
$$

# 10.1.5 Negative EoS fluid domination

The last case we are interested in is a negative EoS parameter. When $- 1 / 3 < w < 0$ the universe is decelerating very slowly which yields to interesting slopes in the IR tail. For convenience we present the kernel for the case $b = 2$ ( $w = - 1 / 9$ ), which reads

$$
\begin{array} { c l c r } { \displaystyle { \mathcal { T } ( u , v , c _ { s } , w = - 1 / 9 ) = \frac { 5 ^ { 2 } 7 ^ { 2 } } { 2 ^ { 8 } 3 ^ { 9 } c _ { s } ^ { 4 } } \left( \frac { 4 v ^ { 2 } - ( 1 - u ^ { 2 } + v ^ { 2 } ) ^ { 2 } } { 4 u ^ { 2 } v ^ { 2 } } \right) ^ { 2 } } } \\ { \displaystyle { \qquad \times \left\{ \frac { 2 2 5 \pi ^ { 2 } } { 4 } ( 1 - y ^ { 2 } ) ^ { 2 } ( 1 + y ^ { 2 } - 2 y ^ { 4 } ) ^ { 2 } \Theta [ c _ { s } ( u + v ) - 1 ] \qquad } } \\ { \displaystyle { \qquad + \left( y ( 9 + 3 5 y ^ { 2 } - 3 0 y ^ { 4 } ) + \frac { 1 5 } { 2 } ( 1 - 3 y ^ { 4 } + 2 y ^ { 6 } ) \ln \left| \frac { 1 + y } { 1 - y } \right| \right) ^ { 2 } \right\} . } } \end{array}
$$

# 10.2 Dust domination

Here we provide a useful order of magnitude estimate for the following situation: $( i )$ the universe is dominated by dust $w = c _ { s } ^ { 2 } = 0$ when induced GWs are generated, $( i i )$ the transition to radiation domination is instantaneous and $( i i i )$ the spectrum of fluctuations for the Newtonian potential $\Phi$

is given by

$$
\mathcal { P } _ { \Phi } = \mathcal { A } _ { \Phi } \left( \frac { k } { k _ { \mathrm { U V } } } \right) ^ { - n } \Theta ( k _ { U V } - k ) ,
$$

where $n < 2$ . This power spectrum includes a power-law generated during inflation and the case of PBH density fluctuations. The details of the derivation can be found in Sec. 6. With these assumptions, the spectrum of induced GWs is approximately given by

$$
\Omega _ { \mathrm { G W s , r h } } ( k \sim k _ { \mathrm { U V } } ) \approx \Omega _ { \mathrm { G W s } } ^ { \mathrm { p e a k } } \left( \frac { k _ { \mathrm { U V } } } { k _ { \mathrm { r h } } } \right) ^ { 7 - 2 n } \Theta ( k _ { \mathrm { U V } } - k ) ,
$$

where the amplitude of the peak reads

$$
\Omega _ { \mathrm { G W s } } ^ { \mathrm { p e a k } } \approx \frac { \pi } { 9 2 1 6 \sqrt { 3 } } \left( \frac { 4 } { 3 } \right) ^ { n } \left( \frac { k _ { \mathrm { U V } } } { k _ { \mathrm { r h } } } \right) ^ { 7 } \mathcal { A } _ { \Phi } ^ { 2 } .
$$

We can then use Eq. (6.19) together with (10.1) to estimate the induced GW spectrum today. Note that if the UV cut-off $k _ { \mathrm { U V } }$ is at very small scales, i.e., $k _ { \mathrm { U V } } \gg k _ { \mathrm { r h } }$ , the amplitude of induced GW is very much enhanced and strong constraints apply. It is important to clarify that if $k _ { \mathrm { U V } }$ is very large (larger than $k _ { N L }$ in Eq. (6.1)), some density fluctuations would enter the non-linear regime. Thus, the above result must be considered as a rough estimate. For detailed discussion we refer the reader to Sec. 6.

# 11 Conclusions

Gravitational waves induced by primordial fluctuations, so-called induced GWs, have been shown to be a very promising tool to complete our picture of inflation and the early universe. Although this effect was first pointed out fifty years ago, induced GWs together with primordial black holes are receiving serious attention since the first GW detection by LIGO [61]. They are even more interesting after the NANOGrav collaboration recently reported a possible stochastic GW signal [18]. Within the next couple of decades, LISA will launch, and we will have a new data on stochastic backgrounds of gravitational waves in a wide frequency range. Even in the worst-case scenario, where no conclusive induced GW signal is found, we will obtain new constraints on the physics of inflation and the early universe in completely unexplored regimes.

The field of cosmology with induced GWs is relatively new and still developing. In this review we have focused on the current analytical techniques and estimates to compute the induced GW spectrum. We believe they will be most useful in analysing future SGWB data. We have not dwelled into the details of PBH formation nor on the observational forecasts for future GW detectors, both of which deserve a separate review. In the next years there will be more studies on induced GWs; new and better analytical and numerical results might be developed. Until then, particularly interesting and important directions are: $( i )$ the impact of primordial non-gaussianities, not necessarily in the local shape, $( i i )$ possible discriminators of induced GWs to distinguish them from other sources, $( i i i )$ the GW detector response at second order and ( $_ { i v }$ ) GWs from the non-linear regime in an early matter dominated stage. We hope this review will be useful to the next advancements in the cosmology of induced GWs.

# Funding

G.D. as a Fellini fellow was supported by the European Union’s Horizon 2020 research and innovation programme under the Marie Skłodowska-Curie grant agreement No 754496.

# Acknowledgments

I have benefited from many helpful and insightful discussions and collaborations over the years while carrying out the works in which this review is based. I would like to thank Misao Sasaki for his constant support and encouragement. I thank Jinn-Ouk Gong and Shi Pi for awaking my interest on induced GWs some years ago. I also thank Sabino Matarrese for insightful discussions and for pointing out the first papers on induced GWs. I have also learned a lot from discussions with Vicente Atal, Nicola Bartolo, Albert Escrivá, Joseph Fedrow, Jacopo Fumagalli, Jaume Garriga, Cristiano Germani, Marc Kamionkowski, David Langlois, Chunshan Lin, Atsushi Naruko, Sébastien Renaux-Petel, Javier Rubio, Volodymyr Takhistov, Vicent Vennin and Lukas T. Witkowski. I acknowledge very helpful correspondence with Jai-chan Hwang, Keisuke Inomata, Kazunori Kohri, Caner Unal and Zach Weiner. Last but not least, I would like to thank D. Rojas and A. D. Rojas for their constant support.

# A Useful formulas and numerical values

In this appendix we present the numerical values and formulas used to derive the parameters in the main text. First, we used the following values from the Planck results [2]: $k _ { \mathrm { e q } } \approx 0 . 0 1 0 4 \mathrm { M p c } ^ { - 1 }$ , $z _ { \mathrm { e q } } \approx 3 4 0 0$ , $T _ { 0 } = 2 . 7 2 5 5 \mathrm { K }$ . We also used the value for the reduced Planck mass $M _ { \mathrm { p l } } \approx 4 . 2 3 5 \times$ $1 0 ^ { 1 8 } \mathrm { G e V \approx 4 . 3 4 \times 1 0 ^ { - 6 } g }$ and the solar mass $M _ { \odot } \approx 2 \times 1 0 ^ { 3 3 } \mathrm { g }$ . A useful relation between units (in the Planck units) is the following:

$$
1 \mathrm { K } \approx 8 . 6 2 \times 1 0 ^ { - 5 } \mathrm { e V } \approx 4 . 3 4 \mathrm { c m } ^ { - 1 } \approx 1 . 3 1 \times 1 0 ^ { 1 1 } \mathrm { H z }
$$

On the effective degrees of freedom, we used that for radiation at temperature $T$ the energy density is given by

$$
\rho = \frac { \pi ^ { 2 } } { 3 0 } g _ { * } ( T ) T ^ { 4 } \quad \mathrm { w i t h } \quad g _ { * } ( T ) = \sum g _ { b } + \frac { 7 } { 8 } \sum g _ { f } ,
$$

where $g _ { b }$ and $g _ { f }$ are respectively the degrees of freedom of bosons and fermions. The entropy can then be calculated by

$$
s = \frac { 2 \pi ^ { 2 } } { 4 5 } g _ { * s } ( T ) T ^ { 3 } .
$$

The different values of $g _ { * }$ and $g _ { * s }$ in the standard model are review in Ref. [293]. At very high temperatures, i.e., $T \gg 1 0 0 \mathrm { G e V }$ one has $g _ { * } \approx g _ { * s } \approx 1 0 6 . 7 5$ . At the time of matter-radiation equality and at present we took $g _ { * } ( T _ { \mathrm { e q } } ) \approx g _ { * } ( T _ { 0 } ) \approx 3 . 3 8$ and $g _ { * s } ( T _ { \mathrm { e q } } ) \approx g _ { * s } ( T _ { 0 } ) \approx 3 . 9 4$ .

The Hubble parameter in the radiation dominated universe can be related by the Friedmann equations to the temperature as

$$
H = \frac { \pi } { 3 \sqrt { 1 0 } M _ { \mathrm { p l } } } g _ { * } ^ { 1 / 2 } ( T ) T ^ { 2 } ,
$$

Another important relation is that since the entropy is conserved, which in an expanding universe means $s \propto a ^ { - 3 }$ , there is a direct relation between the scale factor and the temperature. We have that

$$
\frac { a } { a _ { \star } } = \frac { T _ { \star } } { T } \left( \frac { g _ { * s } ( T _ { \star } ) } { g _ { * s } ( T ) } \right) ^ { 1 / 3 } .
$$

More detailed explanations can be found, e.g., in Baumann’s lecture notes http://cosmology. amsterdam/education/cosmology/

# B Green’s function method

In this appendix we present the Green’s method to find particular solutions to a differential equation where the homogeneous solutions are known. In the main text we found that the induced GWs have the following equations of motion:

$$
h _ { \mathbf { k } , \lambda } ^ { \prime \prime } + 2 \mathcal { H } h _ { \mathbf { k } , \lambda } ^ { \prime } + k ^ { 2 } h _ { \mathbf { k } , \lambda } = \mathcal { S } _ { \mathbf { k } , \lambda } .
$$

Assuming that we know the two homogeneous solutions, say $h _ { 1 }$ and $h _ { 2 }$ , we can check that the following Green’s function,

$$
G ( \tau , \tilde { \tau } ) = \frac { 1 } { W ( h _ { 1 } , h _ { 2 } , \tilde { \tau } ) } \left( h _ { 1 } ( \tau ) h _ { 2 } ( \tilde { \tau } ) - h _ { 1 } ( \tilde { \tau } ) h _ { 2 } ( \tau ) \right) ,
$$

is a solution to

$$
G _ { { \bf k } , \lambda } ^ { \prime \prime } ( \tau , \tilde { \tau } ) + 2 \mathcal { H } G _ { { \bf k } , \lambda } ^ { \prime } ( \tau , \tilde { \tau } ) + k ^ { 2 } G _ { { \bf k } , \lambda } ( \tau , \tilde { \tau } ) = \delta ( \tau - \tilde { \tau } ) .
$$

In Eq. (B.2) we have defined the Wronskian as

$$
W ( h _ { 1 } , h _ { 2 } , \tilde { \tau } ) = h _ { 1 } ^ { \prime } ( \tilde { \tau } ) h _ { 2 } ( \tilde { \tau } ) - h _ { 1 } ( \tilde { \tau } ) h _ { 2 } ^ { \prime } ( \tilde { \tau } ) .
$$

Then with the Green’s function (B.2) we have that the particular solution to $h _ { \mathbf { k } , \lambda }$ with initial conditions $h _ { \mathbf { k } , \lambda } ( \tau _ { i } ) = h _ { \mathbf { k } , \lambda } ^ { \prime } ( \tau _ { i } ) = 0$ is given by

$$
h _ { { \bf k } , \lambda } = \int _ { \tau _ { i } } ^ { \tau } d \tilde { \tau } G ( \tau , \tilde { \tau } ) S _ { { \bf k } , \lambda } ( \tilde { \tau } ) .
$$

# C ADM formalism

In this appendix we briefly give the ADM or (3+1)-decomposition of the Einstein-Hilbert action, that is

$$
S = \int d ^ { 4 } x \sqrt { - g } \frac { M _ { p l } ^ { 2 } } { 2 } R .
$$

More details can be found in Ref. [223]. First, the line element is parametrised by

$$
d s ^ { 2 } = - N ^ { 2 } d t ^ { 2 } + h _ { i j } \left( d x ^ { i } + N ^ { i } d t \right) \left( d x ^ { j } + N ^ { j } d t \right) ,
$$

where $N$ is the lapse and $N ^ { i }$ is the shift vector and describe the foliation of our spacetime. In this decomposition the Einstein-Hilbert action, after integrating out boundary terms, is given by

$$
S = \int d ^ { 3 } x d t N \sqrt { h } \frac { M _ { p l } ^ { 2 } } { 2 } \left( R ^ { ( 3 ) } [ h ] + K _ { i j } K ^ { i j } - K ^ { 2 } \right) ,
$$

where

$$
K _ { i j } \equiv \frac { 1 } { 2 N } \left( \dot { h } _ { i j } - D _ { i } N _ { j } - D _ { j } N _ { i } \right) ,
$$

is the extrinsic curvature, $K = h ^ { i j } K _ { i j }$ and $D _ { i }$ is the covariant derivative of $h _ { i j }$ . Explicit expressions of the metric, its inverse and all the Christoffel symbols can be found in Appendix A of Ref. [345].

# D Fourier conventions and polarization tensors

In this appendix we specify the conventions used for Fourier transforms and the polarization tensors. First, we define the Fourier transform of a scalar mode as

$$
\Phi ( \tau , { \bf k } ) = \int \frac { d ^ { 3 } k } { ( 2 \pi ) ^ { 3 } } \Phi _ { \bf k } ( \tau ) e ^ { i { \bf k } { \bf x } } ,
$$

and of a tensor mode as

$$
h _ { i j } ( \tau , { \bf k } ) = \sum _ { \lambda } \int \frac { d ^ { 3 } k } { ( 2 \pi ) ^ { 3 } } e _ { i j } ^ { \lambda } ( { \bf k } ) h _ { { \bf k } , \lambda } ( \tau ) e ^ { i { \bf k } { \bf x } } ,
$$

where $\lambda$ are the polarization, e.g., $+ \mathrm { a n d } \times$ , and $e _ { i j } ^ { \lambda } ( \mathbf { k } )$ are the polarization tensors. Such expansion is valid for real polarization tensors. Then, reality conditions $2 3$ of $h _ { i j }$ imply [28] $e _ { i j } ^ { \lambda } ( { \bf { k } } ) = e _ { i j } ^ { \lambda } ( - { \bf { k } } )$ and $h _ { \mathbf { k } , \lambda } ^ { * } = h _ { - \mathbf { k } , \lambda }$ . We define the polarization tensors in terms of polarization vectors as follows:

$$
\begin{array} { l } { { e _ { i j } ^ { + } ( { \bf k } ) = \displaystyle \frac { 1 } { \sqrt { 2 } } \left[ e _ { i } ( { \bf k } ) e _ { j } ( { \bf k } ) - { \bar { e } } _ { i } ( { \bf k } ) { \bar { e } } _ { j } ( { \bf k } ) \right] , } } \\ { { e _ { i j } ^ { \times } ( { \bf k } ) = \displaystyle \frac { 1 } { \sqrt { 2 } } \left[ e _ { i } ( { \bf k } ) { \bar { e } } _ { j } ( { \bf k } ) + { \bar { e } } _ { i } ( { \bf k } ) e _ { j } ( { \bf k } ) \right] . } } \end{array}
$$

Then, using that $e _ { i } ( { \bf k } ) k ^ { \imath } = \bar { e } _ { i } ( { \bf k } ) k ^ { \imath } = 0$ and $e _ { i } ( { \bf k } ) e ^ { \imath } ( { \bf k } ) = \bar { e } _ { i } ( { \bf k } ) \bar { e } ^ { \imath } ( { \bf k } ) = 1$ , we arrive at the usual properties of the polarization tensors, namely

$$
\begin{array} { l } { { e _ { i j } ^ { + } ( { \bf k } ) e ^ { + i j } ( { \bf k } ) = 1 \quad , \quad e _ { i j } ^ { \times } ( { \bf k } ) e ^ { \times i j } ( { \bf k } ) = 1 \quad , \quad e _ { i j } ^ { + } ( { \bf k } ) e ^ { \times i j } ( { \bf k } ) = 0 , } } \\ { { \delta _ { i j } e ^ { + i j } ( { \bf k } ) = \delta _ { i j } e ^ { \times i j } ( { \bf k } ) = k _ { i } e ^ { + i j } ( { \bf k } ) = k _ { i } e ^ { \times i j } ( { \bf k } ) = 0 . } } \end{array}
$$

# D.1 Spherical parametrisation

When calculating the projection of polarization tensors with the scalar momenta we choose spherical coordinates for convenience. Then, one can write in general that the wavenumber of a tensor mode is given by

$$
\mathbf { k } = k ( \sin \theta _ { k } \cos \varphi _ { k } , \sin \theta _ { k } \sin \varphi _ { k } , \cos \theta _ { k } ) ,
$$

where $\theta _ { k }$ and $\varphi _ { k }$ respectively are the polar and azimuthal angles. With this choice, a pair of orthonormal polarization vectors are

$$
\begin{array} { r l } & { \mathbf { e } ( \mathbf { k } ) = \left( \cos { \theta _ { k } } \cos { \varphi _ { k } } , \cos { \theta _ { k } } \sin { \varphi _ { k } } , - \sin { \theta _ { k } } \right) , } \\ & { { \bar { \mathbf { e } } } ( \mathbf { k } ) = \left( - \sin { \varphi _ { k } } , \cos { \varphi _ { k } } , 0 \right) . } \end{array}
$$

We parametrize two scalar momenta $\mathbf { q }$ and $\mathbf { l }$ as

$$
\begin{array} { r } { \mathbf { q } = q ( \sin \theta _ { q } \cos \varphi _ { q } , \sin \theta _ { q } \sin \varphi _ { q } , \cos \theta _ { q } ) , } \end{array}
$$

and

$$
\begin{array} { r } { 1 = l ( \sin \theta _ { l } \cos \varphi _ { l } , \sin \theta _ { l } \sin \varphi _ { l } , \cos \theta _ { l } ) . } \end{array}
$$

In the calculations of the tensor spectrum of Sec. 3.1 we considered general local primordial non-gaussianity. In this case, due to the symmetry between l and $\mathbf { q }$ , we find most convenient to choose $\mathbf { k }$ in the $\mathbf { Z }$ -axis, namely we set

$$
\theta _ { k } = 0 \quad , \quad \varphi _ { k } = 0 .
$$

Then one has that

$$
{ \begin{array} { r l } & { | \mathbf { k } - \mathbf { q } | ^ { 2 } = k ^ { 2 } + q ^ { 2 } - 2 k q \cos \theta _ { k } , } \\ & { | \mathbf { k } - \mathbf { l } | ^ { 2 } = k ^ { 2 } + l ^ { 2 } - 2 k l \cos \theta _ { l } , } \\ & { | \mathbf { q } - \mathbf { l } | ^ { 2 } = q ^ { 2 } + l ^ { 2 } - 2 l q \left( \cos \theta _ { q } \cos \theta _ { l } + \cos ( \varphi _ { q } - \varphi _ { l } ) \sin \theta _ { q } \sin \theta _ { l } \right) . } \end{array} }
$$

Note that the azimuthal dependence is only in $| \mathbf { q - } \mathbf { l } |$ . The projections of $\mathbf { q }$ and l with the polarization tensors then read

$$
\begin{array} { l c r } { { e _ { i j } ^ { + } ( { \bf k } ) q ^ { i } q ^ { j } = \displaystyle \frac { 1 } { \sqrt { 2 } } q ^ { 2 } \sin ^ { 2 } \theta _ { k } \cos ( 2 \varphi _ { q } ) \quad , } } & { { e _ { i j } ^ { \times } ( { \bf k } ) q ^ { i } q ^ { j } = \displaystyle \frac { 1 } { \sqrt { 2 } } q ^ { 2 } \sin ^ { 2 } \theta _ { k } \sin ( 2 \varphi _ { q } ) } } \\ { { e _ { i j } ^ { + } ( { \bf k } ) l ^ { i } l ^ { j } = \displaystyle \frac { 1 } { \sqrt { 2 } } l ^ { 2 } \sin ^ { 2 } \theta _ { l } \cos ( 2 \varphi _ { l } ) \ : , } } & { { e _ { i j } ^ { \times } ( { \bf k } ) l ^ { i } l ^ { j } = \displaystyle \frac { 1 } { \sqrt { 2 } } l ^ { 2 } \sin ^ { 2 } \theta _ { l } \sin ( 2 \varphi _ { l } ) \ : . } } \end{array}
$$

Lastly, what we need to derive the induced GW spectrum are the following results:

$$
\left( e _ { i j } ^ { + } ( { \bf k } ) q ^ { i } q ^ { j } \right) ^ { 2 } + \left( e _ { i j } ^ { \times } ( { \bf k } ) q ^ { i } q ^ { j } \right) ^ { 2 } = \frac { q ^ { 4 } } { 2 } \sin ^ { 4 } { \theta _ { k } } ,
$$

and

$$
e _ { i j } ^ { + } ( { \bf k } ) q ^ { i } q ^ { j } e _ { i j } ^ { + } ( { \bf k } ) l ^ { i } l ^ { j } + e _ { i j } ^ { \times } ( { \bf k } ) q ^ { i } q ^ { j } e _ { i j } ^ { \times } ( { \bf k } ) l ^ { i } l ^ { j } = \frac { q ^ { 2 } l ^ { 2 } } { 2 } \sin ^ { 2 } \theta _ { k } \sin ^ { 2 } \theta _ { l } \cos ( 2 ( \varphi _ { q } - \varphi _ { l } ) ) .
$$

# E Formulas in a general gauge

In this appendix we present the explicit expressions for Einstein equations in a perturbed flat FLRW universe filled with a perfect fluid. We present the results in a general gauge. The convention for the perturbed metric is given in Eq. (7.1) and the energy momentum tensor in Eq. (3.11).

# E.1 Background

At zeroth order in perturbation theory, we have the two Friedmann equations and energy conservation equations. These are respectively given by

$$
\begin{array} { r } { 3 M _ { \mathrm { p l } } ^ { 2 } \mathcal { H } ^ { 2 } = a ^ { 2 } \rho , } \\ { M _ { \mathrm { p l } } ^ { 2 } \left( \mathcal { H } ^ { 2 } + 2 \mathcal { H } ^ { \prime } \right) = - a ^ { 2 } P , } \end{array}
$$

and

$$
\rho ^ { \prime } + 3 \mathcal { H } ( \rho + P ) = 0 .
$$

# E.2 First order

At first order we find that the Hamiltonian and momentum constraints yield [164]

$$
\begin{array} { r } { 6 \mathcal { H } ( \phi ^ { \prime } - \mathcal { H } \alpha ) + 2 \Delta ( \phi + \mathcal { H } \sigma ) = M _ { \mathrm { p l } } ^ { 2 } a ^ { 2 } \delta \rho , } \\ { 2 \phi ^ { \prime } - 2 \mathcal { H } \alpha = M _ { \mathrm { p l } } ^ { 2 } a ^ { 2 } ( \rho + P ) ( v + \beta ) . } \end{array}
$$

The remaining Einstein equations are

$$
\begin{array} { r } { 2 \phi ^ { \prime \prime } + 4 \mathcal { H } \phi ^ { \prime } - 2 \mathcal { H } \alpha ^ { \prime } - ( 4 \mathcal { H } ^ { \prime } + 2 \mathcal { H } ^ { 2 } ) \alpha = - M _ { \mathrm { p l } } ^ { 2 } a ^ { 2 } \delta P , } \\ { \sigma ^ { \prime } + 2 \mathcal { H } \sigma + \phi + \alpha = 0 . } \end{array}
$$

We assumed that there is no anisotropic stress for matter, and we defined

$$
\sigma \equiv \beta - E ^ { \prime } ,
$$

which corresponds to the scalar shear of the metric [164]. The energy and momentum conservation equations can be derived from the Einstein equations.

# E.3 Second order

Here we only present the second order equations for the tensor modes with a scalar squared source. In the source terms there is in general vector and tensor components as well although they are often subdominant [151]. After a long algebra, the equations of motion for tensor modes are given by [150]

$$
( \hat { D } _ { \tau } - \Delta ) h _ { i j } = \widehat { T T } _ { i j } ^ { a b } S _ { a b } ,
$$

where Dˆτ ≡ a−2∂τ (a2∂τ ), ∆ ≡ δij∂i∂j is the flat 3-dimensional Laplacian. T Tdabij is the transversetraceless projector which is given by

$$
\widehat { T T } _ { i j } { } ^ { a b } \equiv \left( \delta _ { i } ^ { ( a } - \partial _ { i } \partial ^ { ( a } \Delta ^ { - 1 } \right) \left( \delta _ { j } ^ { b ) } - \partial _ { j } \partial ^ { b ) } \Delta ^ { - 1 } \right) - { \frac { 1 } { 2 } } \left( \delta _ { i j } - \partial _ { i } \partial _ { j } \Delta ^ { - 1 } \right) \left( \delta ^ { a b } - \partial ^ { a } \partial ^ { b } \Delta ^ { - 1 } \right) ,
$$

where the parenthesis in the indexes denote normalised symmetrisation. The source term in a general gauge can be written as

$$
S _ { a b } = 4 \partial _ { a } \Phi \partial _ { b } \Phi + 2 a ^ { 2 } \left( \rho + p \right) \partial _ { a } V \partial _ { b } V - \left( \hat { D } _ { \tau } - \Delta \right) \left[ \partial _ { a } \sigma \partial _ { b } \sigma + \partial _ { a } \partial ^ { k } E \partial _ { k } \partial _ { b } E \right] ,
$$

where we defined for convenience

$$
\Phi \equiv \phi - \frac { 1 } { 3 } \Delta E + \sigma \quad , \quad V \equiv v + E ^ { \prime } .
$$

The source term (E.11) reduces to the result of Sec. 3.1 in the shear-free or Newtonian gauge, that is $\sigma = E = 0$ .

# F Bessel functions

In this appendix we write useful formulas and relations of the Bessel functions. First, the asymptotic expansion for small argument is given by

$$
J _ { \nu } ( x \ll 1 ) \approx x ^ { \nu } \frac { 2 ^ { - \nu } } { \Gamma [ 1 + \nu ] } + O ( x ^ { \nu + 1 } ) \quad , \quad Y _ { \nu } ( x \ll 1 ) \approx - \frac { 2 ^ { \nu } } { \pi } \Gamma [ \nu ] x ^ { - \nu } + O ( x ^ { - \nu + 1 } ) .
$$

For large arguments we have that the Bessel functions oscillate periodically as

$$
J _ { \nu } ( x \gg 1 ) \approx \sqrt { \frac { 2 } { \pi x } } \cos \left( x - \frac { \nu \pi } { 2 } - \frac { \pi } { 4 } \right) + O ( x ^ { - 1 } ) ,
$$

and

$$
Y _ { \nu } ( x \gg 1 ) \approx \sqrt { \frac { 2 } { \pi x } } \sin \left( x - \frac { \nu \pi } { 2 } - \frac { \pi } { 4 } \right) + O ( x ^ { - 1 } ) .
$$

Lastly, useful relations between derivative and Bessel functions of similar order are respectively given by

$$
\partial _ { x } J _ { \nu } \left( x \right) = J _ { \nu - 1 } \left( x \right) - ( \nu / x ) J _ { \nu } \left( x \right) ,
$$

and

$$
J _ { \nu - 1 } \left( x \right) + J _ { \nu + 1 } \left( x \right) = ( 2 \nu / x ) J _ { \nu } \left( x \right) .
$$

# G Integrals with two and three Bessel functions

In this appendix we give the expression for the integrals used in Sec. 4. Most of the formulae can be found in [233] and [346].

# G.1 Superhorizon approximation

The integrals 4.11 in the kernel 4.10 for the superhorizon approximation ( $x \ll 1$ ) of Sec. 4.3 involve an integral with two Bessel functions of the same order. Then, the relevant integrals necessary for Sec. 4.3 are

$$
\int d x x J _ { \mu } ^ { 2 } \left( a x \right) = \frac { 1 } { 2 } x ^ { 2 } \left( J _ { \mu } ^ { 2 } \left( a x \right) - J _ { \mu - 1 } \left( a x \right) J _ { \mu + 1 } ( a x ) \right) ,
$$

and

$$
\int d x x ^ { - 2 \mu + 1 } J _ { \mu } ^ { 2 } \left( a x \right) = \frac { x ^ { - 2 \mu + 2 } } { 2 ( 1 - 2 \mu ) } \left( J _ { \mu } ^ { 2 } \left( a x \right) + J _ { \mu - 1 } ^ { 2 } \left( a x \right) \right) .
$$

Using the above formulas it is straightforward to show that the integrals $4 . 1 1$ reduce after integration to

$$
\begin{array} { l } { \displaystyle \mathcal { I } _ { J } \approx \frac { 3 + 2 b } { 1 + b } \frac { 2 ^ { - b - 1 / 2 } } { \Gamma [ b + 3 / 2 ] } \frac { x } { \pi v } , } \\ { \displaystyle \mathcal { I } _ { Y } \approx \frac { 2 b + 3 } { b ( 1 + b ) c _ { s } \pi } \left( 2 ^ { b - 1 / 2 } \Gamma [ b + 1 / 2 ] \frac { x ^ { - 2 b } } { \pi v } - 2 ^ { - b - 3 / 2 } \frac { c _ { s } ^ { 2 b } } { \Gamma [ b + 3 / 2 ] } \frac { 1 + b + b ^ { 2 } } { 1 + b } \right) . } \end{array}
$$

# G.2 Subhorizon approximation

The integrals 4.11 in the kernel 4.10 for the subhorizon approximation ( $x \gg 1$ ) of Sec. 4.2 involve definite integral of three Bessel functions. The relevant integrals necessary for Sec. 4.2 can be found in Ref. [233]. Here we review their main results. On one hand, they find that for $| a - b | < c < a + b$ the integrals 4.11 read

$$
\begin{array} { l } { { \displaystyle \mathbb { Z } _ { J / Y } = \int _ { 0 } ^ { \infty } d \tilde { x } \tilde { x } ^ { 1 - \rho } \{ { { J _ { \rho } } ( c \tilde { x } ) } \} J _ { \nu } ( a \tilde { x } ) J _ { \nu } ( b \tilde { x } ) } } \\ { { \displaystyle \qquad = { \frac { 1 } { \pi } } \sqrt { \frac { 2 } { \pi } } { \frac { ( a b ) ^ { \rho - 1 } } { c ^ { \rho } } } ( \sin \varphi ) ^ { \rho - 1 / 2 } \{ { \frac { \pi } { 2 } } \mathsf { P } _ { \nu - 1 / 2 } ^ { - \rho + 1 / 2 } ( \cos \varphi ) \} } \ , \ }  \\  { \displaystyle \qquad = \mathrm { { Q } } _ { \nu - 1 / 2 } ^ { - \rho + 1 / 2 } ( \cos \varphi ) \} } \end{array} \mathrm { , }
$$

where

$$
1 6 \Delta ^ { 2 } \equiv \left( c ^ { 2 } - ( a - b ) ^ { 2 } \right) \left( ( a + b ) ^ { 2 } - c ^ { 2 } \right) ,
$$

and

$$
\cos \varphi = \frac { a ^ { 2 } + b ^ { 2 } - c ^ { 2 } } { 2 a b } \quad , \quad \sin \varphi = \frac { 2 \Delta } { a b } .
$$

On the other hand, if $c > a + b$ the integrals are instead given by

$$
\begin{array} { l } { \displaystyle \mathcal { Z } _ { J / Y } = \int _ { 0 } ^ { \infty } d \tilde { x } \tilde { x } ^ { 1 - \rho } \left\{ { { J } _ { \rho } } ( c \tilde { x } ) \right\} J _ { \nu } ( a \tilde { x } ) J _ { \nu } ( b \tilde { x } ) } \\ { \displaystyle \qquad \quad } \\ { = \frac { 1 } { \pi } \sqrt { \frac 2 \pi } \frac { ( a b ) ^ { \rho - 1 } } { c ^ { \rho } } \left( \sinh \phi \right) ^ { \rho - 1 / 2 } { \Gamma [ \nu - \rho + 1 ] { Q } _ { \nu - 1 / 2 } ^ { - \rho + 1 / 2 } } ( \cosh \phi ) \left\{ { { - \sin \left[ \left( \nu - \rho \right) \pi \right] } } \right\} , } \\ { \displaystyle \qquad \quad } \end{array}
$$

where

$$
1 6 \tilde { \Delta } ^ { 2 } \equiv \left( c ^ { 2 } - ( a - b ) ^ { 2 } \right) \left( c ^ { 2 } - ( a + b ) ^ { 2 } \right) ,
$$

and

$$
\cosh \phi = \frac { c ^ { 2 } - ( a ^ { 2 } + b ^ { 2 } ) } { 2 a b } \quad , \quad \sinh \phi = \frac { 2 \tilde { \Delta } } { a b } .
$$

To use these formulas in the main text, we identify

$$
c = 1 \quad , \quad a = c _ { s } v \quad , \quad b = c _ { s } u .
$$

Then, the range $| 1 - v | < u < 1 + v$ can be split into $1 > c _ { s } ( u + v )$ $( c > a + b )$ ) and $1 < c _ { s } ( u + v )$ $( c < a + b )$ . In the latter case we always have that $c _ { s } | u - v | < 1$ by momentum conservation and so the formulas presented above cover all ranges of interest.

# H Associated Legendre functions

In this appendix, we present useful formulae for the associated Legendre functions that can be found in Ref. [346]. We begin with the definitions of the associated Legendre functions of the first and second kind in terms of hypergeometric functions which read

$$
{ \sf P } _ { \nu } ^ { \mu } \left( x \right) = \left( \frac { 1 + x } { 1 - x } \right) ^ { \mu / 2 } { \bf F } \left( \nu + 1 , - \nu ; 1 - \mu ; \frac { 1 } { 2 } - \frac { 1 } { 2 } x \right) ,
$$

$$
\begin{array} { c } { { \displaystyle \mathbb Q _ { \nu } ^ { \mu } \left( x \right) = \frac \pi { 2 \sin \left( \mu \pi \right) } \Bigg ( \cos \left( \mu \pi \right) \left( \frac { 1 + x } { 1 - x } \right) ^ { \mu / 2 } { \bf F } \left( \nu + 1 , - \nu ; 1 - \mu ; \frac 1 2 - \frac 1 2 x \right) } } \\ { { - \frac { \Gamma \left( \nu + \mu + 1 \right) } { \Gamma \left( \nu - \mu + 1 \right) } \left( \frac { 1 - x } { 1 + x } \right) ^ { \mu / 2 } { \bf F } \left( \nu + 1 , - \nu ; 1 + \mu ; \frac 1 2 - \frac 1 2 x \right) \Bigg ) , } } \end{array}
$$

and

$$
\begin{array} { l } { { \displaystyle { \mathcal Q } _ { \nu } ^ { \mu } \left( x \right) = \frac { \pi } { 2 \sin \left( \mu \pi \right) \Gamma \left( \nu + \mu + 1 \right) } \Biggl ( \left( \frac { x + 1 } { x - 1 } \right) ^ { \mu / 2 } { \bf F } \left( \nu + 1 , - \nu ; 1 - \mu ; \frac 1 2 - \frac { 1 } { 2 } x \right) } \Biggr . } \\ { { \displaystyle \left. \mathrm - \frac { \Gamma \left( \nu + \mu + 1 \right) } { \Gamma \left( \nu - \mu + 1 \right) } \left( \frac { x - 1 } { x + 1 } \right) ^ { \mu / 2 } { \bf F } \left( \nu + 1 , - \nu ; 1 + \mu ; \frac 1 2 - \frac { 1 } { 2 } x \right) \right) . } } \end{array}
$$

Note that $\mathsf { P } _ { \nu } ^ { \mu } ( x )$ and $\mathsf Q _ { \nu } ^ { \mu } ( x )$ are also called the Ferrer’s functions and are valid for $| x | < 1$ . Then, $\mathcal { Q } _ { \nu } ^ { \mu } ( x )$ is also known as Olver’s function which is real for $| x | > 1$ . In the above definitions we have used the compact notation

$$
\mathbf { F } \left( a , b ; c ; x \right) = { \frac { 1 } { \Gamma [ c ] } } F \left( a , b ; c ; x \right) ,
$$

with $F \left( a , b ; c ; x \right)$ being the Gauss’s Hypergeometric function.

# H.1 Asymptotic limits

We write down the asymptotic behaviour of the Associated Legendre functions near the singular points $x \sim 1$ and $x \to \infty$ . It should be noted that the formulas below are valid for $\mu \not \in \mathbb { Z }$ . Relevant cases with $\mu \not \in \mathbb { Z }$ are given in Sec. 10.

The limit $x \to 1 ^ { - }$ : First, the Ferrer’s function of the first kind asymptotically goes as

$$
{ \sf P } _ { \nu } ^ { \mu } \left( x \right) \sim \frac { 1 } { \Gamma \left( 1 - \mu \right) } \left( \frac { 2 } { 1 - x } \right) ^ { \mu / 2 } .
$$

Second, the Ferrer’s function of the second kind goes for $\mu > 0$ as

$$
{ \sf Q } _ { \nu } ^ { - \mu } \left( x \right) \sim \frac { \Gamma \left( \mu \right) \Gamma \left( \nu - \mu + 1 \right) } { 2 \Gamma \left( \nu + \mu + 1 \right) } \left( \frac 2 { 1 - x } \right) ^ { \mu / 2 } ,
$$

while for $\mu < 0$ behaves as

$$
\mathsf Q _ { \nu } ^ { \mu } \left( x \right) \sim \frac { 1 } { 2 } \cos \left( \mu \pi \right) \Gamma \left( \mu \right) \left( \frac { 2 } { 1 - x } \right) ^ { \mu / 2 } \qquad \mu \neq 1 / 2 .
$$

The limit $x \to 1 ^ { + }$ : Since $| x | > 1$ , this case only concerns the Olver’s function of the second kind. In the limit $x \to 1 ^ { + }$ we have that

$$
\mathcal { Q } _ { \nu } ^ { \mu } \left( x \right) \sim \frac { \Gamma \left( \mu \right) } { 2 \Gamma \left( \nu + \mu + 1 \right) } \left( \frac { 2 } { x - 1 } \right) ^ { \mu / 2 } .
$$

The limit $x \to \infty$ : This case also applies only to the Olver’s function of the second kind. The asymptotic behaviour is then given by

$$
\mathcal { Q } _ { \nu } ^ { \mu } \left( x \right) \sim \frac { \pi ^ { 1 / 2 } } { \Gamma \left( \nu + \frac { 3 } { 2 } \right) ( 2 x ) ^ { \nu + 1 } } .
$$

# H.1.1 Useful relations

In order to apply the asymptotic limits of Sec. H.1 we have to evaluate the functions for negative argument and negative order. This can be done by the useful relations below:

$$
\mathsf { P } _ { b } ^ { - b } ( - x ) = \mathsf { P } _ { b } ^ { - b } ( x ) \quad , \quad \mathsf { P } _ { b + 2 } ^ { - b } ( - x ) = \mathsf { P } _ { b + 2 } ^ { - b } ( x ) ,
$$

$$
\mathsf Q _ { b } ^ { - b } ( - x ) = - \mathsf Q _ { b } ^ { - b } ( x ) \quad , \quad \mathsf Q _ { b + 2 } ^ { - b } ( - x ) = - \mathsf Q _ { b + 2 } ^ { - b } ( x ) ,
$$

and

$$
\begin{array} { r } { \mathcal { Q } _ { b } ^ { - b } ( x ) = \mathcal { Q } _ { b } ^ { b } ( x ) \quad , \quad \mathcal { Q } _ { b + 2 } ^ { - b } ( x ) = \mathcal { Q } _ { b + 2 } ^ { b } ( x ) . } \end{array}
$$

# H.1.2 The resonance limit

Using the formulas in the Sec. H.1 we can compute the terms that appear in Sec. 4.2 in Eq. 4.14 near the resonant point $y \sim 1$ . In this way, we have that on one hand for $y  - 1 ^ { + }$

$$
{ \sf P } _ { b } ^ { - b } ( y ) + \frac { b + 2 } { b + 1 } { \sf P } _ { b + 2 } ^ { - b } ( y ) \sim \frac { 3 + 2 b } { 1 + b } \frac { 1 } { \Gamma [ 1 + b ] } \left( \frac { 2 } { 1 + y } \right) ^ { - b / 2 } ,
$$

and

$$
\Theta _ { b } ^ { - b } ( y ) + \frac { b + 2 } { b + 1 } \Theta _ { b + 2 } ^ { - b } ( y ) \sim - \frac { 3 + 2 b } { 1 + b } \left\{ \begin{array} { l l } { { ( 1 + b + b ^ { 2 } ) \frac { \Gamma [ b ] } { \Gamma [ 2 b + 3 ] } \left( \frac { 2 } { 1 + y } \right) ^ { b / 2 } } } & { { b > 0 } } \\ { { } } & { { } } \\ { { \frac { 1 } { 2 } \cos ( b \pi ) \Gamma [ - b ] \left( \frac { 2 } { 1 + y } \right) ^ { - b / 2 } } } & { { b < 0 } } \end{array} \right. .
$$

On the other hand, for $y \to 1 ^ { + }$ we find

$$
Q _ { b } ^ { - b } ( y ) + 2 \frac { b + 2 } { b + 1 } Q _ { b + 2 } ^ { - b } ( y ) \sim \frac { 3 + 2 b } { 1 + b } \left\{ \begin{array} { l l } { { ( 1 + b + b ^ { 2 } ) \frac { \Gamma [ b ] } { \Gamma [ 2 b + 3 ] } \left( \frac { 2 } { 1 - y } \right) ^ { b / 2 } } } & { { b > 0 } } \\ { { } } & { { } } \\ { { \frac { 1 } { 2 } \Gamma [ - b ] \left( \frac { 2 } { 1 - y } \right) ^ { - b / 2 } } } & { { b < 0 } } \end{array} \right. .
$$

Bibliography   
[1] R. Allahverdi et al., The First Three Seconds: a Review of Possible Expansion Histories of the Early Universe, Open J. Astrophys. 4 (2021) [2006.16182].   
[2] Planck collaboration, Planck 2018 results. VI. Cosmological parameters, Astron. Astrophys. 641 (2020) A6 [1807.06209].   
[3] Planck collaboration, Planck 2018 results. X. Constraints on inflation, Astron. Astrophys. 641 (2020) A10 [1807.06211].   
[4] R. Brout, F. Englert and E. Gunzig, The Creation of the Universe as a Quantum Phenomenon, Annals Phys. 115 (1978) 78.   
[5] A.A. Starobinsky, Spectrum of relict gravitational radiation and the early state of the universe, JETP Lett. 30 (1979) 682.   
[6] A.H. Guth, The Inflationary Universe: A Possible Solution to the Horizon and Flatness Problems, Phys. Rev. D 23 (1981) 347.   
[7] K. Sato, First Order Phase Transition of a Vacuum and Expansion of the Universe, Mon. Not. Roy. Astron. Soc. 195 (1981) 467.   
[8] V.F. Mukhanov and G.V. Chibisov, Quantum Fluctuations and a Nonsingular Universe, JETP Lett. 33 (1981) 532.   
[9] A.D. Linde, A New Inflationary Universe Scenario: A Possible Solution of the Horizon, Flatness, Homogeneity, Isotropy and Primordial Monopole Problems, Phys. Lett. B 108 (1982) 389.   
[10] A. Albrecht and P.J. Steinhardt, Cosmology for Grand Unified Theories with Radiatively Induced Symmetry Breaking, Phys. Rev. Lett. 48 (1982) 1220.   
[11] M. Sasaki, Gauge Invariant Scalar Perturbations in the New Inflationary Universe, Prog. Theor. Phys. 70 (1983) 394.   
[12] H. Kodama and M. Sasaki, Cosmological Perturbation Theory, Prog. Theor. Phys. Suppl. 78 (1984) 1.   
[13] L. Lentati et al., European Pulsar Timing Array Limits On An Isotropic Stochastic Gravitational-Wave Background, Mon. Not. Roy. Astron. Soc. 453 (2015) 2576 [1504.03692].   
[14] R.M. Shannon et al., Gravitational waves from binary supermassive black holes missing in pulsar observations, Science 349 (2015) 1522 [1509.07320].   
[15] NANOGrav collaboration, The NANOGrav Nine-year Data Set: Limits on the Isotropic Stochastic Gravitational Wave Background, Astrophys. J. 821 (2016) 13 [1508.03024].   
[16] W. Qin, K.K. Boddy, M. Kamionkowski and L. Dai, Pulsar-timing arrays, astrometry, and gravitational waves, Phys. Rev. D99 (2019) 063002 [1810.02369].   
[17] K. Aggarwal et al., The NANOGrav 11-Year Data Set: Limits on Gravitational Waves from Individual Supermassive Black Hole Binaries, Astrophys. J. 880 (2019) 2 [1812.11585].   
[18] NANOGrav collaboration, The NANOGrav 12.5 yr Data Set: Search for an Isotropic Stochastic Gravitational-wave Background, Astrophys. J. Lett. 905 (2020) L34 [2009.04496].   
[19] M. Maggiore et al., Science Case for the Einstein Telescope, JCAP 03 (2020) 050 [1912.02622].   
[20] LISA collaboration, Laser Interferometer Space Antenna, 1702.00786.   
[21] E. Barausse et al., Prospects for Fundamental Physics with LISA, Gen. Rel. Grav. 52 (2020) 81 [2001.09793].   
[22] N. Seto, S. Kawamura and T. Nakamura, Possibility of direct measurement of the acceleration of the universe using 0.1-Hz band laser interferometer gravitational wave antenna in space, Phys. Rev. Lett. 87 (2001) 221103 [astro-ph/0108011].   
[23] K. Yagi and N. Seto, Detector configuration of DECIGO/BBO and identification of cosmological neutron-star binaries, Phys. Rev. D83 (2011) 044011 [1101.3940].   
[24] S. Kawamura et al., Current status of space gravitational wave antenna DECIGO and B-DECIGO, 2006.13545.   
[25] L. Badurina et al., AION: An Atom Interferometer Observatory and Network, 1911.11755.   
[26] W.-H. Ruan, Z.-K. Guo, R.-G. Cai and Y.-Z. Zhang, Taiji Program: Gravitational-Wave Sources, 1807.09495.   
[27] TianQin collaboration, TianQin: a space-borne gravitational wave detector, Class. Quant. Grav. 33 (2016) 035010 [1512.02076].   
[28] C. Caprini and D.G. Figueroa, Cosmological Backgrounds of Gravitational Waves, Class. Quant. Grav. 35 (2018) 163001 [1801.04268].   
[29] A.D. Gow, C.T. Byrnes, P.S. Cole and S. Young, The power spectrum on small scales: Robust constraints and comparing PBH methodologies, JCAP 02 (2021) 002 [2008.03289].   
[30] J. Chluba et al., Spectral Distortions of the CMB as a Probe of Inflation, Recombination, Structure Formation and Particle Physics: Astro2020 Science White Paper, Bull. Am. Astron. Soc. 51 (2019) 184 [1903.04218].   
[31] T. Kite, A. Ravenni, S.P. Patil and J. Chluba, Bridging the gap: spectral distortions meet gravitational waves, 2010.00040.   
[32] C. Unal, E.D. Kovetz and S.P. Patil, Multi-messenger Probes of Inflationary Fluctuations and Primordial Black Holes, 2008.11184.   
[33] E. Thrane and J.D. Romano, Sensitivity curves for searches for gravitational-wave backgrounds, Phys. Rev. D88 (2013) 124032 [1310.5300].   
[34] K. Tomita, Non-Linear Theory of Gravitational Instability in the Expanding Universe, Progress of Theoretical Physics 37 (1967) 831 [https://academic.oup.com/ptp/article-pdf/37/5/831/5234391/37-5-831.pdf].   
[35] S. Matarrese, O. Pantano and D. Saez, A General relativistic approach to the nonlinear evolution of collisionless matter, Phys. Rev. D 47 (1993) 1311.   
[36] S. Matarrese, O. Pantano and D. Saez, General relativistic dynamics of irrotational dust: Cosmological implications, Phys. Rev. Lett. 72 (1994) 320 [astro-ph/9310036].   
[37] S. Matarrese, S. Mollerach and M. Bruni, Second order perturbations of the Einstein-de Sitter universe, Phys. Rev. D 58 (1998) 043504 [astro-ph/9707278].   
[38] K.N. Ananda, C. Clarkson and D. Wands, The Cosmological gravitational wave background from primordial density perturbations, Phys. Rev. D 75 (2007) 123518 [gr-qc/0612013].   
[39] D. Baumann, P.J. Steinhardt, K. Takahashi and K. Ichiki, Gravitational Wave Spectrum Induced by Primordial Scalar Perturbations, Phys. Rev. D 76 (2007) 084019 [hep-th/0703290].   
[40] A. Mangilli, N. Bartolo, S. Matarrese and A. Riotto, The impact of cosmic neutrinos on the gravitational-wave background, Phys. Rev. D 78 (2008) 083517 [0805.3234].   
[41] D. Sarkar, P. Serra, A. Cooray, K. Ichiki and D. Baumann, Cosmic shear from scalar-induced gravitational waves, Phys. Rev. D 77 (2008) 103515 [0803.1490].   
[42] P. Martineau and R. Brandenberger, A Back-reaction Induced Lower Bound on the Tensor-to-Scalar Ratio, Mod. Phys. Lett. A 23 (2008) 727 [0709.2671].   
[43] N. Bartolo, S. Matarrese, A. Riotto and A. Vaihkonen, The Maximal Amount of Gravitational Waves in the Curvaton Scenario, Phys. Rev. D 76 (2007) 061302 [0705.4240].   
[44] L. Boubekeur, P. Creminelli, J. Norena and F. Vernizzi, Action approach to cosmological perturbations: the 2nd order metric in matter dominance, JCAP 08 (2008) 028 [0806.1016].   
[45] R. Saito and J. Yokoyama, Gravitational wave background as a probe of the primordial black hole abundance, Phys. Rev. Lett. 102 (2009) 161101 [0812.4339].   
[46] R. Saito and J. Yokoyama, Gravitational-Wave Constraints on the Abundance of Primordial Black Holes, Prog. Theor. Phys. 123 (2010) 867 [0912.5317].   
[47] E. Bugaev and P. Klimai, Induced gravitational wave background and primordial black holes, Phys. Rev. D 81 (2010) 023517 [0908.0664].   
[48] E.V. Bugaev and P.A. Klimai, Bound on induced gravitational wave background from primordial black holes, JETP Lett. 91 (2010) 1 [0911.0611].   
[49] E. Bugaev and P. Klimai, Constraints on the induced gravitational wave background from primordial black holes, Phys. Rev. D 83 (2011) 083521 [1012.4697].   
[50] H. Assadullahi and D. Wands, Constraints on primordial density perturbations from induced gravitational waves, Phys. Rev. D 81 (2010) 023527 [0907.4073].   
[51] H. Assadullahi and D. Wands, Gravitational waves from an early matter era, Phys. Rev. D 79 (2009) 083511 [0901.0989].   
[52] F. Arroja, H. Assadullahi, K. Koyama and D. Wands, Cosmological matching conditions for gravitational waves at second order, Phys. Rev. D 80 (2009) 123526 [0907.3618].   
[53] L. Alabidi, K. Kohri, M. Sasaki and Y. Sendouda, Observable Spectra of Induced Gravitational Waves from Inflation, JCAP 09 (2012) 017 [1203.4663].   
[54] L. Alabidi, K. Kohri, M. Sasaki and Y. Sendouda, Observable induced gravitational waves from an early matter phase, $J C A P$ 05 (2013) 033 [1303.4519].   
[55] M. Kawasaki, N. Kitajima and S. Yokoyama, Gravitational waves from a curvaton model with blue spectrum, JCAP 08 (2013) 042 [1305.4464].   
[56] T. Nakama and T. Suyama, Primordial black holes as a novel probe of primordial gravitational waves, Phys. Rev. D 92 (2015) 121304 [1506.05228].   
[57] T. Nakama and T. Suyama, Primordial black holes as a novel probe of primordial gravitational waves. II: Detailed analysis, Phys. Rev. D 94 (2016) 043507 [1605.04482].   
[58] T. Suyama and J. Yokoyama, Temporal enhancement of super-horizon curvature perturbations from decays of two curvatons and its cosmological consequences, Phys. Rev. D 84 (2011) 083511 [1106.5983].   
[59] S. Saga, K. Ichiki and N. Sugiyama, Impact of anisotropic stress of free-streaming particles on gravitational waves induced by cosmological density perturbations, Phys. Rev. D 91 (2015) 024030 [1412.1081].   
[60] C. Fidler, G.W. Pettinari, M. Beneke, R. Crittenden, K. Koyama and D. Wands, The intrinsic B-mode polarisation of the Cosmic Microwave Background, JCAP 07 (2014) 011 [1401.3296].   
[61] LIGO Scientific, Virgo collaboration, GW151226: Observation of Gravitational Waves from a 22-Solar-Mass Binary Black Hole Coalescence, Phys. Rev. Lett. 116 (2016) 241103 [1606.04855].   
[62] J.R. Espinosa, D. Racco and A. Riotto, A Cosmological Signature of the SM Higgs Instability: Gravitational Waves, JCAP 09 (2018) 012 [1804.07732].   
[63] K. Kohri and T. Terada, Semianalytic calculation of gravitational wave spectrum nonlinearly induced from primordial curvature perturbations, Phys. Rev. D 97 (2018) 123532 [1804.08577].   
[64] G. Domènech, Induced gravitational waves in a general cosmological background, Int. J. Mod. Phys. D 29 (2020) 2050028 [1912.05583].   
[65] K. Inomata, K. Kohri, T. Nakama and T. Terada, Gravitational Waves Induced by Scalar Perturbations during a Gradual Transition from an Early Matter Era to the Radiation Era, JCAP 10 (2019) 071 [1904.12878].   
[66] K. Inomata, K. Kohri, T. Nakama and T. Terada, Enhancement of Gravitational Waves Induced by Scalar Perturbations due to a Sudden Transition from an Early Matter Era to the Radiation Era, Phys. Rev. D 100 (2019) 043532 [1904.12879].   
[67] I. Dalianis and C. Kouvaris, Gravitational Waves from Density Perturbations in an Early Matter Domination Era, 2012.09255.   
[68] K. Inomata, M. Kawasaki, K. Mukaida, T. Terada and T.T. Yanagida, Gravitational Wave Production right after a Primordial Black Hole Evaporation, Phys. Rev. D 101 (2020) 123533 [2003.10455].   
[69] T. Papanikolaou, V. Vennin and D. Langlois, Gravitational waves from a universe filled with primordial black holes, 2010.11573.   
[70] G. Domènech, C. Lin and M. Sasaki, Gravitational wave constraints on the primordial black hole dominated early universe, 2012.08151.   
[71] G. Domènech, V. Takhistov and M. Sasaki, Exploring Evaporating Primordial Black Holes with Gravitational Waves, 2105.06816.   
[72] F. Hajkarim and J. Schaffner-Bielich, Thermal History of the Early Universe and Primordial Gravitational Waves from Induced Scalar Perturbations, Phys. Rev. D 101 (2020) 043522 [1910.12357].   
[73] S. Bhattacharya, S. Mohanty and P. Parashari, Primordial black holes and gravitational waves in nonstandard cosmologies, Phys. Rev. D 102 (2020) 043522 [1912.01653].   
[74] G. Domènech, S. Pi and M. Sasaki, Induced gravitational waves as a probe of thermal history of the universe, JCAP 08 (2020) 017 [2005.12314].   
[75] I. Dalianis and K. Kritos, Exploring the Spectral Shape of Gravitational Waves Induced by Primordial Scalar Perturbations and Connection with the Primordial Black Hole Scenarios, Phys. Rev. D 103 (2021) 023505 [2007.07915].   
[76] K.T. Abe, Y. Tada and I. Ueda, Induced gravitational waves as a cosmological probe of the sound speed during the QCD phase transition, 2010.06193.   
[77] A. Hook, G. Marques-Tavares and D. Racco, Causal gravitational waves as a probe of free streaming particles and the expansion of the Universe, JHEP 02 (2021) 117 [2010.03568].   
[78] R.-G. Cai, S. Pi and M. Sasaki, Universal infrared scaling of gravitational wave background spectra, Phys. Rev. D 102 (2020) 083528 [1909.13728].   
[79] C. Yuan, Z.-C. Chen and Q.-G. Huang, Log-dependent slope of scalar induced gravitational waves in the infrared regions, Phys. Rev. D 101 (2020) 043019 [1910.09099].

[80] J. Liu, Z.-K. Guo and R.-G. Cai, Analytical approximation of the scalar spectrum in the ultraslow-roll inflationary models, Phys. Rev. D 101 (2020) 083535 [2003.02075].

[81] V. Atal and G. Domènech, Probing non-Gaussianities with the high frequency tail of induced gravitational waves, 2103.01056.   
[82] S. Pi and M. Sasaki, Gravitational Waves Induced by Scalar Perturbations with a Lognormal Peak, JCAP 09 (2020) 037 [2005.12306].   
[83] R.-G. Cai, S. Pi, S.-J. Wang and X.-Y. Yang, Resonant multiple peaks in the induced gravitational waves, JCAP 05 (2019) 013 [1901.10152].   
[84] J. Fumagalli, S. Renaux-Petel and L.T. Witkowski, Oscillations in the stochastic gravitational wave background from sharp features and particle production during inflation, 2012.02761.   
[85] M. Braglia, D.K. Hazra, F. Finelli, G.F. Smoot, L. Sriramkumar and A.A. Starobinsky, Generating PBHs and small-scale GWs in two-field models of inflation, JCAP 08 (2020) 001 [2005.02895].   
[86] M. Braglia, X. Chen and D.K. Hazra, Probing Primordial Features with the Stochastic Gravitational Wave Background, 2012.05821.   
[87] J. Fumagalli, S. Renaux-Petel and L.T. Witkowski, Resonant features in the stochastic gravitational wave background, 2105.06481.   
[88] J. Garcia-Bellido, M. Peloso and C. Unal, Gravitational Wave signatures of inflationary models from Primordial Black Hole Dark Matter, JCAP 09 (2017) 013 [1707.02441].   
[89] R.-g. Cai, S. Pi and M. Sasaki, Gravitational Waves Induced by non-Gaussian Scalar Perturbations, Phys. Rev. Lett. 122 (2019) 201101 [1810.11000].   
[90] C. Unal, Imprints of Primordial Non-Gaussianity on Gravitational Wave Spectrum, Phys. Rev. D 99 (2019) 041301 [1811.09151].   
[91] C. Yuan and Q.-G. Huang, Gravitational waves induced by the local-type non-Gaussian curvature perturbations, 2007.10686.   
[92] P. Adshead, K.D. Lozanov and Z.J. Weiner, Non-Gaussianity and the induced gravitational wave background, 2105.01659.   
[93] H.V. Ragavendra, Accounting for scalar non-Gaussianity in secondary gravitational waves, 2108.04193.   
[94] A. Ota, Induced superhorizon tensor perturbations from anisotropic non-Gaussianity, Phys. Rev. D 101 (2020) 103511 [2001.00409].   
[95] Y.-F. Cai, C. Chen, X. Tong, D.-G. Wang and S.-F. Yan, When Primordial Black Holes from Sound Speed Resonance Meet a Stochastic Background of Gravitational Waves, Phys. Rev. D 100 (2019) 043518 [1902.08187]. [96] R.-G. Cai, Z.-K. Guo, J. Liu, L. Liu and X.-Y. Yang, Primordial black holes and gravitational waves from parametric amplification of curvature perturbations, JCAP 06 (2020) 013 [1912.10437]. [97] Z. Zhou, J. Jiang, Y.-F. Cai, M. Sasaki and S. Pi, Primordial black holes and gravitational waves from resonant amplification during inflation, Phys. Rev. D 102 (2020) 103527 [2010.03537]. [98] Y.-F. Cai, J. Jiang, M. Sasaki, V. Vardanyan and Z. Zhou, Beating the Lyth bound by parametric resonance during inflation, 2105.12554. [99] H.V. Ragavendra, L. Sriramkumar and J. Silk, Could PBHs and secondary GWs have originated from squeezed initial states?, 2011.09938.   
[100] J. Garcia-Bellido, M. Peloso and C. Unal, Gravitational waves at interferometer scales and primordial black holes in axion inflation, JCAP 12 (2016) 031 [1610.03763].   
[101] H. Di and Y. Gong, Primordial black holes and second order gravitational waves from ultra-slow-roll inflation, JCAP 07 (2018) 007 [1707.09578].   
[102] K. Ando, M. Kawasaki and H. Nakatsuka, Formation of primordial black holes in an axionlike curvaton model, Phys. Rev. D 98 (2018) 083508 [1805.07757].   
[103] C.T. Byrnes, P.S. Cole and S.P. Patil, Steepest growth of the power spectrum and primordial black holes, JCAP 06 (2019) 028 [1811.11158].   
[104] T.-J. Gao and X.-Y. Yang, Gravitational waves induced from string axion model of inflation, Int. J. Mod. Phys. A 34 (2019) 1950213.   
[105] W.-T. Xu, J. Liu, T.-J. Gao and Z.-K. Guo, Gravitational waves from double-inflection-point inflation, Phys. Rev. D 101 (2020) 023505 [1907.05213].   
[106] R. Mahbub, Primordial black hole formation in inflationary $\alpha$ -attractor models, Phys. Rev. D 101 (2020) 023533 [1910.10602].   
[107] S.S. Mishra and V. Sahni, Primordial Black Holes from a tiny bump/dip in the Inflaton potential, JCAP 04 (2020) 007 [1911.00057].   
[108] C. Fu, P. Wu and H. Yu, Scalar induced gravitational waves in inflation with gravitationally enhanced friction, Phys. Rev. D 101 (2020) 023529 [1912.05927].   
[109] O. Özsoy and G. Tasinato, On the slope of the curvature power spectrum in non-attractor inflation, JCAP 04 (2020) 048 [1912.01061].   
[110] O. Özsoy and Z. Lalak, Primordial black holes as dark matter and gravitational waves from bumpy axion inflation, JCAP 01 (2021) 040 [2008.07549].   
[111] Q. Gao, Y. Gong and Z. Yi, Primordial black holes and secondary gravitational waves from natural inflation, 2012.03856.   
[112] N. Bhaumik and R.K. Jain, Stochastic induced gravitational waves and lowest mass limit of primordial black holes with the effects of reheating, 2009.10424.   
[113] J. Lin, Q. Gao, Y. Gong, Y. Lu, C. Zhang and F. Zhang, Primordial black holes and secondary gravitational waves from $k$ and $G$ inflation, Phys. Rev. D 101 (2020) 103515 [2001.05909].   
[114] H.V. Ragavendra, P. Saha, L. Sriramkumar and J. Silk, PBHs and secondary GWs from ultra slow roll and punctuated inflation, 2008.12202.   
[115] Z. Yi, Q. Gao, Y. Gong and Z.-h. Zhu, Primordial black holes and secondary gravitational waves from inflationary model with a non-canonical kinetic term, 2011.10606.   
[116] Q. Gao, Primordial black holes and secondary gravitational waves from chaotic inflation, 2102.07369.   
[117] T.-J. Gao and X.-Y. Yang, Double peaks of gravitational wave spectrum induced from inflection point inflation, 2101.07616.   
[118] M. Solbi and K. Karami, Primordial black holes and induced gravitational waves in Galileon inflation, 2102.05651.   
[119] M. Drees and Y. Xu, Overshooting, Critical Higgs Inflation and Second Order Gravitational Wave Signatures, Eur. Phys. J. $C$ 81 (2021) 182 [1905.13581].   
[120] Z. Yi, Y. Gong, B. Wang and Z.-h. Zhu, Primordial Black Holes and Secondary Gravitational Waves from Higgs field, 2007.09957.   
[121] K. Kohri and T. Terada, Primordial Black Hole Dark Matter and LIGO/Virgo Merger Rate from Inflation with Running Spectral Indices: Formation in the Matter- and/or Radiation-Dominated Universe, Class. Quant. Grav. 35 (2018) 235017 [1802.06785].   
[122] N. Bartolo, V. De Luca, G. Franciolini, A. Lewis, M. Peloso and A. Riotto, Primordial Black Hole Dark Matter: LISA Serendipity, Phys. Rev. Lett. 122 (2019) 211301 [1810.12218].   
[123] N. Bartolo, V. De Luca, G. Franciolini, M. Peloso, D. Racco and A. Riotto, Testing primordial black holes as dark matter with LISA, Phys. Rev. D 99 (2019) 103521 [1810.12224].   
[124] Y. Tada and S. Yokoyama, Primordial black hole tower: Dark matter, earth-mass, and LIGO black holes, Phys. Rev. D 100 (2019) 023537 [1904.10298].   
[125] G. Ballesteros, J. Rey, M. Taoso and A. Urbano, Primordial black holes as dark matter and gravitational waves from single-field polynomial inflation, JCAP 07 (2020) 025 [2001.08220].   
[126] K. Inomata, M. Kawasaki, K. Mukaida, Y. Tada and T.T. Yanagida, Inflationary primordial black holes for the LIGO gravitational wave events and pulsar timing array experiments, Phys. Rev. D 95 (2017) 123510 [1611.06130].   
[127] T. Nakama, J. Silk and M. Kamionkowski, Stochastic gravitational waves associated with the formation of primordial black holes, Phys. Rev. D 95 (2017) 043511 [1612.06264].   
[128] K. Ando, K. Inomata, M. Kawasaki, K. Mukaida and T.T. Yanagida, Primordial black holes for the LIGO events in the axionlike curvaton model, Phys. Rev. D 97 (2018) 123512 [1711.08956].   
[129] V. Vaskonen and H. Veermäe, Did NANOGrav see a signal from primordial black hole formation?, Phys. Rev. Lett. 126 (2021) 051303 [2009.07832].   
[130] V. De Luca, G. Franciolini and A. Riotto, NANOGrav Data Hints at Primordial Black Holes as Dark Matter, Phys. Rev. Lett. 126 (2021) 041303 [2009.08268].   
[131] K. Kohri and T. Terada, Solar-Mass Primordial Black Holes Explain NANOGrav Hint of Gravitational Waves, Phys. Lett. B 813 (2021) 136040 [2009.11853].   
[132] G. Domènech and S. Pi, NANOGrav Hints on Planet-Mass Primordial Black Holes, 2010.03976.   
[133] S. Bhattacharya, S. Mohanty and P. Parashari, Implications of the NANOGrav result on primordial gravitational waves in nonstandard cosmologies, 2010.05071.   
[134] K. Inomata, M. Kawasaki, K. Mukaida and T.T. Yanagida, NANOGrav results and LIGO-Virgo primordial black holes in axion-like curvaton model, 2011.01270.   
[135] Z. Yi and Z.-H. Zhu, NANOGrav signal and LIGO-Virgo Primordial Black Holes from Higgs inflation, 2105.01943.   
[136] N. Orlofsky, A. Pierce and J.D. Wells, Inflationary theory and pulsar timing investigations of primordial black holes and gravitational waves, Phys. Rev. D 95 (2017) 063518 [1612.05279].   
[137] R.-G. Cai, S. Pi, S.-J. Wang and X.-Y. Yang, Pulsar Timing Array Constraints on the Induced Gravitational Waves, JCAP 10 (2019) 059 [1907.06372].   
[138] Z.-C. Chen, C. Yuan and Q.-G. Huang, Pulsar Timing Array Constraints on Primordial Black Holes with NANOGrav 11-Year Dataset, Phys. Rev. Lett. 124 (2020) 251101 [1910.12239].   
[139] Z.-C. Chen and Q.-G. Huang, Distinguishing Primordial Black Holes from Astrophysical Black Holes by Einstein Telescope and Cosmic Explorer, JCAP 08 (2020) 039 [1904.02396].   
[140] K. Inomata and T. Nakama, Gravitational waves induced by scalar perturbations as probes of the small-scale primordial spectrum, Phys. Rev. D 99 (2019) 043511 [1812.00674].   
[141] S. Clesse, J. García-Bellido and S. Orani, Detecting the Stochastic Gravitational Wave Background from Primordial Black Hole Formation, 1812.11011.   
[142] S. Wang, T. Terada and K. Kohri, Prospective constraints on the primordial black hole abundance from the stochastic gravitational-wave backgrounds produced by coalescing events and curvature perturbations, Phys. Rev. D 99 (2019) 103531 [1903.05924].   
[143] C. Yuan, Z.-C. Chen and Q.-G. Huang, Probing primordial–black-hole dark matter with scalar induced gravitational waves, Phys. Rev. D 100 (2019) 081301 [1906.11549].   
[144] Y. Lu, Y. Gong, Z. Yi and F. Zhang, Constraints on primordial curvature perturbations from primordial black hole dark matter and secondary gravitational waves, JCAP 12 (2019) 031 [1907.11896].   
[145] F. Zhang, A. Ali, Y. Gong, J. Lin and Y. Lu, On the waveform of the scalar induced gravitational waves, 2008.12961.   
[146] Y.-T. Wang, Y. Cai, Z.-G. Liu and Y.-S. Piao, Probing the primordial universe with gravitational waves detectors, JCAP 01 (2017) 010 [1612.05088].   
[147] N. Bartolo, V. Domcke, D.G. Figueroa, J. García-Bellido, M. Peloso, M. Pieroni et al., Probing non-Gaussian Stochastic Gravitational Wave Backgrounds with LISA, JCAP 11 (2018) 034 [1806.02819].   
[148] N. Bartolo, D. Bertacca, V. De Luca, G. Franciolini, S. Matarrese, M. Peloso et al., Gravitational wave anisotropies from primordial black holes, JCAP 02 (2020) 028 [1909.12619].   
[149] J.-C. Hwang, D. Jeong and H. Noh, Gauge dependence of gravitational waves generated from scalar perturbations, Astrophys. J. 842 (2017) 46 [1704.03500].   
[150] G. Domènech and M. Sasaki, Hamiltonian approach to second order gauge invariant cosmological perturbations, Phys. Rev. D 97 (2018) 023521 [1709.09804].   
[151] J.-O. Gong, Analytic integral solutions for induced gravitational waves, 1909.12708.   
[152] K. Tomikawa and T. Kobayashi, Gauge dependence of gravitational waves generated at second order from scalar perturbations, Phys. Rev. D 101 (2020) 083529 [1910.01880].   
[153] V. De Luca, G. Franciolini, A. Kehagias and A. Riotto, On the Gauge Invariance of Cosmological Gravitational Waves, JCAP 03 (2020) 014 [1911.09689].   
[154] K. Inomata and T. Terada, Gauge Independence of Induced Gravitational Waves, Phys. Rev. D 101 (2020) 023523 [1912.00785].   
[155] C. Yuan, Z.-C. Chen and Q.-G. Huang, Scalar induced gravitational waves in different gauges, Phys. Rev. D 101 (2020) 063018 [1912.00885].   
[156] Z. Chang, S. Wang and Q.-H. Zhu, Gauge Invariant Second Order Gravitational Waves, 2009.11994.   
[157] Z. Chang, S. Wang and Q.-H. Zhu, Gauge invariance of the second order cosmological perturbations, 2009.11025.   
[158] Y. Lu, A. Ali, Y. Gong, J. Lin and F. Zhang, Gauge transformation of scalar induced gravitational waves, Phys. Rev. D 102 (2020) 083503 [2006.03450].   
[159] A. Ali, Y. Gong and Y. Lu, Gauge transformation of scalar induced tensor perturbation during matter domination, Phys. Rev. D 103 (2021) 043516 [2009.11081].   
[160] Z. Chang, S. Wang and Q.-H. Zhu, On the Gauge Invariance of Scalar Induced Gravitational Waves: Gauge Fixings Considered, 2010.01487.   
[161] G. Domènech and M. Sasaki, Approximate gauge independence of the induced gravitational wave spectrum, 2012.14016.   
[162] J. Gurian, D. Jeong, J.-C. Hwang and H. Noh, Gauge-Invariant Tensor Perturbations Induced from Baryon-CDM Relative Velocity and the B-mode Polarization of the CMB, 2104.03330.   
[163] V.F. Mukhanov, H.A. Feldman and R.H. Brandenberger, Theory of cosmological perturbations. Part 1. Classical perturbations. Part 2. Quantum theory of perturbations. Part 3. Extensions, Phys. Rept. 215 (1992) 203.   
[164] K.A. Malik and D. Wands, Cosmological perturbations, Phys. Rept. 475 (2009) 1 [0809.4944].   
[165] R. Durrer, Cosmological perturbation theory, Lect. Notes Phys. 653 (2004) 31 [astro-ph/0402129].   
[166] D. Langlois, Lectures on inflation and cosmological perturbations, Lect. Notes Phys. 800 (2010) 1 [1001.5259].   
[167] D. Baumann, Inflation, in Theoretical Advanced Study Institute in Elementary Particle Physics: Physics of the Large and the Small, 7, 2009, DOI [0907.5424].   
[168] O.F. Piattella, Lecture Notes in Cosmology, UNITEXT for Physics, Springer, Cham (2018), 10.1007/978-3-319-95570-4, [1803.00070].   
[169] J.-O. Gong, Multi-field inflation and cosmological perturbations, Int. J. Mod. Phys. D 26 (2016) 1740003 [1606.06971].   
[170] X. Chen, Primordial Features as Evidence for Inflation, JCAP 01 (2012) 038 [1104.1323].   
[171] N. Christensen, Stochastic Gravitational Wave Backgrounds, Rept. Prog. Phys. 82 (2019) 016903 [1811.08797].   
[172] S. Kuroyanagi, T. Chiba and T. Takahashi, Probing the Universe through the Stochastic Gravitational Wave Background, JCAP 11 (2018) 038 [1807.00786].   
[173] M.C. Guzzetti, N. Bartolo, M. Liguori and S. Matarrese, Gravitational waves from inflation, Riv. Nuovo Cim. 39 (2016) 399 [1605.01615].   
[174] M. Sasaki, T. Suyama, T. Tanaka and S. Yokoyama, Primordial black holes—perspectives in gravitational wave astronomy, Class. Quant. Grav. 35 (2018) 063001 [1801.05235].   
[175] M.Y. Khlopov, Primordial Black Holes, Res. Astron. Astrophys. 10 (2010) 495 [0801.0116].   
[176] B. Carr, K. Kohri, Y. Sendouda and J. Yokoyama, Constraints on Primordial Black Holes, 2002.12778.   
[177] B. Carr and F. Kuhnel, Primordial Black Holes as Dark Matter: Recent Developments, Ann. Rev. Nucl. Part. Sci. 70 (2020) 355 [2006.02838].   
[178] A.M. Green and B.J. Kavanagh, Primordial Black Holes as a dark matter candidate, J. Phys. G 48 (2021) 4 [2007.10722].   
[179] C. Yuan and Q.-G. Huang, A topic review on probing primordial black hole dark matter with scalar induced gravitational waves, 2103.04739.   
[180] E. Komatsu, Hunting for Primordial Non-Gaussianity in the Cosmic Microwave Background, Class. Quant. Grav. 27 (2010) 124010 [1003.6097].   
[181] N. Bartolo, S. Matarrese and A. Riotto, Non-Gaussianity and the Cosmic Microwave Background Anisotropies, Adv. Astron. 2010 (2010) 157079 [1001.3957].   
[182] C.T. Byrnes and K.-Y. Choi, Review of local non-Gaussianity from multi-field inflation, Adv. Astron. 2010 (2010) 724525 [1002.3110].   
[183] K. Koyama, Non-Gaussianity of quantum fields during inflation, Class. Quant. Grav. 27 (2010) 124001 [1002.0600].   
[184] C.W. Misner, K.S. Thorne and J.A. Wheeler, Gravitation, W. H. Freeman, San Francisco (1973).   
[185] M. Maggiore, Gravitational Waves. Vol. 1: Theory and Experiments, Oxford Master Series in Physics, Oxford University Press (2007).   
[186] R.A. Isaacson, Gravitational Radiation in the Limit of High Frequency. I. The Linear Approximation and Geometrical Optics, Phys. Rev. 166 (1968) 1263.   
[187] R.A. Isaacson, Gravitational Radiation in the Limit of High Frequency. II. Nonlinear Terms and the Ef fective Stress Tensor, Phys. Rev. 166 (1968) 1272.   
[188] S. Kawamura et al., The Japanese space gravitational wave antenna: DECIGO, Class. Quant. Grav. 28 (2011) 094011.   
[189] S.W. Hawking, Particle Creation by Black Holes, Commun. Math. Phys. 43 (1975) 199.   
[190] B.J. Carr and S. Hawking, Black holes in the early Universe, Mon. Not. Roy. Astron. Soc. 168 (1974) 399.   
[191] M. Crawford and D.N. Schramm, Spontaneous Generation of Density Perturbations in the Early Universe, Nature 298 (1982) 538.   
[192] H. Kodama, M. Sasaki and K. Sato, Abundance of Primordial Holes Produced by Cosmological First Order Phase Transition, Prog. Theor. Phys. 68 (1982) 1979.   
[193] J. Garriga, A. Vilenkin and J. Zhang, Black holes and the multiverse, JCAP 02 (2016) 064 [1512.01819].   
[194] E. Cotner and A. Kusenko, Primordial black holes from supersymmetry in the early universe, Phys. Rev. Lett. 119 (2017) 031103 [1612.02529].   
[195] E. Cotner, A. Kusenko, M. Sasaki and V. Takhistov, Analytic Description of Primordial Black Hole Formation from Scalar Field Fragmentation, JCAP 10 (2019) 077 [1907.10613].   
[196] L. Amendola, J. Rubio and C. Wetterich, Primordial black holes from fifth forces, Phys. Rev. D 97 (2018) 081302 [1711.09915].   
[197] S. Savastano, L. Amendola, J. Rubio and C. Wetterich, Primordial dark matter halos from fifth forces, Phys. Rev. D 100 (2019) 083518 [1906.05300].   
[198] M.M. Flores and A. Kusenko, Primordial Black Holes from Long-Range Scalar Forces and Scalar Radiative Cooling, Phys. Rev. Lett. 126 (2021) 041101 [2008.12456].   
[199] M. Shibata and M. Sasaki, Black hole formation in the Friedmann universe: Formulation and computation in numerical relativity, Phys. Rev. D 60 (1999) 084002 [gr-qc/9905064].   
[200] T. Nakama, T. Harada, A.G. Polnarev and J. Yokoyama, Identifying the most crucial parameters of the initial curvature profile for primordial black hole formation, JCAP 01 (2014) 037 [1310.3007].   
[201] T. Harada, C.-M. Yoo, T. Nakama and Y. Koga, Cosmological long-wavelength solutions and primordial black hole formation, Phys. Rev. D 91 (2015) 084057 [1503.03934].   
[202] A. Escrivà and A.E. Romano, Effects of the shape of curvature peaks on the size of primordial black holes, JCAP 05 (2021) 066 [2103.03867].   
[203] I.D. Zel’dovich, Ya.B.; Novikov, The Hypothesis of Cores Retarded during Expansion and the Hot Cosmological Model, Soviet Astron. AJ (Engl. Transl. ), 10 (1967) 602.   
[204] S. Hawking, Gravitationally collapsed objects of very low mass, Mon. Not. Roy. Astron. Soc. 152 (1971) 75.   
[205] P. Meszaros, The behaviour of point masses in an expanding cosmological substratum, Astron. Astrophys. 37 (1974) 225.   
[206] B.J. Carr, The Primordial black hole mass spectrum, Astrophys. J. 201 (1975) 1.   
[207] M. Khlopov, B. Malomed and I. Zeldovich, Gravitational instability of scalar fields and formation of primordial black holes, Mon. Not. Roy. Astron. Soc. 215 (1985) 575.   
[208] J.C. Niemeyer and K. Jedamzik, Dynamics of primordial black hole formation, Phys. Rev. D 59 (1999) 124013 [astro-ph/9901292].   
[209] I. Musco, J.C. Miller and L. Rezzolla, Computations of primordial black hole formation, Class. Quant. Grav. 22 (2005) 1405 [gr-qc/0412063].   
[210] I. Musco, J.C. Miller and A.G. Polnarev, Primordial black hole formation in the radiative era: Investigation of the critical nature of the collapse, Class. Quant. Grav. 26 (2009) 235001 [0811.1452].   
[228] D.H. Lyth, K.A. Malik and M. Sasaki, A General proof of the conservation of the curvature perturbation, JCAP 05 (2005) 004 [astro-ph/0411220].   
[229] V. Mukhanov, Physical Foundations of Cosmology, Cambridge University Press, Oxford (2005).   
[230] E. Komatsu, D.N. Spergel and B.D. Wandelt, Measuring primordial non-Gaussianity in the cosmic microwave background, Astrophys. J. 634 (2005) 14 [astro-ph/0305189].   
[231] F. Lucchin and S. Matarrese, Power Law Inflation, Phys. Rev. D 32 (1985) 1316.   
[232] J. Garriga and V.F. Mukhanov, Perturbations in k-inflation, Phys. Lett. B 458 (1999) 219 [hep-th/9904176].   
[233] A. Gervois and H. Navelet, Integrals of three bessel functions and legendre functions. i, Journal of Mathematical Physics 26 (1985) 633 [https://doi.org/10.1063/1.526600].   
[234] P. Carrilho, K.A. Malik and D.J. Mulryne, Dissecting the growth of the power spectrum for primordial black holes, Phys. Rev. D 100 (2019) 103529 [1907.05237].   
[235] M. Kawasaki, N. Sugiyama and T. Yanagida, Primordial black hole formation in a double inflation model in supergravity, Phys. Rev. D 57 (1998) 6050 [hep-ph/9710259].   
[236] P.H. Frampton, M. Kawasaki, F. Takahashi and T.T. Yanagida, Primordial Black Holes as All Dark Matter, JCAP 04 (2010) 023 [1001.2308].   
[237] M. Kawasaki, N. Kitajima and T.T. Yanagida, Primordial black hole formation from an axionlike curvaton model, Phys. Rev. D 87 (2013) 063519 [1207.2550].   
[238] K. Inomata, M. Kawasaki, K. Mukaida, Y. Tada and T.T. Yanagida, Inflationary Primordial Black Holes as All Dark Matter, Phys. Rev. D 96 (2017) 043504 [1701.02544].   
[239] S. Pi, Y.-l. Zhang, Q.-G. Huang and M. Sasaki, Scalaron from $R ^ { 2 }$ -gravity as a heavy field, JCAP 05 (2018) 042 [1712.09896].   
[240] Y.-F. Cai, X. Tong, D.-G. Wang and S.-F. Yan, Primordial Black Holes from Sound Speed Resonance during Inflation, Phys. Rev. Lett. 121 (2018) 081306 [1805.03639].   
[241] C. Chen and Y.-F. Cai, Primordial black holes from sound speed resonance in the inflaton-curvaton mixed scenario, JCAP 10 (2019) 068 [1908.03942].   
[242] C. Chen, X.-H. Ma and Y.-F. Cai, Dirac-Born-Infeld realization of sound speed resonance mechanism for primordial black holes, Phys. Rev. D 102 (2020) 063526 [2003.03821].   
[243] A. Ashoorioon, A. Rostami and J.T. Firouzjaee, EFT compatible PBHs: effective spawning of the seeds for primordial black holes during inflation, JHEP 07 (2021) 087 [1912.13326].   
[244] J. Garcia-Bellido, A.D. Linde and D. Wands, Density perturbations and black hole formation in hybrid inflation, Phys. Rev. D 54 (1996) 6040 [astro-ph/9605094].   
[245] J. Yokoyama, Chaotic new inflation and formation of primordial black holes, Phys. Rev. D 58 (1998) 083510 [astro-ph/9802357].   
[246] K. Kohri, C.-M. Lin and T. Matsuda, Primordial black holes from the inflating curvaton, Phys. Rev. D 87 (2013) 103527 [1211.2371].   
[247] S. Clesse and J. García-Bellido, Massive Primordial Black Holes from Hybrid Inflation as Dark Matter and the seeds of Galaxies, Phys. Rev. D 92 (2015) 023524 [1501.07565].   
[248] S.-L. Cheng, W. Lee and K.-W. Ng, Production of high stellar-mass primordial black holes in trapped inflation, JHEP 02 (2017) 008 [1606.00206].   
[249] J.R. Espinosa, D. Racco and A. Riotto, Cosmological Signature of the Standard Model Higgs Vacuum Instability: Primordial Black Holes as Dark Matter, Phys. Rev. Lett. 120 (2018) 121301 [1710.11196].   
[250] K. Kannike, L. Marzola, M. Raidal and H. Veermäe, Single Field Double Inflation and Primordial Black Holes, JCAP 09 (2017) 020 [1705.06225].   
[251] J. Garcia-Bellido and E. Ruiz Morales, Primordial black holes from single field models of inflation, Phys. Dark Univ. 18 (2017) 47 [1702.03901].   
[252] S.-L. Cheng, W. Lee and K.-W. Ng, Primordial black holes and associated gravitational waves in axion monodromy inflation, JCAP 07 (2018) 001 [1801.09050].   
[253] K. Inomata, M. Kawasaki, K. Mukaida and T.T. Yanagida, Double inflation as a single origin of primordial black holes for all dark matter and LIGO observations, Phys. Rev. D 97 (2018) 043514 [1711.06129].   
[254] G.A. Palma, S. Sypsas and C. Zenteno, Seeding primordial black holes in multifield inflation, Phys. Rev. Lett. 125 (2020) 121301 [2004.06106].   
[255] J. Fumagalli, S. Renaux-Petel, J.W. Ronayne and L.T. Witkowski, Turning in the landscape: a new mechanism for generating Primordial Black Holes, 2004.08369.   
[256] V. Atal and C. Germani, The role of non-gaussianities in Primordial Black Hole formation, Phys. Dark Univ. 24 (2019) 100275 [1811.07857].   
[257] X. Chen, Primordial Non-Gaussianities from Inflation Models, Adv. Astron. 2010 (2010) 638979 [1002.1416].   
[258] J. Chluba, J. Hamann and S.P. Patil, Features and New Physical Scales in Primordial Observables: Theory and Observation, Int. J. Mod. Phys. D 24 (2015) 1530023 [1505.01834].   
[259] A. Slosar et al., Scratches from the Past: Inflationary Archaeology through Features in the Power Spectrum of Primordial Fluctuations, 1903.09883.   
[260] A.A. Starobinsky, Spectrum of adiabatic perturbations in the universe when there are singularities in the inflation potential, JETP Lett. 55 (1992) 489.   
[261] J.A. Adams, B. Cresswell and R. Easther, Inflationary perturbations from a potential with a step, Phys. Rev. D 64 (2001) 123514 [astro-ph/0102236].   
[262] R. Bean, X. Chen, G. Hailu, S.H.H. Tye and J. Xu, Duality Cascade in Brane Inflation, JCAP 03 (2008) 026 [0802.0491].   
[263] P. Adshead, C. Dvorkin, W. Hu and E.A. Lim, Non-Gaussianity from Step Features in the Inflationary Potential, Phys. Rev. D 85 (2012) 023531 [1110.3050].   
[264] N. Bartolo, D. Cannone and S. Matarrese, The Effective Field Theory of Inflation Models with Sharp Features, JCAP 10 (2013) 038 [1307.3483].   
[265] G.A. Palma, Untangling features in the primordial spectra, JCAP 04 (2015) 035 [1412.5615].   
[266] G. Ballesteros, J. Beltran Jimenez and M. Pieroni, Black hole formation from a general quadratic action for inflationary primordial fluctuations, JCAP 06 (2019) 016 [1811.03065].   
[267] K. Kefala, G.P. Kodaxis, I.D. Stamou and N. Tetradis, Features of the inflaton potential and the power spectrum of cosmological perturbations, 2010.12483.   
[268] A. Achucarro, J.-O. Gong, S. Hardeman, G.A. Palma and S.P. Patil, Features of heavy physics in the CMB power spectrum, JCAP 01 (2011) 030 [1010.3693].   
[269] G. Shiu and J. Xu, Effective Field Theory and Decoupling in Multi-field Inflation: An Illustrative Case Study, Phys. Rev. D 84 (2011) 103509 [1108.0981].   
[270] X. Gao, D. Langlois and S. Mizuno, Influence of heavy modes on perturbations in multiple field inflation, JCAP 10 (2012) 040 [1205.5275].   
[271] C. Pahud, M. Kamionkowski and A.R. Liddle, Oscillations in the inflaton potential?, Phys. Rev. D 79 (2009) 083503 [0807.0322].   
[272] X. Chen, R. Easther and E.A. Lim, Generation and Characterization of Large Non-Gaussianities in Single Field Inflation, JCAP 04 (2008) 010 [0801.3295].   
[273] E. Silverstein and A. Westphal, Monodromy in the CMB: Gravity Waves and String Inflation, Phys. Rev. D 78 (2008) 106003 [0803.3085].   
[274] R. Flauger, L. McAllister, E. Pajer, A. Westphal and G. Xu, Oscillations in the CMB from Axion Monodromy Inflation, JCAP 06 (2010) 009 [0907.2916].   
[275] X. Chen and M.H. Namjoo, Standard Clock in Primordial Density Perturbations and Cosmic Microwave Background, Phys. Lett. B 739 (2014) 285 [1404.1536].   
[276] X. Chen, M.H. Namjoo and Y. Wang, Models of the Primordial Standard Clock, JCAP 02 (2015) 027 [1411.2349].   
[277] X. Gao and J.-O. Gong, Towards general patterns of features in multi-field inflation, JHEP 08 (2015) 115 [1506.08894].

[278] Q.-G. Huang and S. Pi, Power-law modulation of the scalar power spectrum from a heavy field with a monomial potential, JCAP 04 (2018) 001 [1610.00115].

[279] G. Domènech, J. Rubio and J. Wons, Mimicking features in alternatives to inflation with interacting spectator fields, Phys. Lett. B 790 (2019) 263 [1811.08224].   
[280] X. Chen, A. Loeb and Z.-Z. Xianyu, Unique Fingerprints of Alternatives to Inflation in the Primordial Power Spectrum, Phys. Rev. Lett. 122 (2019) 121301 [1809.02603].   
[281] S. Young and C.T. Byrnes, Primordial black holes in non-Gaussian regimes, JCAP 08 (2013) 052 [1307.4995].   
[282] V. Atal, J. Garriga and A. Marcos-Caballero, Primordial black hole formation with non-Gaussian curvature perturbations, $J C A P$ 09 (2019) 073 [1905.13202].   
[283] V. De Luca, G. Franciolini, A. Kehagias, M. Peloso, A. Riotto and C. Ünal, The Ineludible non-Gaussianity of the Primordial Black Hole Abundance, JCAP 07 (2019) 048 [1904.00970].   
[284] M. Kawasaki and H. Nakatsuka, Effect of nonlinearity between density and curvature perturbations on the primordial black hole formation, Phys. Rev. D 99 (2019) 123501 [1903.02994].   
[285] H. Kodama and M. Sasaki, Evolution of Isocurvature Perturbations. 1. Photon - Baryon Universe, Int. J. Mod. Phys. A 1 (1986) 265.   
[286] H. Kodama and M. Sasaki, Evolution of Isocurvature Perturbations. 2. Radiation Dust Universe, Int. J. Mod. Phys. A 2 (1987) 491.   
[287] D. Hooper, G. Krnjaic and S.D. McDermott, Dark Radiation and Superheavy Dark Matter from Black Hole Domination, JHEP 08 (2019) 001 [1905.01301].   
[288] R. Dong, W.H. Kinney and D. Stojkovic, Gravitational wave production by Hawking radiation from rotating primordial black holes, JCAP 10 (2016) 034 [1511.05642].   
[289] A. Arbey, J. Auffinger and J. Silk, Evolution of primordial black hole spin due to Hawking radiation, Mon. Not. Roy. Astron. Soc. 494 (2020) 1257 [1906.04196].   
[290] F. Kuhnel, Enhanced Detectability of Spinning Primordial Black Holes, Eur. Phys. J. $C$ 80 (2020) 243 [1909.04742].   
[291] A. Arbey, J. Auffinger, P. Sandick, B. Shams Es Haghi and K. Sinha, Precision Calculation of Dark Radiation from Spinning Primordial Black Holes and Early Matter Dominated Eras, 2104.04051.   
[292] I. Masina, Dark matter and dark radiation from evaporating Kerr primordial black holes, 2103.13825.   
[293] L. Husdal, On Effective Degrees of Freedom in the Early Universe, Galaxies 4 (2016) 78 [1609.04979].   
[294] K. Saikawa and S. Shirai, Primordial gravitational waves, precisely: The role of thermodynamics in the Standard Model, $J C A P$ 05 (2018) 035 [1803.01038].   
[295] M. Kawasaki, K. Kohri and N. Sugiyama, Cosmological constraints on late time entropy production, Phys. Rev. Lett. 82 (1999) 4168 [astro-ph/9811437].   
[296] M. Kawasaki, K. Kohri and N. Sugiyama, MeV scale reheating temperature and thermalization of neutrino background, Phys. Rev. D 62 (2000) 023506 [astro-ph/0002127].   
[297] S. Hannestad, What is the lowest possible reheating temperature?, Phys. Rev. D 70 (2004) 043506 [astro-ph/0403291].   
[298] T. Hasegawa, N. Hiroshima, K. Kohri, R.S.L. Hansen, T. Tram and S. Hannestad, MeV-scale reheating temperature and thermalization of oscillating neutrinos by radiative and hadronic decays of massive particles, JCAP 12 (2019) 012 [1908.10189].   
[299] R.H. Cyburt, B.D. Fields, K.A. Olive and E. Skillman, New BBN limits on physics beyond the standard model from $^ 4$ He, Astropart. Phys. 23 (2005) 313 [astro-ph/0408033].   
[300] B.D. Fields, K.A. Olive, T.-H. Yeh and C. Young, Big-Bang Nucleosynthesis after Planck, JCAP 03 (2020) 010 [1912.01132].   
[301] I. Sendra and T.L. Smith, Improved limits on short-wavelength gravitational waves from the cosmic microwave background, Phys. Rev. D 85 (2012) 123002 [1203.4232].   
[302] L. Pagano, L. Salvati and A. Melchiorri, New constraints on primordial gravitational waves from Planck 2015, Phys. Lett. B 760 (2016) 823 [1508.02393].   
[303] CMB-S4 collaboration, CMB-S4 Science Book, First Edition, 1610.02743.   
[304] M.-a. Watanabe, S. Kanno and J. Soda, The Nature of Primordial Fluctuations from Anisotropic Inflation, Prog. Theor. Phys. 123 (2010) 1041 [1003.0056].   
[305] J. Soda, Statistical Anisotropy from Anisotropic Inflation, Class. Quant. Grav. 29 (2012) 083001 [1201.6434].   
[306] A. Naruko, C. Pitrou, K. Koyama and M. Sasaki, Second-order Boltzmann equation: gauge dependence and gauge invariance, Class. Quant. Grav. 30 (2013) 165008 [1304.6929].   
[307] R. Saito, A. Naruko, T. Hiramatsu and M. Sasaki, Geodesic curve-of-sight formulae for the cosmic microwave background: a unified treatment of redshift, time delay, and lensing, JCAP 10 (2014) 051 [1409.2464].   
[308] T. Namikawa, A. Naruko, R. Saito, A. Taruya and D. Yamauchi, Unified approach to secondary effects on the CMB B-mode polarization, 2103.10639.   
[309] T. Nakamura, M. Sasaki, T. Tanaka and K.S. Thorne, Gravitational waves from coalescing black hole MACHO binaries, Astrophys. J. Lett. 487 (1997) L139 [astro-ph/9708060].   
[310] LIGO Scientific, Virgo collaboration, GW170817: Observation of Gravitational Waves from a Binary Neutron Star Inspiral, Phys. Rev. Lett. 119 (2017) 161101 [1710.05832].   
[311] V. Mandic, S. Bird and I. Cholis, Stochastic Gravitational-Wave Background due to Primordial Binary Black Hole Mergers, Phys. Rev. Lett. 117 (2016) 201102 [1608.06699].   
[312] S. Wang, Y.-F. Wang, Q.-G. Huang and T.G.F. Li, Constraints on the Primordial Black Hole Abundance from the First Advanced LIGO Observation Run Using the Stochastic Gravitational-Wave Background, Phys. Rev. Lett. 120 (2018) 191102 [1610.08725].   
[313] M. Sasaki, T. Suyama, T. Tanaka and S. Yokoyama, Primordial Black Hole Scenario for the Gravitational-Wave Event GW150914, Phys. Rev. Lett. 117 (2016) 061101 [1603.08338].   
[314] S. Bird, I. Cholis, J.B. Muñoz, Y. Ali-Haïmoud, M. Kamionkowski, E.D. Kovetz et al., Did LIGO detect dark matter?, Phys. Rev. Lett. 116 (2016) 201301 [1603.00464].   
[315] Y. Ali-Haïmoud, E.D. Kovetz and M. Kamionkowski, Merger rate of primordial black-hole binaries, Phys. Rev. D 96 (2017) 123523 [1709.06576].   
[316] J. Garriga and N. Triantafyllou, Enhanced cosmological perturbations and the merger rate of PBH binaries, JCAP 09 (2019) 043 [1907.01455].   
[317] M. Peloso, L. Sorbo and C. Unal, Rolling axions during inflation: perturbativity and signatures, JCAP 09 (2016) 001 [1606.00459].   
[318] A. Hall, A.D. Gow and C.T. Byrnes, Bayesian analysis of LIGO-Virgo mergers: Primordial vs. astrophysical black hole populations, Phys. Rev. D 102 (2020) 123524 [2008.13704].   
[319] V. De Luca, G. Franciolini, P. Pani and A. Riotto, Bayesian Evidence for Both Astrophysical and Primordial Black Holes: Mapping the GWTC-2 Catalog to Third-Generation Detectors, JCAP 05 (2021) 003 [2102.03809].   
[320] G. Franciolini, V. Baibhav, V. De Luca, K.K.Y. Ng, K.W.K. Wong, E. Berti et al., Quantifying the evidence for primordial black holes in LIGO/Virgo gravitational-wave data, 2105.03349.   
[321] H. Niikura, M. Takada, S. Yokoyama, T. Sumi and S. Masaki, Constraints on Earth-mass primordial black holes from OGLE 5-year microlensing events, Phys. Rev. D 99 (2019) 083503 [1901.07120].   
[322] P. Mróz, A. Udalski, J. Skowron, R. Poleski, S. Kozłowski, M.K. Szymański et al., No large population of unbound or wide-orbit jupiter-mass planets, Nature D85 (548) 183 [1707.07634].   
[323] S. Sugiyama, V. Takhistov, E. Vitagliano, A. Kusenko, M. Sasaki and M. Takada, Testing Stochastic Gravitational Wave Signals from Primordial Black Holes with Optical Telescopes, Phys. Lett. B 814 (2021) 136097 [2010.02189].   
[324] LIGO Scientific, Virgo collaboration, Search for the isotropic stochastic background using data from Advanced LIGO’s second observing run, Phys. Rev. D 100 (2019) 061101 [1903.02886].   
[325] S.J. Kapadia, K.L. Pandey, T. Suyama, S. Kandhasamy and P. Ajith, Search for the stochastic gravitational-wave background induced by primordial curvature perturbations in LIGO’s second observing run, 2009.05514.   
[326] A. Romero-Rodriguez, M. Martinez, O. Pujolàs, M. Sakellariadou and V. Vaskonen, Search for a scalar induced stochastic gravitational wave background in the third LIGO-Virgo observing run, 2107.11660.   
[327] NANOGRAV collaboration, The NANOGrav 11-year Data Set: Pulsar-timing Constraints On The Stochastic Gravitational-wave Background, Astrophys. J. 859 (2018) 47 [1801.02617].   
[328] J. Ellis and M. Lewicki, Cosmic String Interpretation of NANOGrav Pulsar Timing Data, Phys. Rev. Lett. 126 (2021) 041304 [2009.06555].   
[329] S. Blasi, V. Brdar and K. Schmitz, Has NANOGrav found first evidence for cosmic strings?, Phys. Rev. Lett. 126 (2021) 041305 [2009.06607].   
[330] W. Buchmuller, V. Domcke and K. Schmitz, From NANOGrav to LIGO with metastable cosmic strings, Phys. Lett. B 811 (2020) 135914 [2009.10649].   
[331] R. Samanta and S. Datta, Gravitational wave complementarity and impact of NANOGrav data on gravitational leptogenesis, JHEP 05 (2021) 211 [2009.13452].   
[332] Y. Nakai, M. Suzuki, F. Takahashi and M. Yamada, Gravitational Waves and Dark Radiation from Dark Phase Transition: Connecting NANOGrav Pulsar Timing Data and Hubble Tension, Phys. Lett. B 816 (2021) 136238 [2009.09754].   
[333] A. Addazi, Y.-F. Cai, Q. Gan, A. Marciano and K. Zeng, NANOGrav results and dark first order phase transitions, Sci. China Phys. Mech. Astron. 64 (2021) 290411 [2009.10327].   
[334] A. Neronov, A. Roper Pol, C. Caprini and D. Semikoz, NANOGrav signal from magnetohydrodynamic turbulence at the QCD phase transition in the early Universe, Phys. Rev. D 103 (2021) 041302 [2009.14174].   
[335] W. Ratzinger and P. Schwaller, Whispers from the dark side: Confronting light new physics with NANOGrav data, SciPost Phys. 10 (2021) 047 [2009.11875].   
[336] L. Bian, R.-G. Cai, J. Liu, X.-Y. Yang and R. Zhou, Evidence for different gravitational-wave sources in the NANOGrav dataset, Phys. Rev. D 103 (2021) L081301 [2009.13893].   
[337] H.-H. Li, G. Ye and Y.-S. Piao, Is the NANOGrav signal a hint of dS decay during inflation?, Phys. Lett. B 816 (2021) 136211 [2009.14663].   
[338] J. Liu, R.-G. Cai and Z.-K. Guo, Large Anisotropies of the Stochastic Gravitational Wave Background from Cosmic Domain Walls, Phys. Rev. Lett. 126 (2021) 141303 [2010.03225].   
[339] A. Paul, U. Mukhopadhyay and D. Majumdar, Gravitational Wave Signatures from Domain Wall and Strong First-Order Phase Transitions in a Two Complex Scalar extension of the Standard Model, JHEP 05 (2021) 223 [2010.03439].   
[340] B. Spokoiny, Deflationary universe scenario, Phys. Lett. B 315 (1993) 40 [gr-qc/9306008].   
[341] P.J.E. Peebles and A. Vilenkin, Quintessential inflation, Phys. Rev. D 59 (1999) 063505 [astro-ph/9810509].   
[342] P. Brax and J. Martin, Coupling quintessence to inflation in supergravity, Phys. Rev. D 71 (2005) 063530 [astro-ph/0502069].   
[343] M.W. Hossain, R. Myrzakulov, M. Sami and E.N. Saridakis, Variable gravity: A suitable framework for quintessential inflation, Phys. Rev. D 90 (2014) 023512 [1402.6661].   
[344] J. Martin, T. Papanikolaou, L. Pinol and V. Vennin, Metric preheating and radiative decay in single-field inflation, JCAP 05 (2020) 003 [2002.01820].   
[345] C. Deffayet, G. Esposito-Farese and D.A. Steer, Counting the degrees of freedom of generalized Galileons, Phys. Rev. D 92 (2015) 084013 [1506.01974].   
[346] “NIST Digital Library of Mathematical Functions.” http://dlmf.nist.gov/, Release 1.0.24 of 2019-09-15.